/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.tcp;

import com.sun.grizzly.tcp.CompletionHandler;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.util.LoggerUtils;
import java.io.IOException;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;

public class SuspendedResponse<A>
implements Runnable {
    private A attachment;
    private CompletionHandler<? super A> completionHandler;
    private long timeout;
    private Response response;
    protected ScheduledFuture future;

    public SuspendedResponse(long timeout, A attachment, CompletionHandler<? super A> completionHandler, Response response) {
        this.timeout = timeout;
        this.attachment = attachment;
        this.completionHandler = completionHandler;
        this.response = response;
    }

    public A getAttachment() {
        return this.attachment;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public CompletionHandler<? super A> getCompletionHandler() {
        return this.completionHandler;
    }

    public void setCompletionHandler(CompletionHandler<? super A> completionHandler) {
        this.completionHandler = completionHandler;
    }

    public void resume() {
        if (this.future != null) {
            this.future.cancel(false);
        }
        this.completionHandler.resumed(this.attachment);
        try {
            this.response.sendHeaders();
            this.response.flush();
            this.response.finish();
        }
        catch (IOException ex) {
            LoggerUtils.getLogger().log(Level.FINEST, "resume", ex);
        }
    }

    public void timeout() {
        this.timeout(true);
    }

    public void timeout(boolean forceClose) {
        if (this.future != null && !this.future.isDone()) {
            this.future.cancel(false);
        }
        this.doTimeout(forceClose);
    }

    @Override
    public void run() {
        this.doTimeout(true);
    }

    public ScheduledFuture getFuture() {
        return this.future;
    }

    public void setFuture(ScheduledFuture future) {
        this.future = future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTimeout(boolean forceClose) {
        try {
            this.completionHandler.cancelled(this.attachment);
        }
        finally {
            if (forceClose && !this.response.isCommitted()) {
                try {
                    this.response.sendHeaders();
                    this.response.flush();
                    this.response.finish();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

