/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.tcp.http11.filters;

import com.sun.grizzly.tcp.OutputBuffer;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.OutputFilter;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.HexUtils;
import java.io.IOException;

public class ChunkedOutputFilter
implements OutputFilter {
    protected static final String ENCODING_NAME = "chunked";
    protected static final ByteChunk ENCODING = new ByteChunk();
    protected static final ByteChunk END_CHUNK = new ByteChunk();
    protected OutputBuffer buffer;
    protected byte[] chunkLength = new byte[10];
    protected ByteChunk chunkHeader = new ByteChunk();

    public ChunkedOutputFilter() {
        this.chunkLength = new byte[10];
        this.chunkLength[8] = 13;
        this.chunkLength[9] = 10;
    }

    @Override
    public int doWrite(ByteChunk chunk, Response res) throws IOException {
        int result = chunk.getLength();
        if (result <= 0) {
            return 0;
        }
        int pos = 7;
        for (int current = result; current > 0; current /= 16) {
            int digit = current % 16;
            this.chunkLength[pos--] = HexUtils.HEX[digit];
        }
        this.chunkHeader.setBytes(this.chunkLength, pos + 1, 9 - pos);
        this.buffer.doWrite(this.chunkHeader, res);
        this.buffer.doWrite(chunk, res);
        this.chunkHeader.setBytes(this.chunkLength, 8, 2);
        this.buffer.doWrite(this.chunkHeader, res);
        return result;
    }

    @Override
    public void setResponse(Response response) {
    }

    @Override
    public void setBuffer(OutputBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public long end() throws IOException {
        this.buffer.doWrite(END_CHUNK, null);
        return 0L;
    }

    @Override
    public void recycle() {
    }

    @Override
    public ByteChunk getEncodingName() {
        return ENCODING;
    }

    static {
        ENCODING.setBytes(ENCODING_NAME.getBytes(), 0, ENCODING_NAME.length());
        String endChunkValue = "0\r\n\r\n";
        END_CHUNK.setBytes(endChunkValue.getBytes(), 0, endChunkValue.length());
    }
}

