/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.tcp.http11.filters;

import com.sun.grizzly.tcp.OutputBuffer;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.OutputFilter;
import com.sun.grizzly.util.buf.ByteChunk;
import java.io.IOException;

public class IdentityOutputFilter
implements OutputFilter {
    protected static final String ENCODING_NAME = "identity";
    protected static final ByteChunk ENCODING = new ByteChunk();
    protected long contentLength = -1L;
    protected long remaining = 0L;
    protected OutputBuffer buffer;

    public long getContentLength() {
        return this.contentLength;
    }

    public long getRemaining() {
        return this.remaining;
    }

    @Override
    public int doWrite(ByteChunk chunk, Response res) throws IOException {
        int result = -1;
        if (this.contentLength >= 0L) {
            if (this.remaining > 0L) {
                result = chunk.getLength();
                if ((long)result > this.remaining) {
                    chunk.setBytes(chunk.getBytes(), chunk.getStart(), (int)this.remaining);
                    result = (int)this.remaining;
                    this.remaining = 0L;
                } else {
                    this.remaining -= (long)result;
                }
                this.buffer.doWrite(chunk, res);
            } else {
                chunk.recycle();
                result = -1;
            }
        } else {
            this.buffer.doWrite(chunk, res);
            result = chunk.getLength();
        }
        return result;
    }

    @Override
    public void setResponse(Response response) {
        this.remaining = this.contentLength = (long)response.getContentLength();
    }

    @Override
    public void setBuffer(OutputBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public long end() throws IOException {
        if (this.remaining > 0L) {
            return this.remaining;
        }
        return 0L;
    }

    @Override
    public void recycle() {
        this.contentLength = -1L;
        this.remaining = 0L;
    }

    @Override
    public ByteChunk getEncodingName() {
        return ENCODING;
    }

    static {
        ENCODING.setBytes(ENCODING_NAME.getBytes(), 0, ENCODING_NAME.length());
    }
}

