/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.threadpool;

import com.sun.grizzly.Grizzly;
import com.sun.grizzly.attributes.AttributeBuilder;
import com.sun.grizzly.threadpool.DefaultWorkerThread;
import com.sun.grizzly.threadpool.ExtendedThreadPool;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class DefaultThreadPool
extends ThreadPoolExecutor
implements ExtendedThreadPool,
Thread.UncaughtExceptionHandler {
    private static int DEFAULT_MIN_THREAD_COUNT = 5;
    private static int DEFAULT_MAX_THREAD_COUNT = 20;
    private static int DEFAULT_MAX_TASKS_QUEUED = Integer.MAX_VALUE;
    private static int DEFAULT_IDLE_THREAD_KEEPALIVE_TIMEOUT = 30000;
    protected AttributeBuilder attributeBuilder = Grizzly.DEFAULT_ATTRIBUTE_BUILDER;
    private String name = "Grizzly";
    private int maxTasksCount;
    private AtomicInteger workerThreadCounter = new AtomicInteger();

    public DefaultThreadPool() {
        this(DEFAULT_MIN_THREAD_COUNT, DEFAULT_MAX_THREAD_COUNT, DEFAULT_MAX_TASKS_QUEUED, DEFAULT_IDLE_THREAD_KEEPALIVE_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public DefaultThreadPool(int corePoolSize, int maximumPoolSize, int maxTasksCount, long keepAliveTime, TimeUnit unit) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new LinkedBlockingQueue<Runnable>(maxTasksCount));
        this.setThreadFactory(new DefaultWorkerThreadFactory(this));
        this.maxTasksCount = maxTasksCount;
    }

    public int getQueuedTasksCount() {
        return this.getQueue().size();
    }

    public int getMaxQueuedTasksCount() {
        return this.maxTasksCount;
    }

    public void setMaxQueuedTasksCount(int maxTasksCount) {
        throw new UnsupportedOperationException("Value could not be changed!");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getQueueSize() {
        return this.getQueue().size();
    }

    public void start() {
        this.prestartCoreThread();
    }

    public void stop() {
        this.shutdownNow();
    }

    @Override
    public AttributeBuilder getAttributeBuilder() {
        return this.attributeBuilder;
    }

    @Override
    public void setAttributeBuilder(AttributeBuilder attributeBuilder) {
        this.attributeBuilder = attributeBuilder;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        Grizzly.logger.log(Level.WARNING, "Uncaught thread exception. Thread: " + thread, throwable);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        ((DefaultWorkerThread)t).onBeforeRun();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        ((DefaultWorkerThread)Thread.currentThread()).onAfterRun();
    }

    private static class DefaultWorkerThreadFactory
    implements ThreadFactory {
        private DefaultThreadPool threadPool;

        public DefaultWorkerThreadFactory(DefaultThreadPool threadPool) {
            this.threadPool = threadPool;
        }

        @Override
        public Thread newThread(Runnable r) {
            DefaultWorkerThread thread = new DefaultWorkerThread(this.threadPool.getAttributeBuilder(), this.threadPool.getName() + "-WorkerThread(" + this.threadPool.workerThreadCounter.getAndIncrement() + ")", r);
            thread.setUncaughtExceptionHandler(this.threadPool);
            return thread;
        }
    }
}

