/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.ExpandJar;
import com.sun.grizzly.util.LoggerUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Level;

public class ClassLoaderUtil {
    public static final ClassLoader createClassloader(File libDir, ClassLoader cl) throws IOException {
        URLClassLoader urlClassloader = null;
        if (libDir.exists() && libDir.isDirectory()) {
            String[] jars = libDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar") || name.endsWith(".zip");
                }
            });
            URL[] urls = new URL[jars.length];
            for (int i = 0; i < jars.length; ++i) {
                String path = new File(libDir.getName() + File.separator + jars[i]).getCanonicalFile().toURL().toString();
                urls[i] = new URL(path);
            }
            urlClassloader = new URLClassLoader(urls, cl);
        }
        return urlClassloader;
    }

    public static URLClassLoader createURLClassLoader(String dirPath) throws MalformedURLException, IOException {
        String separator;
        String path;
        File file = null;
        URL appRoot = null;
        URL classesURL = null;
        if (!dirPath.endsWith(File.separator)) {
            dirPath = dirPath + File.separator;
        }
        if (dirPath != null && (dirPath.endsWith(".war") || dirPath.endsWith(".jar"))) {
            file = new File(dirPath);
            appRoot = new URL("jar:file:" + file.getCanonicalPath() + "!/");
            classesURL = new URL("jar:file:" + file.getCanonicalPath() + "!/WEB-INF/classes/");
            path = ExpandJar.expand(appRoot);
        } else {
            path = dirPath;
            classesURL = new URL("file://" + path + "WEB-INF/classes/");
            appRoot = new URL("file://" + path);
        }
        String absolutePath = new File(path).getAbsolutePath();
        URL[] urls = null;
        File libFiles = new File(absolutePath + File.separator + "WEB-INF" + File.separator + "lib");
        int arraySize = appRoot == null ? 1 : 2;
        String string = separator = System.getProperty("os.name").toLowerCase().startsWith("win") ? "/" : "//";
        if (libFiles.exists() && libFiles.isDirectory()) {
            urls = new URL[libFiles.listFiles().length + arraySize];
            for (int i = 0; i < libFiles.listFiles().length; ++i) {
                urls[i] = new URL("jar:file:" + separator + libFiles.listFiles()[i].toString().replace('\\', '/') + "!/");
            }
        } else {
            urls = new URL[arraySize];
        }
        urls[urls.length - 1] = classesURL;
        urls[urls.length - 2] = appRoot;
        URLClassLoader urlClassloader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        return urlClassloader;
    }

    public static Object load(String clazzName) {
        return ClassLoaderUtil.load(clazzName, Thread.currentThread().getContextClassLoader());
    }

    public static Object load(String clazzName, ClassLoader classLoader) {
        Class<?> className = null;
        try {
            className = Class.forName(clazzName, true, classLoader);
            return className.newInstance();
        }
        catch (Throwable t) {
            LoggerUtils.getLogger().log(Level.SEVERE, "Unable to load class " + clazzName, t);
            return null;
        }
    }
}

