/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util.http;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class AcceptLanguage {
    public static Locale getLocale(String acceptLanguage) {
        if (acceptLanguage == null) {
            return Locale.getDefault();
        }
        Hashtable<String, Vector<String>> languages = new Hashtable<String, Vector<String>>();
        Vector<Double> quality = new Vector<Double>();
        AcceptLanguage.processAcceptLanguage(acceptLanguage, languages, quality);
        if (languages.size() == 0) {
            return Locale.getDefault();
        }
        Vector<Locale> l = new Vector<Locale>();
        AcceptLanguage.extractLocales(languages, quality, l);
        return l.elementAt(0);
    }

    public static Enumeration<Locale> getLocales(String acceptLanguage) {
        if (acceptLanguage == null) {
            Vector<Locale> v = new Vector<Locale>();
            v.addElement(Locale.getDefault());
            return v.elements();
        }
        Hashtable<String, Vector<String>> languages = new Hashtable<String, Vector<String>>();
        Vector<Double> quality = new Vector<Double>();
        AcceptLanguage.processAcceptLanguage(acceptLanguage, languages, quality);
        if (languages.size() == 0) {
            Vector<Locale> v = new Vector<Locale>();
            v.addElement(Locale.getDefault());
            return v.elements();
        }
        Vector<Locale> l = new Vector<Locale>();
        AcceptLanguage.extractLocales(languages, quality, l);
        return l.elements();
    }

    private static void processAcceptLanguage(String acceptLanguage, Hashtable<String, Vector<String>> languages, Vector<Double> q) {
        StringTokenizer languageTokenizer = new StringTokenizer(acceptLanguage, ",");
        while (languageTokenizer.hasMoreTokens()) {
            Vector<Object> v;
            String language = languageTokenizer.nextToken().trim();
            int qValueIndex = language.indexOf(59);
            int qIndex = language.indexOf(113);
            int equalIndex = language.indexOf(61);
            Double qValue = new Double(1.0);
            if (qValueIndex > -1 && qValueIndex < qIndex && qIndex < equalIndex) {
                String qValueStr = language.substring(qValueIndex + 1);
                language = language.substring(0, qValueIndex);
                qValueStr = qValueStr.trim().toLowerCase();
                qValueIndex = qValueStr.indexOf(61);
                qValue = new Double(0.0);
                if (qValueStr.startsWith("q") && qValueIndex > -1) {
                    qValueStr = qValueStr.substring(qValueIndex + 1);
                    try {
                        qValue = new Double(qValueStr.trim());
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
            }
            if (language.equals("*")) continue;
            String key = qValue.toString();
            if (languages.containsKey(key)) {
                v = languages.get(key);
            } else {
                v = new Vector();
                q.addElement(qValue);
            }
            v.addElement(language);
            languages.put(key, v);
        }
    }

    private static void extractLocales(Hashtable<String, Vector<String>> languages, Vector<Double> q, Vector<Locale> l) {
        Enumeration<Double> e = q.elements();
        while (e.hasMoreElements()) {
            Vector<String> v = languages.get(e.nextElement().toString());
            Enumeration<String> le = v.elements();
            while (le.hasMoreElements()) {
                String language = le.nextElement();
                String country = "";
                int countryIndex = language.indexOf("-");
                if (countryIndex > -1) {
                    country = language.substring(countryIndex + 1).trim();
                    language = language.substring(0, countryIndex).trim();
                }
                l.addElement(new Locale(language, country));
            }
        }
    }
}

