/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util.net.jsse;

import com.sun.grizzly.util.net.SSLImplementation;
import com.sun.grizzly.util.net.SSLSupport;
import com.sun.grizzly.util.net.ServerSocketFactory;
import com.sun.grizzly.util.net.jsse.JSSEFactory;
import java.net.Socket;
import javax.net.ssl.SSLEngine;

public class JSSEImplementation
extends SSLImplementation {
    static final String JSSE14Factory = "com.sun.grizzly.util.net.jsse.JSSE14Factory";
    static final String SSLSocketClass = "javax.net.ssl.SSLSocket";
    private JSSEFactory factory;

    public JSSEImplementation() throws ClassNotFoundException {
        Class.forName(SSLSocketClass);
        try {
            Class<?> factcl = Class.forName(JSSE14Factory);
            this.factory = (JSSEFactory)factcl.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String getImplementationName() {
        return "JSSE";
    }

    @Override
    public ServerSocketFactory getServerSocketFactory() {
        ServerSocketFactory ssf = this.factory.getSocketFactory();
        return ssf;
    }

    @Override
    public SSLSupport getSSLSupport(Socket s) {
        SSLSupport ssls = this.factory.getSSLSupport(s);
        return ssls;
    }

    @Override
    public SSLSupport getSSLSupport(SSLEngine sslEngine) {
        return this.factory.getSSLSupport(sslEngine);
    }
}

