/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util.net.jsse;

import com.sun.grizzly.util.LoggerUtils;
import com.sun.grizzly.util.net.SSLSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

class JSSESupport
implements SSLSupport {
    private static final Logger logger = LoggerUtils.getLogger();
    protected SSLSocket ssl;
    protected SSLEngine sslEngine;
    protected SSLSession session;

    JSSESupport(SSLSocket sock) {
        this.ssl = sock;
        this.session = this.ssl.getSession();
    }

    JSSESupport(SSLEngine sslEngine) {
        this.sslEngine = sslEngine;
        this.session = sslEngine.getSession();
    }

    @Override
    public String getCipherSuite() throws IOException {
        if (this.session == null) {
            return null;
        }
        return this.session.getCipherSuite();
    }

    @Override
    public Object[] getPeerCertificateChain() throws IOException {
        return this.getPeerCertificateChain(false);
    }

    protected X509Certificate[] getX509Certificates(SSLSession session) throws IOException {
        javax.security.cert.X509Certificate[] jsseCerts = null;
        try {
            jsseCerts = session.getPeerCertificateChain();
        }
        catch (Throwable ex) {
            // empty catch block
        }
        if (jsseCerts == null) {
            jsseCerts = new javax.security.cert.X509Certificate[]{};
        }
        X509Certificate[] x509Certs = new X509Certificate[jsseCerts.length];
        for (int i = 0; i < x509Certs.length; ++i) {
            try {
                byte[] buffer = jsseCerts[i].getEncoded();
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
                x509Certs[i] = (X509Certificate)cf.generateCertificate(stream);
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.log(Level.FINE, "Cert #" + i + " = " + x509Certs[i]);
                continue;
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Error translating " + jsseCerts[i], ex);
                return null;
            }
        }
        if (x509Certs.length < 1) {
            return null;
        }
        return x509Certs;
    }

    @Override
    public Object[] getPeerCertificateChain(boolean force) throws IOException {
        if (this.session == null) {
            return null;
        }
        javax.security.cert.X509Certificate[] jsseCerts = null;
        try {
            jsseCerts = this.session.getPeerCertificateChain();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (jsseCerts == null) {
            jsseCerts = new javax.security.cert.X509Certificate[]{};
        }
        if (jsseCerts.length <= 0 && force) {
            this.session.invalidate();
            this.handShake();
            this.session = this.ssl == null ? this.sslEngine.getSession() : this.ssl.getSession();
        }
        return this.getX509Certificates(this.session);
    }

    protected void handShake() throws IOException {
        this.ssl.setNeedClientAuth(true);
        this.ssl.startHandshake();
    }

    @Override
    public Integer getKeySize() throws IOException {
        SSLSupport.CipherData[] c_aux = ciphers;
        if (this.session == null) {
            return null;
        }
        Integer keySize = (Integer)this.session.getValue("javax.servlet.request.key_size");
        if (keySize == null) {
            int size = 0;
            String cipherSuite = this.session.getCipherSuite();
            for (int i = 0; i < c_aux.length; ++i) {
                if (cipherSuite.indexOf(c_aux[i].phrase) < 0) continue;
                size = c_aux[i].keySize;
                break;
            }
            keySize = size;
            this.session.putValue("javax.servlet.request.key_size", keySize);
        }
        return keySize;
    }

    @Override
    public String getSessionId() throws IOException {
        if (this.session == null) {
            return null;
        }
        byte[] ssl_session = this.session.getId();
        if (ssl_session == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder("");
        for (int x = 0; x < ssl_session.length; ++x) {
            String digit = Integer.toHexString(ssl_session[x]);
            if (digit.length() < 2) {
                buf.append('0');
            }
            if (digit.length() > 2) {
                digit = digit.substring(digit.length() - 2);
            }
            buf.append(digit);
        }
        return buf.toString();
    }
}

