/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.utils;

import com.sun.grizzly.Buffer;
import com.sun.grizzly.Readable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ReadableInputStream
extends InputStream {
    private Buffer buffer;
    private Readable readable;
    private long timeout = 30000L;

    public Readable getReadable() {
        return this.readable;
    }

    public void setReadable(Readable readable) {
        this.readable = readable;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(Buffer buffer) {
        this.buffer = buffer;
    }

    public long getTimeout(TimeUnit unit) {
        return unit.convert(this.timeout, TimeUnit.MILLISECONDS);
    }

    public void setTimeout(long timeout, TimeUnit unit) {
        this.timeout = TimeUnit.MILLISECONDS.convert(timeout, unit);
    }

    @Override
    public int read() throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.doBlockingRead();
        }
        if (!this.buffer.hasRemaining()) {
            throw new EOFException();
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.doBlockingRead();
        }
        if (!this.buffer.hasRemaining()) {
            throw new EOFException();
        }
        int bytesToCopy = Math.min(len, this.buffer.remaining());
        this.buffer.get(b, off, bytesToCopy);
        return bytesToCopy;
    }

    @Override
    public void close() throws IOException {
        this.readable.close();
    }

    protected void doBlockingRead() throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.buffer.clear();
        }
        Future future = this.readable.read(this.buffer);
        try {
            future.get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted exception");
        }
        catch (TimeoutException e) {
            throw new EOFException();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException(cause.getClass().getName() + ": " + cause.getMessage());
        }
        finally {
            this.buffer.flip();
        }
    }
}

