/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.utils;

import com.sun.grizzly.AbstractTransformer;
import com.sun.grizzly.Buffer;
import com.sun.grizzly.Connection;
import com.sun.grizzly.TransformationException;
import com.sun.grizzly.TransformationResult;
import com.sun.grizzly.attributes.AttributeStorage;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class StringEncoder
extends AbstractTransformer<String, Buffer> {
    protected Charset charset;
    protected String stringTerminator = null;

    public StringEncoder() {
        this((String)null);
    }

    public StringEncoder(String stringTerminator) {
        this(Charset.forName("UTF-8"), null);
    }

    public StringEncoder(Charset charset) {
        this(charset, null);
    }

    public StringEncoder(Charset charset, String stringTerminator) {
        this.charset = charset;
        this.stringTerminator = stringTerminator;
    }

    @Override
    public TransformationResult<Buffer> transform(AttributeStorage storage, String input, Buffer output) throws TransformationException {
        byte[] byteRepresentation;
        if (input == null) {
            throw new TransformationException("Input could not be null");
        }
        try {
            if (this.stringTerminator != null) {
                input = input + this.stringTerminator;
            }
            byteRepresentation = input.getBytes(this.charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new TransformationException("Charset " + this.charset.name() + " is not supported", e);
        }
        if (output == null) {
            if (storage instanceof Connection) {
                output = ((Connection)storage).getTransport().getMemoryManager().allocate(byteRepresentation.length + 2);
            } else {
                this.saveState(storage, incompletedResult);
                return incompletedResult;
            }
        }
        if (this.stringTerminator == null) {
            output.putShort((short)byteRepresentation.length);
        }
        output.put(byteRepresentation);
        TransformationResult<Buffer> result = new TransformationResult<Buffer>(TransformationResult.Status.COMPLETED, output.duplicate().flip());
        this.saveState(storage, result);
        return result;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    protected void saveState(AttributeStorage storage, TransformationResult<Buffer> result) {
        this.lastResultAttribute.set(storage, result);
    }
}

