/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.utils;

import com.sun.grizzly.Buffer;
import com.sun.grizzly.Writable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class WritableOutputStream
extends OutputStream {
    private Writable writable;
    private Buffer buffer;
    private long timeout = 30000L;

    public Buffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(Buffer buffer) {
        this.buffer = buffer;
    }

    public Writable getWritable() {
        return this.writable;
    }

    public void setWritable(Writable writable) {
        this.writable = writable;
    }

    public long getTimeout(TimeUnit unit) {
        return unit.convert(this.timeout, TimeUnit.MILLISECONDS);
    }

    public void setTimeout(long timeout, TimeUnit unit) {
        this.timeout = TimeUnit.MILLISECONDS.convert(timeout, unit);
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.flush();
        }
        this.buffer.put((byte)b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int bytesToWrite;
        for (int written = 0; written < len; written += bytesToWrite) {
            if (!this.buffer.hasRemaining()) {
                this.flush();
            }
            bytesToWrite = Math.min(len - written, this.buffer.remaining());
            this.buffer.put(b, off + written, bytesToWrite);
        }
    }

    @Override
    public void flush() throws IOException {
        Future future = this.writable.write(this.buffer);
        try {
            future.get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted exception");
        }
        catch (TimeoutException e) {
            throw new IOException("Timeout excepting during flushing data");
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException(cause.getClass().getName() + ": " + cause.getMessage());
        }
        finally {
            this.buffer.clear();
        }
    }

    @Override
    public void close() throws IOException {
        this.writable.close();
    }
}

