/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.osgi;

import aQute.lib.osgi.EmbeddedResource;
import aQute.lib.osgi.Instruction;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Macro;
import aQute.lib.osgi.Processor;
import aQute.lib.osgi.Resource;
import aQute.lib.osgi.Verifier;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Analyzer
extends Processor {
    public static final String BUNDLE_CLASSPATH = "Bundle-ClassPath";
    public static final String BUNDLE_COPYRIGHT = "Bundle-Copyright";
    public static final String BUNDLE_DESCRIPTION = "Bundle-Description";
    public static final String BUNDLE_NAME = "Bundle-Name";
    public static final String BUNDLE_NATIVECODE = "Bundle-NativeCode";
    public static final String EXPORT_PACKAGE = "Export-Package";
    public static final String EXPORT_SERVICE = "Export-Service";
    public static final String IMPORT_PACKAGE = "Import-Package";
    public static final String DYNAMICIMPORT_PACKAGE = "DynamicImport-Package";
    public static final String IMPORT_SERVICE = "Import-Service";
    public static final String BUNDLE_VENDOR = "Bundle-Vendor";
    public static final String BUNDLE_VERSION = "Bundle-Version";
    public static final String BUNDLE_DOCURL = "Bundle-DocURL";
    public static final String BUNDLE_CONTACTADDRESS = "Bundle-ContactAddress";
    public static final String BUNDLE_ACTIVATOR = "Bundle-Activator";
    public static final String BUNDLE_REQUIREDEXECUTIONENVIRONMENT = "Bundle-RequiredExecutionEnvironment";
    public static final String BUNDLE_SYMBOLICNAME = "Bundle-SymbolicName";
    public static final String BUNDLE_LOCALIZATION = "Bundle-Localization";
    public static final String REQUIRE_BUNDLE = "Require-Bundle";
    public static final String FRAGMENT_HOST = "Fragment-Host";
    public static final String BUNDLE_MANIFESTVERSION = "Bundle-ManifestVersion";
    public static final String SERVICE_COMPONENT = "Service-Component";
    public static final String BUNDLE_LICENSE = "Bundle-License";
    public static final String PRIVATE_PACKAGE = "Private-Package";
    public static final String IGNORE_PACKAGE = "Ignore-Package";
    public static final String INCLUDE_RESOURCE = "Include-Resource";
    public static final String CONDITIONAL_PACKAGE = "Conditional-Package";
    public static final String BND_LASTMODIFIED = "Bnd-LastModified";
    public static final String CREATED_BY = "Created-By";
    public static final String TOOL = "Tool";
    public static final String[] headers = new String[]{"Bundle-Activator", "Bundle-ContactAddress", "Bundle-Copyright", "Bundle-DocURL", "Bundle-Localization", "Bundle-NativeCode", "Bundle-Vendor", "Bundle-Version", "Bundle-License", "Bundle-ClassPath", "Service-Component", "Export-Package", "Import-Package", "Bundle-Localization", "Bundle-ManifestVersion", "Bundle-Name", "Bundle-NativeCode", "Bundle-RequiredExecutionEnvironment", "Bundle-SymbolicName", "Bundle-Version", "Fragment-Host", "Private-Package", "Ignore-Package", "Include-Resource", "Require-Bundle", "Import-Service", "Export-Service", "Conditional-Package", "Bnd-LastModified"};
    static final Pattern VALID_PROPERTY_TYPES = Pattern.compile("(String|Long|Double|Float|Integer|Byte|Character|Boolean|Short)");
    static Pattern doNotCopy = Pattern.compile("CVS|.svn");
    static String version;
    static Pattern versionPattern;
    Properties properties = new Properties();
    File base = new File("").getAbsoluteFile();
    Map contained = new HashMap();
    Map referred = new HashMap();
    Map uses = new HashMap();
    Map classspace;
    boolean analyzed;
    Map exports;
    Map imports;
    Map bundleClasspath;
    Map ignored = new HashMap();
    Jar dot;
    Map cpExports = new HashMap();
    String activator;
    List classpath = new ArrayList();
    Macro replacer = new Macro(this);
    long lastModified;
    Manifest bndManifest;
    boolean noExtraHeaders;

    static {
        versionPattern = Pattern.compile("(\\d+\\.\\d+)\\.\\d+");
    }

    public static Properties getManifest(File dirOrJar) throws IOException {
        Analyzer analyzer = new Analyzer();
        analyzer.setJar(dirOrJar);
        Properties properties = new Properties();
        properties.put(IMPORT_PACKAGE, "*");
        properties.put(EXPORT_PACKAGE, "*");
        analyzer.setProperties(properties);
        Manifest m = analyzer.calcManifest();
        Properties result = new Properties();
        Iterator<Object> i = m.getMainAttributes().keySet().iterator();
        while (i.hasNext()) {
            Attributes.Name name = (Attributes.Name)i.next();
            result.put(name.toString(), m.getMainAttributes().getValue(name));
        }
        return result;
    }

    public void analyze() throws IOException {
        if (!this.analyzed) {
            this.analyzed = true;
            this.cpExports = new HashMap();
            this.activator = this.getProperty(BUNDLE_ACTIVATOR);
            this.bundleClasspath = this.parseHeader(this.getProperty(BUNDLE_CLASSPATH));
            this.analyzeClasspath();
            this.classspace = this.analyzeBundleClasspath(this.dot, this.bundleClasspath, this.contained, this.referred, this.uses);
            this.referred.keySet().removeAll(this.contained.keySet());
            Map exportInstructions = this.parseHeader(this.getProperty(EXPORT_PACKAGE));
            Map importInstructions = this.parseHeader(this.getProperty(IMPORT_PACKAGE));
            Map dynamicImports = this.parseHeader(this.getProperty(DYNAMICIMPORT_PACKAGE));
            if (dynamicImports != null) {
                this.referred.keySet().removeAll(dynamicImports.keySet());
            }
            TreeSet<String> superfluous = new TreeSet<String>();
            Iterator i = exportInstructions.keySet().iterator();
            while (i.hasNext()) {
                String instr = (String)i.next();
                if (instr.startsWith("!")) continue;
                superfluous.add(instr);
            }
            this.exports = this.merge("export-package", exportInstructions, this.contained, superfluous);
            if (!superfluous.isEmpty()) {
                this.warnings.add("Superfluous export-package instructions: " + superfluous);
            }
            HashMap referredAndExported = new HashMap(this.referred);
            referredAndExported.putAll(this.addExportsToImports(this.exports));
            TreeSet extra = new TreeSet(importInstructions.keySet());
            this.imports = this.merge("import-package", importInstructions, referredAndExported, extra);
            Iterator i2 = extra.iterator();
            while (i2.hasNext()) {
                String p = (String)i2.next();
                if (p.startsWith("!") || p.indexOf(42) > 0 || p.indexOf(63) > 0 || p.indexOf(91) > 0) {
                    this.warning("Did not find matching referal for " + p);
                    continue;
                }
                Map map = (Map)importInstructions.get(p);
                this.imports.put(p, map);
            }
            this.augmentImports();
            this.doUses(this.exports, this.uses);
        }
    }

    public Manifest calcManifest() throws IOException {
        String exportHeader;
        this.analyze();
        Manifest manifest = new Manifest();
        Attributes main = manifest.getMainAttributes();
        main.putValue(BUNDLE_MANIFESTVERSION, "2");
        if (!this.noExtraHeaders) {
            main.putValue(CREATED_BY, String.valueOf(System.getProperty("java.version")) + " (" + System.getProperty("java.vendor") + ")");
            main.putValue(TOOL, "Bnd-" + this.getVersion());
            main.putValue(BND_LASTMODIFIED, "" + System.currentTimeMillis());
        }
        if ((exportHeader = this.printClauses(this.exports, "uses:|include:|exclude:|mandatory:")).length() > 0) {
            main.putValue(EXPORT_PACKAGE, exportHeader);
        } else {
            main.remove(EXPORT_PACKAGE);
        }
        TreeMap temp = Analyzer.removeKeys(this.imports, "java.");
        if (!temp.isEmpty()) {
            main.putValue(IMPORT_PACKAGE, this.printClauses(temp, "resolution:"));
        } else {
            main.remove(IMPORT_PACKAGE);
        }
        temp = new TreeMap(this.contained);
        temp.keySet().removeAll(this.exports.keySet());
        if (!temp.isEmpty()) {
            main.putValue(PRIVATE_PACKAGE, this.printClauses(temp, ""));
        } else {
            main.remove(PRIVATE_PACKAGE);
        }
        if (!this.ignored.isEmpty()) {
            main.putValue(IGNORE_PACKAGE, this.printClauses(this.ignored, ""));
        } else {
            main.remove(IGNORE_PACKAGE);
        }
        if (this.bundleClasspath != null && !this.bundleClasspath.isEmpty()) {
            main.putValue(BUNDLE_CLASSPATH, this.printClauses(this.bundleClasspath, ""));
        } else {
            main.remove(BUNDLE_CLASSPATH);
        }
        Map l = this.doServiceComponent(this.getProperty(SERVICE_COMPONENT));
        if (!l.isEmpty()) {
            main.putValue(SERVICE_COMPONENT, this.printClauses(l, ""));
        } else {
            main.remove(SERVICE_COMPONENT);
        }
        Iterator<Object> h = this.properties.keySet().iterator();
        while (h.hasNext()) {
            String value;
            String header = (String)h.next();
            if (header.trim().length() == 0) {
                this.warning("Empty property set with value: " + this.properties.getProperty(header));
                continue;
            }
            if (!Character.isUpperCase(header.charAt(0)) || header.equals(BUNDLE_CLASSPATH) || header.equals(EXPORT_PACKAGE) || header.equals(IMPORT_PACKAGE) || !Verifier.HEADER_PATTERN.matcher(header).matches() || (value = this.getProperty(header)) == null || main.getValue(header) != null) continue;
            main.putValue(header, value);
        }
        main.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        this.merge(manifest, this.dot.getManifest());
        String p = this.getProperty("p");
        if (p != null) {
            if (main.getValue(BUNDLE_SYMBOLICNAME) == null) {
                main.putValue(BUNDLE_SYMBOLICNAME, p);
            }
            if (main.getValue(BUNDLE_NAME) == null) {
                main.putValue(BUNDLE_NAME, p);
            }
        }
        if (main.getValue(BUNDLE_VERSION) == null) {
            main.putValue(BUNDLE_VERSION, "0");
        }
        this.dot.setManifest(manifest);
        return manifest;
    }

    public String calculateExportsFromContents(Jar bundle) {
        String ddel = "";
        StringBuffer sb = new StringBuffer();
        Map map = bundle.getDirectories();
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String directory = (String)i.next();
            if (directory.equals("META-INF") || directory.startsWith("META-INF/") || directory.equals("OSGI-OPT") || directory.startsWith("OSGI-OPT/") || directory.equals("/")) continue;
            if (directory.endsWith("/")) {
                directory = directory.substring(0, directory.length() - 1);
            }
            directory = directory.replace('/', '.');
            sb.append(ddel);
            sb.append(directory);
            ddel = ",";
        }
        return sb.toString();
    }

    public Map doServiceComponent(String serviceComponent) throws IOException {
        LinkedHashMap<String, Map> list = new LinkedHashMap<String, Map>();
        Map sc = this.parseHeader(serviceComponent);
        if (!sc.isEmpty()) {
            Iterator i = sc.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String name = (String)entry.getKey();
                Map info = (Map)entry.getValue();
                if (name == null) {
                    this.error("No name in Service-Component header: " + info);
                    continue;
                }
                if (this.dot.exists(name)) {
                    list.put(name, info);
                    continue;
                }
                if (!this.checkClass(name)) {
                    this.error("Not found Service-Component header: " + name);
                    continue;
                }
                Resource resource = this.createComponentResource(name, info);
                this.dot.putResource("OSGI-INF/" + name + ".xml", resource);
                list.put("OSGI-INF/" + name + ".xml", new HashMap());
            }
        }
        return list;
    }

    public Map getBundleClasspath() {
        return this.bundleClasspath;
    }

    public Map getContained() {
        return this.contained;
    }

    public Map getExports() {
        return this.exports;
    }

    public Map getImports() {
        return this.imports;
    }

    public Jar getJar() {
        return this.dot;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String headerName) {
        String value = this.properties.getProperty(headerName);
        if (value != null) {
            return this.replacer.process(value);
        }
        return null;
    }

    public Map getReferred() {
        return this.referred;
    }

    public Set getUnreachable() {
        HashSet unreachable = new HashSet(this.uses.keySet());
        Iterator r = this.exports.keySet().iterator();
        while (r.hasNext()) {
            String packageName = (String)r.next();
            this.removeTransitive(packageName, unreachable);
        }
        if (this.activator != null) {
            String pack = this.activator.substring(0, this.activator.lastIndexOf(46));
            this.removeTransitive(pack, unreachable);
        }
        return unreachable;
    }

    public Map getUses() {
        return this.uses;
    }

    public String getVersion() {
        this.getBndManifest();
        String version = null;
        if (this.bndManifest != null) {
            version = this.bndManifest.getMainAttributes().getValue(BUNDLE_VERSION);
        }
        if (version != null) {
            return version;
        }
        return "unknown version";
    }

    public long getBndLastModified() {
        String v;
        this.getBndManifest();
        if (this.bndManifest != null && (v = this.bndManifest.getMainAttributes().getValue(BND_LASTMODIFIED)) != null) {
            try {
                return Long.parseLong(v);
            }
            catch (Exception e) {
                this.warning("Bnd-LastModified header of bnd jar is not a long " + v);
            }
        }
        return System.currentTimeMillis();
    }

    public void getBndManifest() {
        if (this.bndManifest != null) {
            return;
        }
        try {
            Enumeration<URL> e = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (e.hasMoreElements()) {
                String bsn;
                URL url = e.nextElement();
                InputStream in = url.openStream();
                Manifest manifest = new Manifest(in);
                in.close();
                if (manifest == null || (bsn = manifest.getMainAttributes().getValue(BUNDLE_SYMBOLICNAME)) == null || bsn.indexOf("biz.aQute.bnd") < 0) continue;
                this.bndManifest = manifest;
                return;
            }
        }
        catch (IOException e) {
            this.warning("bnd jar file is corrupted, can not find manifest " + e);
            return;
        }
        this.bndManifest = new Manifest();
    }

    public void mergeManifest(Manifest manifest) throws IOException {
        if (manifest != null) {
            Attributes attributes = manifest.getMainAttributes();
            Iterator<Object> i = attributes.keySet().iterator();
            while (i.hasNext()) {
                Attributes.Name name = (Attributes.Name)i.next();
                String key = name.toString();
                if (key.startsWith("-") || this.getProperty(key) != null) continue;
                this.setProperty(key, (String)attributes.get(name));
            }
        }
    }

    public void setBase(File file) {
        this.base = file;
        this.properties.put("project.dir", this.base.getAbsolutePath());
    }

    public void setClasspath(File[] classpath) throws IOException {
        ArrayList<Jar> list = new ArrayList<Jar>();
        int i = 0;
        while (i < classpath.length) {
            if (classpath[i].exists()) {
                Jar current = new Jar(classpath[i]);
                list.add(current);
            } else {
                this.errors.add("Missing file on classpath: " + classpath[i]);
            }
            ++i;
        }
        Iterator i2 = list.iterator();
        while (i2.hasNext()) {
            this.addClasspath((Jar)i2.next());
        }
    }

    public void setClasspath(Jar[] classpath) {
        int i = 0;
        while (i < classpath.length) {
            this.addClasspath(classpath[i]);
            ++i;
        }
    }

    public void setClasspath(String[] classpath) {
        ArrayList<Jar> list = new ArrayList<Jar>();
        int i = 0;
        while (i < classpath.length) {
            Jar jar = this.getJarFromName(classpath[i], " setting classpath");
            if (jar != null) {
                list.add(jar);
            }
            ++i;
        }
        this.classpath.addAll(list);
    }

    public Jar setJar(File jar) throws IOException {
        return this.setJar(new Jar(jar));
    }

    public Jar setJar(Jar jar) {
        this.dot = jar;
        return jar;
    }

    public void setProperties(File propertiesFile) throws FileNotFoundException, IOException {
        propertiesFile = propertiesFile.getAbsoluteFile();
        this.updateModified(propertiesFile.lastModified());
        this.setBase(propertiesFile.getParentFile());
        Properties local = this.loadProperties(propertiesFile);
        this.setProperties(local);
        this.setProperty("project.file", propertiesFile.getAbsolutePath());
        if (this.getProperty("p") == null) {
            this.setProperty("p", propertiesFile.getParentFile().getName());
        }
        if (this.getProperty(BUNDLE_SYMBOLICNAME) == null) {
            String name = propertiesFile.getName();
            int n = name.lastIndexOf(46);
            if (n > 0) {
                name = name.substring(0, n);
            }
            local.setProperty(BUNDLE_SYMBOLICNAME, name);
        }
    }

    public void setProperties(Properties properties) {
        String cp;
        this.properties = properties;
        this.doPropertyIncludes(this.getBaseURL(), properties, new HashSet());
        this.replacer = new Macro(properties, this);
        String doNotCopy = this.getProperty("-donotcopy");
        if (doNotCopy != null) {
            Analyzer.doNotCopy = Pattern.compile(doNotCopy);
        }
        if ((cp = properties.getProperty("-classpath")) != null) {
            this.doClasspath(cp);
        }
        this.verifyManifestHeadersCase(properties);
        if ("true".equalsIgnoreCase(this.getProperty("-pedantic"))) {
            this.setPedantic(true);
        }
        this.noExtraHeaders = "true".equalsIgnoreCase(this.getProperty("-noextraheaders"));
    }

    private URL getBaseURL() {
        try {
            return this.base.toURL();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setProperty(String key, String value) {
        int i = 0;
        while (i < headers.length) {
            if (headers[i].equalsIgnoreCase(value)) {
                value = headers[i];
                break;
            }
            ++i;
        }
        this.properties.put(key, value);
    }

    boolean checkClass(String interfaceName) {
        String path = String.valueOf(interfaceName.replace('.', '/')) + ".class";
        if (this.classspace.containsKey(path)) {
            return true;
        }
        String pack = interfaceName;
        int n = pack.lastIndexOf(46);
        pack = n > 0 ? pack.substring(0, n) : ".";
        return this.imports.containsKey(pack);
    }

    Resource createComponentResource(String name, Map info) throws IOException {
        String enabled;
        String immediate;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
        pw.println("<?xml version='1.0' encoding='utf-8'?>");
        pw.print("<component name='" + name + "'");
        String factory = (String)info.get("factory:");
        if (factory != null) {
            pw.print(" factory='" + factory + "'");
        }
        if ((immediate = (String)info.get("immediate:")) != null) {
            pw.print(" immediate='" + immediate + "'");
        }
        if ((enabled = (String)info.get("enabled:")) != null) {
            pw.print(" enabled='" + enabled + "'");
        }
        pw.println(">");
        pw.println("  <implementation class='" + name + "'/>");
        String provides = (String)info.get("provide:");
        boolean servicefactory = Boolean.parseBoolean("" + info.get("servicefactory:"));
        this.provides(pw, provides, servicefactory);
        this.properties(pw, info);
        this.reference(info, pw);
        pw.println("</component>");
        pw.close();
        byte[] data = out.toByteArray();
        out.close();
        return new EmbeddedResource(data, 0L);
    }

    void doClasspath(String cp) {
        Iterator i = this.getClauses(cp).iterator();
        while (i.hasNext()) {
            Jar jar = this.getJarFromName((String)i.next(), "getting classpath");
            if (jar == null) continue;
            this.addClasspath(jar);
        }
    }

    void addClasspath(Jar jar) {
        if (this.isPedantic() && jar.getResources().isEmpty()) {
            this.warning("There is an empty jar or directory on the classpath: " + jar.getName());
        }
        this.classpath.add(jar);
    }

    /*
     * Unable to fully structure code
     */
    Jar getJarFromName(String name, String from) {
        file = new File(name);
        if (!file.isAbsolute()) {
            file = new File(this.base, name);
        }
        if (file.exists()) {
            try {
                jar = new Jar(file.getName(), file);
                return jar;
            }
            catch (Exception e) {
                this.error("Exception in parsing jar file for " + from + ": " + name + " " + e);
            }
        }
        try {
            url = new URL(name);
            jar = new Jar(this.fileName(url.getPath()));
            connection = url.openConnection();
            in = connection.getInputStream();
            lastModified = connection.getLastModified();
            if (lastModified == 0L) {
                lastModified = System.currentTimeMillis();
            }
            EmbeddedResource.build(jar, in, lastModified);
            in.close();
            return jar;
        }
        catch (IOException ee) {
            cp = this.classpath.iterator();
            ** while (cp.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            entry = (Jar)cp.next();
            if (entry.source == null || !entry.source.getName().equals(name)) continue;
            return entry;
        }
lbl27:
        // 1 sources

        this.error("Can not find jar file for " + from + ": " + name);
        return null;
    }

    private String fileName(String path) {
        int n = path.lastIndexOf(47);
        if (n > 0) {
            return path.substring(n + 1);
        }
        return path;
    }

    Properties getManifestAsProperties(InputStream in) throws IOException {
        Properties p = new Properties();
        Manifest manifest = new Manifest(in);
        Iterator<Object> it = manifest.getMainAttributes().keySet().iterator();
        while (it.hasNext()) {
            Attributes.Name key = (Attributes.Name)it.next();
            String value = manifest.getMainAttributes().getValue(key);
            p.put(key.toString(), value);
        }
        return p;
    }

    Set getClauses(String list) {
        if (list == null) {
            return new HashSet();
        }
        String[] parts = list.split("\\s*,\\s*");
        return new HashSet<String>(Arrays.asList(parts));
    }

    void merge(Manifest result, Manifest old) throws IOException {
        if (old != null) {
            Iterator<Map.Entry<Object, Object>> e = old.getMainAttributes().entrySet().iterator();
            while (e.hasNext()) {
                Map.Entry<Object, Object> entry = e.next();
                Attributes.Name name = (Attributes.Name)entry.getKey();
                String value = (String)entry.getValue();
                if (name.toString().equalsIgnoreCase(CREATED_BY)) {
                    name = new Attributes.Name("Originally-Created-By");
                }
                if (result.getMainAttributes().containsKey(name)) continue;
                result.getMainAttributes().put(name, value);
            }
            Map<String, Attributes> oldEntries = old.getEntries();
            Map<String, Attributes> newEntries = result.getEntries();
            Iterator<Map.Entry<String, Attributes>> e2 = oldEntries.entrySet().iterator();
            while (e2.hasNext()) {
                Map.Entry<String, Attributes> entry = e2.next();
                if (newEntries.containsKey(entry.getKey())) continue;
                newEntries.put(entry.getKey(), entry.getValue());
            }
        }
    }

    void properties(PrintWriter pw, Map info) {
        Set properties = this.getClauses((String)info.get("properties:"));
        Iterator p = properties.iterator();
        while (p.hasNext()) {
            String clause = (String)p.next();
            int n = clause.indexOf(61);
            if (n <= 0) {
                this.error("Not a valid property in service component: " + clause);
                continue;
            }
            String type = null;
            String name = clause.substring(0, n);
            if (name.contains("@")) {
                String[] parts = name.split("@");
                name = parts[1];
                type = parts[0];
            }
            String value = clause.substring(n + 1);
            pw.print("<property name='");
            pw.print(name);
            pw.print("'");
            if (type != null) {
                if (VALID_PROPERTY_TYPES.matcher(type).matches()) {
                    pw.print(" type='");
                    pw.print(type);
                    pw.print("'");
                } else {
                    this.warnings.add("Invalid property type '" + type + "' for property " + name);
                }
            }
            if (value.contains("\\n")) {
                pw.print("'>");
                pw.print(value.replaceAll("\\n", "\n"));
                pw.println("</property>");
                continue;
            }
            pw.print(" value='");
            pw.print(value);
            pw.print("'/>");
        }
    }

    void provides(PrintWriter pw, String provides, boolean servicefactory) {
        if (provides != null) {
            if (!servicefactory) {
                pw.println("  <service>");
            } else {
                pw.println("  <service servicefactory='true'>");
            }
            StringTokenizer st = new StringTokenizer(provides, ",");
            while (st.hasMoreTokens()) {
                String interfaceName = st.nextToken();
                pw.println("    <provide interface='" + interfaceName + "'/>");
                if (this.checkClass(interfaceName)) continue;
                this.error("Component definition provides a class that is neither imported nor contained: " + interfaceName);
            }
            pw.println("  </service>");
        }
    }

    void reference(Map info, PrintWriter pw) {
        Set dynamic = this.getClauses((String)info.get("dynamic:"));
        Set optional = this.getClauses((String)info.get("optional:"));
        Set multiple = this.getClauses((String)info.get("multiple:"));
        Iterator r = info.entrySet().iterator();
        while (r.hasNext()) {
            Map.Entry ref = r.next();
            String referenceName = (String)ref.getKey();
            String interfaceName = (String)ref.getValue();
            if (referenceName.endsWith(":")) continue;
            if (!this.checkClass(interfaceName)) {
                this.error("Component definition refers to a class that is neither imported nor contained: " + interfaceName);
            }
            pw.print("  <reference name='" + referenceName + "' interface='" + interfaceName + "'");
            String cardinality = optional.contains(referenceName) ? "0" : "1";
            cardinality = String.valueOf(cardinality) + "..";
            cardinality = String.valueOf(cardinality) + (multiple.contains(referenceName) ? "n" : "1");
            if (!cardinality.equals("1..1")) {
                pw.print(" cardinality='" + cardinality + "'");
            }
            if (Character.isLowerCase(referenceName.charAt(0))) {
                String z = String.valueOf(referenceName.substring(0, 1).toUpperCase()) + referenceName.substring(1);
                pw.print(" bind='set" + z + "'");
                pw.print(" unbind='unset" + z + "'");
            }
            if (dynamic.contains(referenceName)) {
                pw.print(" policy='dynamic'");
            }
            pw.println("/>");
        }
    }

    String stem(String name) {
        int n = name.lastIndexOf(46);
        if (n > 0) {
            return name.substring(0, n);
        }
        return name;
    }

    void verifyManifestHeadersCase(Properties properties) {
        Iterator<Object> i = properties.keySet().iterator();
        block0: while (i.hasNext()) {
            String header = (String)i.next();
            int j = 0;
            while (j < headers.length) {
                if (!headers[j].equals(header) && headers[j].equalsIgnoreCase(header)) {
                    this.warnings.add("Using a standard OSGi header with the wrong case (bnd is case sensitive!), using: " + header + " and expecting: " + headers[j]);
                    continue block0;
                }
                ++j;
            }
        }
    }

    Map addExportsToImports(Map exports) {
        HashMap<String, Map> importsFromExports = new HashMap<String, Map>();
        Iterator export = exports.entrySet().iterator();
        while (export.hasNext()) {
            Map importParameters;
            Map.Entry entry = export.next();
            String packageName = (String)entry.getKey();
            Map parameters = (Map)entry.getValue();
            String noimport = (String)parameters.get("-noimport:");
            if (noimport != null && noimport.equalsIgnoreCase("true") || (importParameters = (Map)importsFromExports.get(packageName)) != null) continue;
            importsFromExports.put(packageName, parameters);
        }
        return importsFromExports;
    }

    void analyzeClasspath() throws IOException {
        this.cpExports = new HashMap();
        Iterator c = this.classpath.iterator();
        while (c.hasNext()) {
            Jar current = (Jar)c.next();
            this.checkManifest(current);
            Iterator j = current.getDirectories().keySet().iterator();
            while (j.hasNext()) {
                String dir = (String)j.next();
                Resource resource = current.getResource(String.valueOf(dir) + "/packageinfo");
                if (resource == null) continue;
                InputStream in = resource.openInputStream();
                String version = Analyzer.parsePackageInfo(in);
                in.close();
                this.setPackageInfo(dir, "version", version);
            }
        }
    }

    void checkManifest(Jar jar) {
        try {
            Map exported;
            String exportHeader;
            Manifest m = jar.getManifest();
            if (m != null && (exportHeader = m.getMainAttributes().getValue(EXPORT_PACKAGE)) != null && (exported = this.parseHeader(exportHeader)) != null) {
                this.cpExports.putAll(exported);
            }
        }
        catch (Exception e) {
            this.warning("Erroneous Manifest for " + jar + " " + e);
        }
    }

    void augmentImports() {
        Iterator imp = this.imports.keySet().iterator();
        while (imp.hasNext()) {
            String mandatory;
            Map exporter;
            String packageName = (String)imp.next();
            Map currentAttributes = (Map)this.imports.get(packageName);
            String currentVersion = (String)currentAttributes.get("version");
            if (currentVersion != null && currentVersion.indexOf("${") < 0 || (exporter = (Map)this.cpExports.get(packageName)) == null) continue;
            String version = (String)exporter.get("version");
            if (version == null) {
                version = (String)exporter.get("specification-version");
            }
            if (version != null) {
                if (currentVersion != null) {
                    this.setProperty("@", version);
                    version = this.replacer.process(currentVersion);
                    this.unsetProperty("@");
                } else {
                    Matcher m = versionPattern.matcher(version);
                    if (m.matches()) {
                        version = m.group(1);
                    }
                }
                currentAttributes.put("version", version);
            }
            if ((mandatory = (String)exporter.get("mandatory:")) == null) continue;
            String[] attrs = mandatory.split("\\w*,\\w*");
            int i = 0;
            while (i < attrs.length) {
                currentAttributes.put(attrs[i], exporter.get(attrs[i]));
                ++i;
            }
        }
    }

    public void unsetProperty(String string) {
        this.properties.remove(string);
    }

    void doPropertyIncludes(URL ubase, Properties p, Set done) {
        String includes = p.getProperty("-include");
        if (includes != null) {
            includes = this.replacer.process(includes);
            Set clauses = this.getClauses(includes);
            Iterator i = clauses.iterator();
            while (i.hasNext()) {
                String value = (String)i.next();
                boolean fileMustExist = true;
                if (value.startsWith("-")) {
                    fileMustExist = false;
                    value = value.substring(1).trim();
                }
                try {
                    URL next = null;
                    try {
                        next = new URL(ubase, value);
                    }
                    catch (MalformedURLException e) {
                        File f = new File(value);
                        if (!f.isAbsolute()) {
                            f = new File(this.base, value);
                        }
                        if (f.exists()) {
                            next = f.getAbsoluteFile().toURL();
                            this.updateModified(f.lastModified());
                        }
                        if (!fileMustExist) continue;
                        this.error("Can not find include file: " + value);
                        continue;
                    }
                    String urlString = next.toExternalForm();
                    if (done.contains(urlString)) {
                        return;
                    }
                    done.add(urlString);
                    URLConnection connection = next.openConnection();
                    long time = connection.getLastModified();
                    if (time > 0L) {
                        this.updateModified(time);
                    }
                    InputStream in = connection.getInputStream();
                    Properties sub = next.getFile().toLowerCase().endsWith(".mf") ? this.getManifestAsProperties(in) : this.loadProperties(in, next.toExternalForm());
                    this.doPropertyIncludes(next, sub, done);
                    p.putAll((Map<?, ?>)sub);
                    in.close();
                }
                catch (FileNotFoundException e) {
                    if (!fileMustExist) continue;
                    this.error("Can not find included file: " + value);
                }
                catch (IOException e) {
                    if (!fileMustExist) continue;
                    this.error("Error in processing included file: " + value + "(" + e + ")");
                }
            }
        }
    }

    void doUses(Map exports, Map uses) {
        Iterator i = exports.keySet().iterator();
        while (i.hasNext()) {
            String packageName = (String)i.next();
            Map clause = (Map)exports.get(packageName);
            Set t = (Set)uses.get(packageName);
            if (t == null || t.isEmpty()) continue;
            StringBuffer sb = new StringBuffer();
            String del = "";
            Iterator u = t.iterator();
            while (u.hasNext()) {
                String usedPackage = (String)u.next();
                if (usedPackage.equals(packageName) || usedPackage.startsWith("java.")) continue;
                sb.append(del);
                sb.append(usedPackage);
                del = ",";
            }
            String s = sb.toString();
            if (s.length() <= 0) continue;
            clause.put("uses:", sb.toString());
        }
    }

    String getProperty(String headerName, String deflt) {
        String v = this.getProperty(headerName);
        return v == null ? deflt : v;
    }

    Properties loadProperties(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        Properties p = this.loadProperties(in, file.getAbsolutePath());
        ((InputStream)in).close();
        return p;
    }

    Properties loadProperties(InputStream in, String name) throws IOException {
        try {
            Properties p = new Properties();
            p.load(in);
            return p;
        }
        catch (Exception e) {
            this.error("Error during loading properties file: " + name + ", error:" + e);
            return new Properties();
        }
    }

    Map merge(String type, Map instructions, Map actual, Set superfluous) {
        actual = new HashMap(actual);
        HashMap<String, Map> result = new HashMap<String, Map>();
        Iterator i = instructions.keySet().iterator();
        while (i.hasNext()) {
            String instruction;
            String originalInstruction = instruction = (String)i.next();
            Map instructedAttributes = (Map)instructions.get(instruction);
            if (instruction.startsWith("=")) {
                result.put(instruction.substring(1), instructedAttributes);
                superfluous.remove(originalInstruction);
                continue;
            }
            Instruction instr = Instruction.getPattern(instruction);
            Iterator p = actual.keySet().iterator();
            while (p.hasNext()) {
                String packageName = (String)p.next();
                if (!instr.matches(packageName)) continue;
                superfluous.remove(originalInstruction);
                if (!instr.isNegated()) {
                    HashMap newAttributes = new HashMap();
                    newAttributes.putAll((Map)actual.get(packageName));
                    newAttributes.putAll(instructedAttributes);
                    result.put(packageName, newAttributes);
                } else {
                    this.ignored.put(packageName, new HashMap());
                }
                p.remove();
            }
        }
        return result;
    }

    String printClauses(Map exports, String allowedDirectives) {
        StringBuffer sb = new StringBuffer();
        String del = "";
        Iterator i = exports.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            Map map = (Map)exports.get(name);
            sb.append(del);
            sb.append(name);
            Iterator j = map.keySet().iterator();
            while (j.hasNext()) {
                boolean dirty;
                String key = (String)j.next();
                if (key.endsWith(":") && allowedDirectives.indexOf(key) < 0) continue;
                String value = (String)map.get(key);
                sb.append(";");
                sb.append(key);
                sb.append("=");
                boolean bl = dirty = value.indexOf(44) >= 0 || value.indexOf(59) >= 0;
                if (dirty) {
                    sb.append("\"");
                }
                sb.append(value);
                if (!dirty) continue;
                sb.append("\"");
            }
            del = ",";
        }
        return sb.toString();
    }

    void removeTransitive(String name, Set unreachable) {
        if (!unreachable.contains(name)) {
            return;
        }
        unreachable.remove(name);
        Set ref = (Set)this.uses.get(name);
        if (ref != null) {
            Iterator r = ref.iterator();
            while (r.hasNext()) {
                String element = (String)r.next();
                this.removeTransitive(element, unreachable);
            }
        }
    }

    void setPackageInfo(String dir, String key, String value) {
        if (value != null) {
            String pack = dir.replace('/', '.');
            HashMap<String, String> map = (HashMap<String, String>)this.cpExports.get(pack);
            if (map == null) {
                map = new HashMap<String, String>();
                this.cpExports.put(pack, map);
            }
            map.put(key, value);
        }
    }

    public void close() {
        this.dot.close();
        if (this.classpath != null) {
            Iterator j = this.classpath.iterator();
            while (j.hasNext()) {
                Jar jar = (Jar)j.next();
                jar.close();
            }
        }
    }

    public String _findpath(String[] args) {
        return this.findPath("findpath", args, true);
    }

    public String _findname(String[] args) {
        return this.findPath("findname", args, false);
    }

    String findPath(String name, String[] args, boolean fullPathName) {
        if (args.length > 3) {
            this.warning("Invalid nr of arguments to " + name + " " + Arrays.asList(args) + ", syntax: ${" + name + " (; reg-expr (; replacement)? )? }");
            return null;
        }
        String regexp = ".*";
        String replace = null;
        switch (args.length) {
            case 3: {
                replace = args[2];
            }
            case 2: {
                regexp = args[1];
            }
        }
        StringBuffer sb = new StringBuffer();
        String del = "";
        Pattern expr = Pattern.compile(regexp);
        Iterator e = this.dot.getResources().keySet().iterator();
        while (e.hasNext()) {
            Matcher m;
            int n;
            String path = (String)e.next();
            if (!fullPathName && (n = path.lastIndexOf(47)) >= 0) {
                path = path.substring(n + 1);
            }
            if (!(m = expr.matcher(path)).matches()) continue;
            if (replace != null) {
                path = m.replaceAll(replace);
            }
            sb.append(del);
            sb.append(path);
            del = ", ";
        }
        return sb.toString();
    }

    public void updateModified(long time) {
        if (time > this.lastModified) {
            this.lastModified = time;
        }
    }

    public long lastModified() {
        this.updateModified(this.getBndLastModified());
        return this.lastModified;
    }

    public void putAll(Map additional, boolean force) {
        Iterator i = additional.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (!force && this.properties.get(entry.getKey()) != null) continue;
            this.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

