/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.osgi;

import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.EmbeddedResource;
import aQute.lib.osgi.FileResource;
import aQute.lib.osgi.Instruction;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Macro;
import aQute.lib.osgi.Verifier;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipException;

public class Builder
extends Analyzer {
    boolean sources = false;
    File[] sourcePath;
    Pattern NAME_URL = Pattern.compile("(.*)(http://.*)");
    static Pattern fuzzyVersion = Pattern.compile("(\\d+)(\\.(\\d+)(\\.(\\d+))?)?(\\.\\d+)*.?(.*)", 32);

    public Jar build() throws Exception {
        if (this.getProperty("Import-Package") == null) {
            this.setProperty("Import-Package", "*");
        }
        if (this.classpath.size() == 0 && (this.getProperty("Export-Package") != null || this.getProperty("Private-Package") != null)) {
            this.warning("Classpath is empty. Private-Package and Export-Package can only expand from the classpath when there is one");
        }
        this.sources = this.getProperty("-sources") != null;
        this.dot = new Jar("dot");
        this.doExpand(this.dot);
        this.doIncludeResources(this.dot);
        this.doConditional(this.dot);
        this.dot.setManifest(this.calcManifest());
        this.addSources(this.dot);
        if (this.getProperty("-pom") != null) {
            this.doPom(this.dot);
        }
        this.doVerify(this.dot);
        if (this.dot.getResources().isEmpty()) {
            this.error("The JAR is empty");
        }
        this.dot.updateModified(this.lastModified());
        return this.dot;
    }

    private void doConditional(Jar dot) throws IOException {
        Map conditionals = this.getHeader("Conditional-Package");
        if (conditionals != null) {
            int size;
            do {
                size = dot.getDirectories().size();
                this.analyze();
                this.analyzed = false;
                Map imports = this.getImports();
                Map filtered = this.merge("Conditional-Package", conditionals, imports, new HashSet());
                filtered = this.replaceWithPattern(filtered);
                this.doExpand(dot, "Conditional-Package", filtered);
            } while (dot.getDirectories().size() > size);
        }
    }

    public void analyze() throws IOException {
        super.analyze();
        this.cleanupVersion(this.imports);
        this.cleanupVersion(this.exports);
        String version = this.getProperty("Bundle-Version");
        if (version != null) {
            this.setProperty("Bundle-Version", Builder.cleanupVersion(version));
        }
    }

    public void cleanupVersion(Map mapOfMap) {
        Iterator e = mapOfMap.entrySet().iterator();
        while (e.hasNext()) {
            Map.Entry entry = e.next();
            Map attributes = (Map)entry.getValue();
            if (!attributes.containsKey("version")) continue;
            attributes.put("version", Builder.cleanupVersion((String)attributes.get("version")));
        }
    }

    public static String cleanupVersion(String version) {
        Matcher m = fuzzyVersion.matcher(version);
        if (m.matches()) {
            StringBuffer result = new StringBuffer();
            String d1 = m.group(1);
            String d2 = m.group(3);
            String d3 = m.group(5);
            String modifier = m.group(7);
            if (modifier != null && modifier.trim().length() == 0) {
                modifier = null;
            }
            if (d1 != null) {
                result.append(d1);
                if (d2 != null) {
                    result.append(".");
                    result.append(d2);
                    if (d3 != null) {
                        result.append(".");
                        result.append(d3);
                        if (modifier != null) {
                            result.append(".");
                            Builder.cleanupModifier(result, modifier);
                        }
                    } else if (modifier != null) {
                        result.append(".0.");
                        Builder.cleanupModifier(result, modifier);
                    }
                } else if (modifier != null) {
                    result.append(".0.0.");
                    Builder.cleanupModifier(result, modifier);
                }
                return result.toString();
            }
        }
        return version;
    }

    static void cleanupModifier(StringBuffer result, String modifier) {
        int i = 0;
        while (i < modifier.length()) {
            char c = modifier.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '-') {
                result.append(c);
            }
            ++i;
        }
    }

    private void addSources(Jar dot) {
        if (!this.sources) {
            return;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.getProperties().store(out, "Generated by BND, at " + new Date());
            dot.putResource("OSGI-OPT/bnd.bnd", new EmbeddedResource(out.toByteArray(), 0L));
            out.close();
        }
        catch (Exception e) {
            this.error("Can not embed bnd file in JAR: " + e);
        }
        Iterator cpe = this.classspace.keySet().iterator();
        while (cpe.hasNext()) {
            String path = (String)cpe.next();
            path = String.valueOf(path.substring(0, path.length() - ".class".length())) + ".java";
            int i = 0;
            while (i < this.sourcePath.length) {
                File root = this.sourcePath[i];
                File f = Builder.getFile(root, path);
                if (f.exists()) {
                    dot.putResource("OSGI-OPT/src/" + path, new FileResource(f));
                }
                ++i;
            }
        }
    }

    private void doVerify(Jar dot) throws Exception {
        Verifier verifier = new Verifier(dot);
        verifier.verify();
        this.errors.addAll(verifier.getErrors());
        this.warnings.addAll(verifier.getWarnings());
    }

    private void doExpand(Jar jar) throws IOException {
        Map prive = this.replaceWithPattern(this.getHeader("Private-Package"));
        Map export = this.replaceWithPattern(this.getHeader("Export-Package"));
        if (prive.isEmpty() && export.isEmpty()) {
            this.warnings.add("Neither Export-Package nor Private-Package is set, therefore no packages will be included");
        }
        this.doExpand(jar, "Export-Package", export);
        this.doExpand(jar, "Private-Package", prive);
    }

    private void doExpand(Jar jar, String name, Map instructions) {
        HashSet superfluous = new HashSet(instructions.keySet());
        Iterator c = this.classpath.iterator();
        while (c.hasNext()) {
            Jar now = (Jar)c.next();
            this.doExpand(jar, instructions, now, superfluous);
        }
        if (superfluous.size() > 0) {
            StringBuffer sb = new StringBuffer();
            String del = "Instructions for " + name + " that are never used: ";
            Iterator i = superfluous.iterator();
            while (i.hasNext()) {
                Instruction p = (Instruction)i.next();
                sb.append(del);
                sb.append(p.getPattern());
                del = ", ";
            }
            this.warning(sb.toString());
        }
    }

    private void doExpand(Jar jar, Map included, Jar classpathEntry, Set superfluous) {
        Iterator p = classpathEntry.getDirectories().entrySet().iterator();
        while (p.hasNext()) {
            String pack;
            Instruction instr;
            Map.Entry directory = p.next();
            String path = (String)directory.getKey();
            if (doNotCopy.matcher(this.getName(path)).matches() || (instr = this.matches(included, pack = path.replace('/', '.'), superfluous)) == null || instr.isNegated()) continue;
            Map contents = (Map)directory.getValue();
            jar.addDirectory(contents);
        }
    }

    private Map replaceWithPattern(Map header) {
        LinkedHashMap map = new LinkedHashMap();
        Iterator e = header.entrySet().iterator();
        while (e.hasNext()) {
            Map.Entry entry = e.next();
            String pattern = (String)entry.getKey();
            Instruction instr = Instruction.getPattern(pattern);
            map.put(instr, entry.getValue());
        }
        return map;
    }

    private Instruction matches(Map instructions, String pack, Set superfluousPatterns) {
        Iterator i = instructions.keySet().iterator();
        while (i.hasNext()) {
            Instruction pattern = (Instruction)i.next();
            if (!pattern.matches(pack)) continue;
            superfluousPatterns.remove(pattern);
            return pattern;
        }
        return null;
    }

    private Map getHeader(String string) {
        if (string == null) {
            return new LinkedHashMap();
        }
        return this.parseHeader(this.getProperty(string));
    }

    private void doIncludeResources(Jar jar) throws Exception {
        Macro macro = new Macro(this.getProperties(), this);
        String includes = this.getProperty("Bundle-Includes");
        if (includes == null) {
            includes = this.getProperty("Include-Resource");
        } else {
            this.warnings.add("Please use Include-Resource instead of Bundle-Includes");
        }
        if (includes == null) {
            return;
        }
        Iterator i = this.getClauses(includes).iterator();
        while (i.hasNext()) {
            String destinationPath;
            File source;
            boolean preprocess = false;
            String clause = (String)i.next();
            if (clause.startsWith("{") && clause.endsWith("}")) {
                preprocess = true;
                clause = clause.substring(1, clause.length() - 1).trim();
            }
            HashMap<String, String> extra = new HashMap<String, String>();
            int n = clause.indexOf(59);
            if (n > 0) {
                String attributes = clause.substring(n + 1);
                String[] parts = attributes.split("\\s*;\\s*");
                int j = 0;
                while (j < parts.length) {
                    String[] assignment = parts[j].split("\\s*=\\s*");
                    if (assignment.length == 2) {
                        extra.put(assignment[0], assignment[1]);
                    } else {
                        this.error("Invalid attribute on Include-Resource: " + clause);
                    }
                    ++j;
                }
                clause = clause.substring(0, n);
            }
            if (clause.startsWith("@")) {
                this.extractFromJar(jar, clause.substring(1));
                continue;
            }
            String[] parts = clause.split("\\s*=\\s*");
            if (parts.length == 1) {
                source = Builder.getFile(this.base, parts[0]);
                destinationPath = source.isDirectory() ? "" : source.getName();
            } else {
                source = Builder.getFile(this.base, parts[1]);
                destinationPath = parts[0];
            }
            if (destinationPath.endsWith("/")) {
                destinationPath = destinationPath.substring(0, destinationPath.length() - 1);
            }
            this.copy(jar, destinationPath, source, preprocess ? macro : null, extra);
        }
    }

    private void extractFromJar(Jar jar, String name) throws ZipException, IOException {
        int n = name.lastIndexOf("!/");
        Pattern filter = null;
        if (n > 0) {
            String fstring = name.substring(n + 2);
            name = name.substring(0, n);
            filter = this.wildcard(fstring);
        }
        Jar sub = this.getJarFromName(name, "extract from jar");
        jar.addAll(sub, filter);
    }

    private Pattern wildcard(String spec) {
        StringBuffer sb = new StringBuffer();
        int j = 0;
        while (j < spec.length()) {
            char c = spec.charAt(j);
            switch (c) {
                case '.': {
                    sb.append("\\.");
                    break;
                }
                case '*': {
                    if (j < spec.length() - 1 && spec.charAt(j + 1) == '*') {
                        sb.append(".*");
                        ++j;
                        break;
                    }
                    sb.append("[^/]*");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++j;
        }
        String s = sb.toString();
        try {
            return Pattern.compile(s);
        }
        catch (Exception e) {
            this.error("Invalid regular expression on wildcarding: " + spec + " used *");
            return null;
        }
    }

    private void copy(Jar jar, String path, File from, Macro macro, Map extra) throws Exception {
        if (doNotCopy.matcher(from.getName()).matches()) {
            return;
        }
        if (from.isDirectory()) {
            String next = path;
            if (next.length() != 0) {
                next = String.valueOf(next) + '/';
            }
            File[] files = from.listFiles();
            int i = 0;
            while (i < files.length) {
                this.copy(jar, String.valueOf(next) + files[i].getName(), files[i], macro, extra);
                ++i;
            }
        } else if (macro != null) {
            String content = this.read(from);
            content = macro.process(content);
            EmbeddedResource resource = new EmbeddedResource(content.getBytes("UTF-8"), from.lastModified());
            String x = (String)extra.get("extra");
            if (x != null) {
                resource.setExtra(x);
            }
            jar.putResource(path, resource);
        } else {
            jar.putResource(path, new FileResource(from));
        }
    }

    private String read(File from) throws Exception {
        long size = from.length();
        byte[] buffer = new byte[(int)size];
        FileInputStream in = new FileInputStream(from);
        in.read(buffer);
        in.close();
        return new String(buffer, "UTF-8");
    }

    private String getName(String where) {
        int n = where.lastIndexOf(47);
        if (n < 0) {
            return where;
        }
        return where.substring(n + 1);
    }

    public void setSourcepath(File[] files) {
        this.sourcePath = files;
    }

    public void doPom(Jar dot) throws FileNotFoundException, IOException {
        Manifest manifest = dot.getManifest();
        String name = manifest.getMainAttributes().getValue("Bundle-Name");
        String description = manifest.getMainAttributes().getValue("Bundle-Description");
        String docUrl = manifest.getMainAttributes().getValue("Bundle-DocURL");
        String version = manifest.getMainAttributes().getValue("Bundle-Version");
        String bundleVendor = manifest.getMainAttributes().getValue("Bundle-Vendor");
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(s);
        String bsn = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
        String licenses = manifest.getMainAttributes().getValue("Bundle-License");
        if (bsn == null) {
            this.errors.add("Can not create POM unless Bundle-SymbolicName is set");
            return;
        }
        int n = (bsn = bsn.trim()).lastIndexOf(46);
        if (n <= 0) {
            this.errors.add("Can not create POM unless Bundle-SymbolicName contains a .");
            ps.close();
            s.close();
            return;
        }
        String groupId = bsn.substring(0, n);
        String artifactId = bsn.substring(n + 1);
        ps.println("<project xmlns='http://maven.apache.org/POM/4.0.0' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:schemaLocation='http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd'>");
        ps.println("  <modelVersion>4.0.0</modelVersion>");
        ps.println("  <groupId>" + groupId + "</groupId>");
        n = artifactId.indexOf(59);
        if (n > 0) {
            artifactId = artifactId.substring(0, n).trim();
        }
        ps.println("  <artifactId>" + artifactId + "</artifactId>");
        ps.println("  <version>" + version + "</version>");
        if (description != null) {
            ps.println("  <description>");
            ps.print("    ");
            ps.println(description);
            ps.println("  </description>");
        }
        if (name != null) {
            ps.print("  <name>");
            ps.print(name);
            ps.println("</name>");
        }
        if (docUrl != null) {
            ps.print("  <url>");
            ps.print(docUrl);
            ps.println("</url>");
        }
        if (bundleVendor != null) {
            Matcher m = this.NAME_URL.matcher(bundleVendor);
            String namePart = bundleVendor;
            String urlPart = null;
            if (m.matches()) {
                namePart = m.group(1);
                urlPart = m.group(2);
            }
            ps.println("  <organization>");
            ps.print("    <name>");
            ps.print(namePart.trim());
            ps.println("</name>");
            if (urlPart != null) {
                ps.print("    <url>");
                ps.print(urlPart.trim());
                ps.println("</url>");
            }
            ps.println("  </organization>");
        }
        if (licenses != null) {
            ps.println("  <licenses>");
            Map map = this.parseHeader(licenses);
            Iterator e = map.entrySet().iterator();
            while (e.hasNext()) {
                Map.Entry entry = e.next();
                ps.println("    <license>");
                Map values = (Map)entry.getValue();
                this.print(ps, values, "name", "name", (String)values.get("url"));
                this.print(ps, values, "url", "url", null);
                this.print(ps, values, "distribution", "distribution", "repo");
                ps.println("    </license>");
            }
            ps.println("  </licenses>");
        }
        ps.println("</project>");
        ps.close();
        s.close();
        dot.putResource("pom.xml", new EmbeddedResource(s.toByteArray(), 0L));
    }

    private void print(PrintStream ps, Map values, String string, String tag, String object) {
        String value = (String)values.get(string);
        if (value == null) {
            value = object;
        }
        if (value == null) {
            return;
        }
        ps.println("    <" + tag + ">" + value.trim() + "</" + tag + ">");
    }

    public void close() {
        super.close();
    }
}

