/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.osgi;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class Clazz {
    static byte[] SkipTable;
    Map imports = new HashMap();
    String path;
    boolean activator;
    String className;
    int minor = 0;
    int major = 0;
    String sourceFile;

    static {
        byte[] byArray = new byte[13];
        byArray[1] = -1;
        byArray[2] = -1;
        byArray[3] = 4;
        byArray[4] = 4;
        byArray[5] = 8;
        byArray[6] = 8;
        byArray[7] = -1;
        byArray[8] = 2;
        byArray[9] = 4;
        byArray[10] = 4;
        byArray[11] = 4;
        byArray[12] = 4;
        SkipTable = byArray;
    }

    public Clazz(String path) {
        this.path = path;
    }

    public Clazz(String path, InputStream in) throws IOException {
        this.path = path;
        DataInputStream din = new DataInputStream(in);
        this.parseClassFile(din);
        din.close();
    }

    Set parseClassFile(DataInputStream in) throws IOException {
        int descriptorIndex;
        HashSet<String> xref = new HashSet<String>();
        HashSet<Integer> classes = new HashSet<Integer>();
        HashSet<Integer> descriptors = new HashSet<Integer>();
        int magic = in.readInt();
        if (magic != -889275714) {
            throw new IOException("Not a valid class file (no CAFEBABE header)");
        }
        this.minor = in.readShort();
        this.major = in.readShort();
        int count = in.readUnsignedShort();
        String[] pool = new String[count];
        int i = 1;
        block7: while (i < count) {
            byte tag = in.readByte();
            switch (tag) {
                case 0: {
                    break block7;
                }
                case 1: {
                    String name = in.readUTF();
                    xref.add(name);
                    pool[i] = name;
                    break;
                }
                case 7: {
                    Integer index = new Integer(in.readShort());
                    classes.add(index);
                    break;
                }
                case 5: 
                case 6: {
                    in.skipBytes(8);
                    ++i;
                    break;
                }
                case 12: {
                    in.skip(2L);
                    descriptorIndex = in.readShort();
                    descriptors.add(new Integer(descriptorIndex));
                    break;
                }
                default: {
                    if (tag == 2) {
                        throw new IOException("Invalid tag " + tag);
                    }
                    in.skipBytes(SkipTable[tag]);
                }
            }
            ++i;
        }
        in.skip(6L);
        int interfacesCount = in.readUnsignedShort();
        in.skip(interfacesCount * 2);
        int fieldsCount = in.readUnsignedShort();
        int i2 = 0;
        while (i2 < fieldsCount) {
            in.skip(4L);
            int descriptorIndex2 = in.readUnsignedShort();
            descriptors.add(new Integer(descriptorIndex2));
            this.doAttributes(in, classes, descriptors, pool);
            ++i2;
        }
        int methodCount = in.readUnsignedShort();
        int i3 = 0;
        while (i3 < methodCount) {
            in.skip(4L);
            descriptorIndex = in.readUnsignedShort();
            descriptors.add(new Integer(descriptorIndex));
            this.doAttributes(in, classes, descriptors, pool);
            ++i3;
        }
        this.doAttributes(in, classes, descriptors, pool);
        Iterator e = classes.iterator();
        while (e.hasNext()) {
            Integer n = (Integer)e.next();
            String next = pool[n];
            this.doClassReference(next);
        }
        e = descriptors.iterator();
        while (e.hasNext()) {
            Integer n = (Integer)e.next();
            String prototype = pool[n];
            if (prototype == null) continue;
            this.parseDescriptor(prototype);
        }
        return xref;
    }

    private void doClassReference(String next) {
        if (next != null) {
            String normalized = Clazz.normalize(next);
            if (normalized != null) {
                if (normalized.startsWith("org/osgi/framework/BundleActivator")) {
                    this.className = this.path.replace('/', '.');
                    this.className = this.className.substring(0, this.className.length() - ".class".length());
                    this.activator = true;
                }
                String pack = Clazz.getPackage(normalized);
                this.packageReference(pack);
            }
        } else {
            throw new IllegalArgumentException("Invalid class, parent=");
        }
    }

    private void doAttributes(DataInputStream in, Set classes, Set descriptors, String[] pool) throws IOException {
        int attributesCount = in.readUnsignedShort();
        int j = 0;
        while (j < attributesCount) {
            this.doAttribute(in, classes, descriptors, pool);
            ++j;
        }
    }

    private void doAttribute(DataInputStream in, Set classes, Set descriptors, String[] pool) throws IOException {
        short attribute_name_index = in.readShort();
        String attributeName = pool[attribute_name_index];
        long attribute_length = in.readInt();
        attribute_length &= 0xFFFFL;
        if ("RuntimeVisibleAnnotations".equals(attributeName)) {
            this.doAnnotations(in, classes, descriptors);
        } else if ("SourceFile".equals(attributeName)) {
            this.doSourceFile(in, pool);
        } else {
            in.skip(attribute_length);
        }
    }

    private void doSourceFile(DataInputStream in, String[] pool) throws IOException {
        int sourcefile_index = in.readUnsignedShort();
        this.sourceFile = pool[sourcefile_index];
    }

    private void doAnnotations(DataInputStream in, Set classes, Set descriptors) throws IOException {
        int num_annotations = in.readShort();
        int a = 0;
        while (a < num_annotations) {
            this.doAnnotation(in, classes, descriptors);
            ++a;
        }
    }

    private void doAnnotation(DataInputStream in, Set classes, Set descriptors) throws IOException {
        short type_index = in.readShort();
        descriptors.add(new Integer(type_index));
        int num_element_value_pairs = in.readShort();
        int v = 0;
        while (v < num_element_value_pairs) {
            in.readShort();
            this.doElementValue(in, classes, descriptors);
            ++v;
        }
    }

    private void doElementValue(DataInputStream in, Set classes, Set descriptors) throws IOException {
        int tag = in.readUnsignedByte();
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                in.readShort();
                break;
            }
            case 101: {
                short type_name_index = in.readShort();
                descriptors.add(new Integer(type_name_index));
                in.readShort();
                break;
            }
            case 99: {
                short class_info_index = in.readShort();
                descriptors.add(new Integer(class_info_index));
                break;
            }
            case 64: {
                this.doAnnotation(in, classes, descriptors);
                break;
            }
            case 91: {
                int num_values = in.readShort();
                int i = 0;
                while (i < num_values) {
                    this.doElementValue(in, classes, descriptors);
                    ++i;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for Annotation ElementValue tag " + tag);
            }
        }
    }

    void packageReference(String pack) {
        if (pack.indexOf(60) > 0) {
            System.out.println("Oops: " + pack);
        }
        if (!this.imports.containsKey(pack)) {
            this.imports.put(pack, new HashMap());
        }
    }

    void parseDescriptor(String prototype) {
        this.addReference(prototype);
        StringTokenizer st = new StringTokenizer(prototype, "(;)", true);
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equals("(")) continue;
            String token = st.nextToken();
            while (!token.equals(")")) {
                this.addReference(token);
                token = st.nextToken();
            }
            token = st.nextToken();
            this.addReference(token);
        }
    }

    private void addReference(String token) {
        while (token.startsWith("[")) {
            token = token.substring(1);
        }
        if (token.startsWith("L")) {
            String clazz = Clazz.normalize(token.substring(1));
            if (clazz.startsWith("java/")) {
                return;
            }
            String pack = Clazz.getPackage(clazz);
            this.packageReference(pack);
        }
    }

    static String normalize(String s) {
        if (s.startsWith("[L")) {
            return Clazz.normalize(s.substring(2));
        }
        if (s.startsWith("[")) {
            if (s.length() == 2) {
                return null;
            }
            return Clazz.normalize(s.substring(1));
        }
        if (s.endsWith(";")) {
            return Clazz.normalize(s.substring(0, s.length() - 1));
        }
        return String.valueOf(s) + ".class";
    }

    public static String getPackage(String clazz) {
        int n = clazz.lastIndexOf(47);
        if (n < 0) {
            return ".";
        }
        return clazz.substring(0, n).replace('/', '.');
    }

    public Map getReferred() {
        return this.imports;
    }

    String getClassName() {
        return this.className;
    }

    boolean isActivator() {
        return this.activator;
    }

    public String getPath() {
        return this.path;
    }

    public Set xref(InputStream in) throws IOException {
        DataInputStream din = new DataInputStream(in);
        Set set = this.parseClassFile(din);
        din.close();
        return set;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }
}

