/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.osgi;

import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Resource;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class EmbeddedResource
implements Resource {
    byte[] data;
    long lastModified;
    String extra;

    public EmbeddedResource(byte[] data, long lastModified) {
        this.data = data;
        this.lastModified = lastModified;
    }

    public InputStream openInputStream() throws FileNotFoundException {
        return new ByteArrayInputStream(this.data);
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.data);
    }

    public String toString() {
        return ":" + this.data.length + ":";
    }

    public static void build(Jar jar, InputStream in, long lastModified) throws IOException {
        ZipInputStream jin = new ZipInputStream(in);
        ZipEntry entry = jin.getNextEntry();
        while (entry != null) {
            if (!entry.isDirectory()) {
                byte[] data = EmbeddedResource.collect(jin, 0);
                jar.putResource(entry.getName(), new EmbeddedResource(data, lastModified));
            }
            entry = jin.getNextEntry();
        }
        jin.close();
    }

    static byte[] collect(InputStream in, int offset) throws IOException {
        byte[] buffer = new byte[10000];
        int size = in.read(buffer);
        if (size <= 0) {
            return new byte[offset];
        }
        byte[] result = EmbeddedResource.collect(in, offset + size);
        System.arraycopy(buffer, 0, result, offset, size);
        return result;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public static void build(Jar sub, Resource resource) throws IOException {
        InputStream in = resource.openInputStream();
        EmbeddedResource.build(sub, in, resource.lastModified());
        in.close();
    }

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }
}

