/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.osgi;

import aQute.lib.osgi.Clazz;
import aQute.lib.osgi.EmbeddedResource;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Resource;
import aQute.lib.osgi.header.OSGiHeader;
import aQute.lib.reporter.Reporter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Processor
implements Reporter {
    public static final String DEFAULT_BND_EXTENSION = ".bnd";
    public static final String DEFAULT_JAR_EXTENSION = ".jar";
    public static final String DEFAULT_BAR_EXTENSION = ".bar";
    List errors = new ArrayList();
    List warnings = new ArrayList();
    List progress = new ArrayList();
    boolean pedantic;
    static Pattern packageinfo = Pattern.compile("version\\s+([0-9.]+).*");

    public void getInfo(Reporter processor) {
        this.errors.addAll(processor.getErrors());
        this.warnings.addAll(processor.getWarnings());
        this.progress.addAll(processor.getProgress());
        this.pedantic = processor.isPedantic();
    }

    public void warning(String string) {
        this.warnings.add(string);
    }

    public void error(String string) {
        this.errors.add(string);
    }

    public List getWarnings() {
        return this.warnings;
    }

    public List getErrors() {
        return this.errors;
    }

    public Map parseHeader(String value) {
        return Processor.parseHeader(value, this);
    }

    public static Map parseHeader(String value, Processor logger) {
        return OSGiHeader.parseHeader(value, logger);
    }

    public Map analyzeBundleClasspath(Jar dot, Map bundleClasspath, Map contained, Map referred, Map uses) throws IOException {
        HashMap classSpace = new HashMap();
        if (bundleClasspath.isEmpty()) {
            this.analyzeJar(dot, "", classSpace, contained, referred, uses);
        } else {
            Iterator j = bundleClasspath.keySet().iterator();
            while (j.hasNext()) {
                String path = (String)j.next();
                if (path.equals(".")) {
                    this.analyzeJar(dot, "", classSpace, contained, referred, uses);
                    continue;
                }
                Resource resource = dot.getResource(path);
                if (resource != null) {
                    try {
                        Jar jar = new Jar(path);
                        EmbeddedResource.build(jar, resource);
                        this.analyzeJar(jar, "", classSpace, contained, referred, uses);
                    }
                    catch (Exception e) {
                        this.warning("Invalid bundle classpath entry: " + path + " " + e);
                    }
                    continue;
                }
                if (dot.getDirectories().containsKey(path)) {
                    this.analyzeJar(dot, path, classSpace, contained, referred, uses);
                    continue;
                }
                this.warning("No sub JAR or directory " + path);
            }
        }
        return classSpace;
    }

    private void analyzeJar(Jar jar, String prefix, Map classSpace, Map contained, Map referred, Map uses) throws IOException {
        Iterator r = jar.getResources().keySet().iterator();
        while (r.hasNext()) {
            Clazz clazz;
            InputStream in;
            String path = (String)r.next();
            if (!path.startsWith(prefix)) continue;
            String relativePath = path.substring(prefix.length());
            String pack = this.getPackage(relativePath);
            if (!(contained.containsKey(pack) || pack.equals(".") || pack.equals("META-INF"))) {
                HashMap<String, String> map = new HashMap<String, String>();
                contained.put(pack, map);
                Resource pinfo = jar.getResource(String.valueOf(prefix) + pack.replace('.', '/') + "/packageinfo");
                if (pinfo != null) {
                    in = pinfo.openInputStream();
                    String version = Processor.parsePackageInfo(in);
                    in.close();
                    if (version != null) {
                        map.put("version", version);
                    }
                }
            }
            if (!path.endsWith(".class")) continue;
            Resource resource = jar.getResource(path);
            try {
                in = resource.openInputStream();
                clazz = new Clazz(relativePath, in);
                in.close();
            }
            catch (Throwable e) {
                this.errors.add("Invalid class file: " + relativePath + " " + e.getMessage());
                continue;
            }
            classSpace.put(relativePath, clazz);
            referred.putAll(clazz.getReferred());
            HashSet t = (HashSet)uses.get(pack);
            if (t == null) {
                t = new HashSet();
                uses.put(pack, t);
            }
            t.addAll(clazz.getReferred().keySet());
            t.remove(pack);
        }
    }

    public String getPackage(String clazz) {
        int n = clazz.lastIndexOf(47);
        if (n < 0) {
            return ".";
        }
        return clazz.substring(0, n).replace('/', '.');
    }

    static String parsePackageInfo(InputStream jar) throws IOException {
        try {
            byte[] buf = EmbeddedResource.collect(jar, 0);
            String line = new String(buf).trim();
            Matcher m = packageinfo.matcher(line);
            if (m.matches()) {
                return m.group(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    static Map removeKeys(Map source, String prefix) {
        TreeMap temp = new TreeMap(source);
        Iterator p = temp.keySet().iterator();
        while (p.hasNext()) {
            String pack = (String)p.next();
            if (!pack.startsWith(prefix)) continue;
            p.remove();
        }
        return temp;
    }

    public List getProgress() {
        return this.progress;
    }

    public void progress(String s) {
        this.progress.add(s);
    }

    public boolean isPedantic() {
        return this.pedantic;
    }

    public void setPedantic(boolean pedantic) {
        this.pedantic = pedantic;
    }

    public static File getFile(File base, String file) {
        int n;
        File f = new File(file);
        if (f.isAbsolute()) {
            return f;
        }
        f = base.getAbsoluteFile();
        while ((n = file.indexOf(47)) > 0) {
            String first = file.substring(0, n);
            file = file.substring(n + 1);
            f = first.equals("..") ? f.getParentFile() : new File(f, first);
        }
        return new File(f, file);
    }
}

