/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.osgi.header;

import aQute.lib.qtokens.QuotedTokenizer;
import aQute.lib.reporter.Reporter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class OSGiHeader {
    public static Map parseHeader(String value) {
        return OSGiHeader.parseHeader(value, null);
    }

    public static Map parseHeader(String value, Reporter logger) {
        if (value == null || value.trim().length() == 0) {
            return new HashMap();
        }
        LinkedHashMap result = new LinkedHashMap();
        QuotedTokenizer qt = new QuotedTokenizer(value, ";=,");
        char del = '\u0000';
        do {
            boolean hadAttribute = false;
            HashMap<String, String> clause = new HashMap<String, String>();
            ArrayList<String> aliases = new ArrayList<String>();
            String name = qt.nextToken();
            del = qt.getSeparator();
            if (name == null || name.length() == 0) {
                if (logger != null && logger.isPedantic()) {
                    logger.warning("Empty clause, usually caused by repeating a comma without any name field: " + value);
                }
                if (name != null) continue;
                break;
            }
            aliases.add(name);
            while (del == ';') {
                String adname = qt.nextToken();
                del = qt.getSeparator();
                if (del != '=') {
                    if (hadAttribute && logger != null) {
                        logger.error("Header contains name field after attribute or directive: " + adname + " from " + value + ". Name fields must be consecutive, separated by a ';' like a;b;c;x=3;y=4");
                    }
                    if (adname.length() <= 0) continue;
                    aliases.add(adname);
                    continue;
                }
                String advalue = qt.nextToken();
                if (clause.containsKey(adname) && logger != null && logger.isPedantic()) {
                    logger.warning("Duplicate attribute/directive name " + adname + " in " + value + ". This attribute/directive will be ignored");
                }
                clause.put(adname, advalue);
                del = qt.getSeparator();
                hadAttribute = true;
            }
            Iterator i = aliases.iterator();
            while (i.hasNext()) {
                String clauseName = (String)i.next();
                if (result.containsKey(clauseName)) {
                    if (logger == null || !logger.isPedantic()) continue;
                    logger.warning("Duplicate name " + clauseName + " used in header: '" + clauseName + "'. Duplicate names in one clause not supported in Bnd.");
                    continue;
                }
                result.put(clauseName, clause);
            }
        } while (del == ',');
        return result;
    }
}

