/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.Pipeline;
import com.sun.grizzly.PipelineFullException;
import com.sun.grizzly.util.ByteBufferFactory;
import com.sun.grizzly.util.WorkerThreadImpl;
import java.nio.channels.SelectionKey;
import java.util.LinkedList;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPipeline
extends LinkedList<Callable>
implements Pipeline<Callable> {
    protected int waitingThreads = 0;
    protected int maxThreads = 20;
    protected int minThreads = 5;
    protected int minSpareThreads = 2;
    protected int port = 8080;
    protected int threadCount = 0;
    protected String name = "Grizzly";
    protected int priority = 5;
    protected boolean isStarted = false;
    protected transient WorkerThreadImpl[] workerThreads;
    protected int maxQueueSizeInBytes = -1;
    protected int threadsIncrement = 1;
    protected int initialByteBufferSize = 8192;
    private ByteBufferFactory.ByteBufferType byteBufferType = ByteBufferFactory.ByteBufferType.HEAP_VIEW;

    public DefaultPipeline() {
    }

    public DefaultPipeline(int maxThreads, int minThreads, String name, int port, int priority) {
        this.maxThreads = maxThreads;
        this.port = port;
        this.name = name;
        this.minThreads = minThreads;
        this.priority = priority;
        if (minThreads < this.minSpareThreads) {
            this.minSpareThreads = minThreads;
        }
    }

    public DefaultPipeline(int maxThreads, int minThreads, String name, int port) {
        this(maxThreads, minThreads, name, port, 5);
    }

    @Override
    public synchronized void initPipeline() {
        if (this.isStarted) {
            return;
        }
        if (this.minThreads > this.maxThreads) {
            this.minThreads = this.maxThreads;
        }
        this.workerThreads = new WorkerThreadImpl[this.maxThreads];
        this.increaseWorkerThread(this.minThreads, false);
    }

    @Override
    public synchronized void startPipeline() {
        if (!this.isStarted) {
            for (int i = 0; i < this.minThreads; ++i) {
                this.workerThreads[i].start();
            }
            this.isStarted = true;
        }
    }

    @Override
    public synchronized void stopPipeline() {
        if (this.isStarted) {
            this.isStarted = false;
            for (int i = 0; i < this.threadCount; ++i) {
                this.workerThreads[i].terminate();
            }
        }
        this.threadCount = 0;
        this.waitingThreads = 0;
        this.notifyAll();
    }

    protected void increaseWorkerThread(int increment, boolean startThread) {
        int currentCount = this.threadCount;
        int increaseCount = this.threadCount + increment;
        for (int i = currentCount; i < increaseCount; ++i) {
            WorkerThreadImpl workerThread = new WorkerThreadImpl(this, this.name + "WorkerThread-" + this.port + "-" + i, this.initialByteBufferSize);
            workerThread.setByteBufferType(this.byteBufferType);
            workerThread.setPriority(this.priority);
            if (startThread) {
                workerThread.start();
            }
            this.workerThreads[i] = workerThread;
            ++this.threadCount;
        }
    }

    public synchronized boolean interruptThread(long threadID) {
        ThreadGroup threadGroup = this.workerThreads[0].getThreadGroup();
        Thread[] threads = new Thread[threadGroup.activeCount()];
        threadGroup.enumerate(threads);
        for (Thread thread : threads) {
            if (thread == null || thread.getId() != threadID || Thread.State.RUNNABLE == thread.getState()) continue;
            try {
                thread.interrupt();
                return true;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public synchronized void execute(Callable callable) throws PipelineFullException {
        int queueSize = this.size();
        if (this.maxQueueSizeInBytes != -1 && this.maxQueueSizeInBytes < queueSize) {
            throw new PipelineFullException("Queue is full");
        }
        this.addLast(callable);
        this.notify();
        if (this.threadCount < this.maxThreads && this.waitingThreads < queueSize + 1) {
            int left = this.maxThreads - this.threadCount;
            if (this.threadsIncrement > left) {
                this.threadsIncrement = left;
            }
            this.increaseWorkerThread(this.threadsIncrement, true);
        }
    }

    @Override
    public synchronized Callable waitForIoTask() {
        if (this.size() - this.waitingThreads <= 0) {
            try {
                ++this.waitingThreads;
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            --this.waitingThreads;
        }
        return (Callable)this.poll();
    }

    @Override
    public boolean expireKey(SelectionKey key) {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() - this.getWaitingThread() <= 0;
    }

    @Override
    public synchronized int getWaitingThread() {
        return this.waitingThreads;
    }

    @Override
    public synchronized void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    @Override
    public synchronized int getMaxThreads() {
        return this.maxThreads;
    }

    @Override
    public synchronized int getCurrentThreadCount() {
        return this.threadCount;
    }

    @Override
    public synchronized int getCurrentThreadsBusy() {
        return this.threadCount - this.waitingThreads;
    }

    public synchronized int getMaxSpareThreads() {
        return this.maxThreads;
    }

    public synchronized int getMinSpareThreads() {
        return this.minSpareThreads;
    }

    public synchronized void setMinSpareThreads(int minSpareThreads) {
        this.minSpareThreads = minSpareThreads;
    }

    @Override
    public synchronized void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public synchronized void setName(String name) {
        this.name = name;
    }

    @Override
    public synchronized String getName() {
        return this.name + this.port;
    }

    @Override
    public synchronized void setPort(int port) {
        this.port = port;
    }

    @Override
    public synchronized void setMinThreads(int minThreads) {
        this.minThreads = minThreads;
    }

    @Override
    public String toString() {
        return "name: " + this.name + " maxThreads: " + this.maxThreads + " type: " + this.getClass().getName();
    }

    @Override
    public synchronized void setThreadsIncrement(int threadsIncrement) {
        this.threadsIncrement = threadsIncrement;
    }

    public synchronized int getTaskQueuedCount() {
        return this.size();
    }

    @Override
    public synchronized void setQueueSizeInBytes(int maxQueueSizeInBytesCount) {
        this.maxQueueSizeInBytes = maxQueueSizeInBytesCount;
    }

    public synchronized int getQueueSizeInBytes() {
        return this.maxQueueSizeInBytes;
    }

    public synchronized int getInitialByteBufferSize() {
        return this.initialByteBufferSize;
    }

    public synchronized void setInitialByteBufferSize(int size) {
        this.initialByteBufferSize = size;
    }

    public ByteBufferFactory.ByteBufferType getByteBufferType() {
        return this.byteBufferType;
    }

    public void setByteBufferType(ByteBufferFactory.ByteBufferType byteBufferType) {
        this.byteBufferType = byteBufferType;
    }
}

