/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.jruby;

import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.jruby.RubyObjectPool;
import com.sun.grizzly.jruby.RubyRuntimeAsyncFilter;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.DynamicContentAdapter;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.InternalOutputBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyException;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class RailsAdapter
extends DynamicContentAdapter
implements Adapter {
    private static final int RAILS_TOKEN = 17;
    private RubyObjectPool pool = null;
    private RubyRuntimeAsyncFilter asyncFilter;
    private Map environment;

    public RailsAdapter(RubyObjectPool pool) {
        super(pool.getRailsRoot() + "public");
        this.pool = pool;
    }

    public RailsAdapter(RubyObjectPool pool, RubyRuntimeAsyncFilter asyncFilter) {
        this(pool);
        this.asyncFilter = asyncFilter;
    }

    protected int getTokenID() {
        return 17;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceDynamicContent(Request req, Response res) throws IOException {
        Ruby runtime = null;
        DynamicContentAdapter.RequestTupple rt = (DynamicContentAdapter.RequestTupple)req.getNote(17);
        if (rt == null) {
            rt = new DynamicContentAdapter.RequestTupple(this);
        }
        rt.req = req;
        try {
            runtime = this.pool.borrowRuntime();
            if (runtime == null) {
                throw new IllegalStateException("No Rails Instances available to satisfy the current request");
            }
            this.dispatchRailsRequest(runtime, res, rt);
        }
        finally {
            rt.recycle();
            req.setNote(17, rt);
            if (runtime != null) {
                this.pool.returnRuntime(runtime);
                if (this.asyncFilter != null) {
                    this.asyncFilter.resume();
                }
            }
        }
    }

    private void dispatchRailsRequest(Ruby runtime, Response res, DynamicContentAdapter.RequestTupple rt) throws IOException {
        try {
            Request req = rt.req;
            req.doRead(rt.readChunk);
            ((InternalOutputBuffer)res.getOutputBuffer()).commit();
            res.setCommitted(true);
            RubyIO iObj = new RubyIO(runtime, rt.inputStream);
            runtime.defineReadonlyVariable("$stdin", iObj);
            OutputStream os = ((InternalOutputBuffer)res.getOutputBuffer()).getOutputStream();
            RubyIO oObj = new RubyIO(runtime, os);
            runtime.defineReadonlyVariable("$stdout", oObj);
            this.loadRuntimeEnvironment(runtime);
            Object[] args = new IRubyObject[]{JavaEmbedUtils.javaToRuby(runtime, req)};
            IRubyObject responder = runtime.getGlobalVariables().get("$responder");
            JavaEmbedUtils.invokeMethod(runtime, responder, "service", args, IRubyObject.class);
        }
        catch (RaiseException e) {
            RubyException exception = e.getException();
            System.err.println(e.getMessage());
            exception.printBacktrace(System.err);
            throw e;
        }
    }

    private void loadRuntimeEnvironment(Ruby runtime) {
        RubyHash env = (RubyHash)runtime.getObject().getConstant("ENV");
        if (this.environment == null) {
            IRubyObject loggerObj = JavaEmbedUtils.javaToRuby(runtime, SelectorThread.logger());
            runtime.defineReadonlyVariable("$logger", loggerObj);
            if (this.contextRoot != null && !this.contextRoot.equals("/")) {
                runtime.defineReadonlyVariable("$root", JavaEmbedUtils.javaToRuby(runtime, this.contextRoot));
            }
            this.environment = new HashMap();
            this.environment.putAll(env);
        } else {
            env.clear();
            env.putAll(this.environment);
        }
    }
}

