/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.jruby;

import com.sun.grizzly.arp.AsyncProcessorTask;
import com.sun.grizzly.http.AsyncExecutor;
import com.sun.grizzly.http.AsyncFilter;
import com.sun.grizzly.jruby.RailsSelectorThread;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyRuntimeAsyncFilter
implements AsyncFilter {
    private BlockingQueue<?> rubyRuntimeQueue;
    private LinkedBlockingQueue<AsyncProcessorTask> suspendedRequests = new LinkedBlockingQueue();

    @Override
    public boolean doFilter(AsyncExecutor asyncExecutor) {
        AsyncProcessorTask apt = (AsyncProcessorTask)asyncExecutor.getAsyncTask();
        if (this.rubyRuntimeQueue.size() == 0) {
            this.suspendedRequests.offer(apt);
            return false;
        }
        try {
            apt.getProcessorTask().invokeAdapter();
        }
        catch (IllegalStateException ex) {
            this.suspendedRequests.offer(apt);
            return false;
        }
        apt.setStage(2);
        return true;
    }

    protected void setRubyRuntimeQueue(BlockingQueue<?> rubyRuntimeQueue) {
        this.rubyRuntimeQueue = rubyRuntimeQueue;
    }

    protected void resume() {
        block4: {
            AsyncProcessorTask apt = this.suspendedRequests.poll();
            if (apt == null) {
                return;
            }
            apt.setStage(4);
            try {
                apt.doTask();
            }
            catch (IllegalStateException e) {
                this.suspendedRequests.offer(apt);
            }
            catch (IOException ex) {
                if (!RailsSelectorThread.logger().isLoggable(Level.FINEST)) break block4;
                RailsSelectorThread.logger().log(Level.FINEST, "", ex);
            }
        }
    }
}

