/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.FromNativeContext;
import com.sun.jna.NativeMapped;
import com.sun.jna.ToNativeContext;
import com.sun.jna.TypeConverter;

public class NativeMappedConverter
implements TypeConverter {
    private Class type;
    private Class nativeType;
    private NativeMapped instance;

    public NativeMappedConverter(Class type) {
        if (!NativeMapped.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Type must derive from " + NativeMapped.class);
        }
        this.type = type;
        this.instance = this.defaultValue();
        this.nativeType = this.instance.nativeType();
    }

    public NativeMapped defaultValue() {
        try {
            return (NativeMapped)this.type.newInstance();
        }
        catch (InstantiationException e) {
            String msg = "Can't create an instance of " + this.type + ", requires a no-arg constructor: " + e;
            throw new IllegalArgumentException(msg);
        }
        catch (IllegalAccessException e) {
            String msg = "Not allowed to create an instance of " + this.type + ", requires a public, no-arg constructor: " + e;
            throw new IllegalArgumentException(msg);
        }
    }

    public Object fromNative(Object nativeValue, FromNativeContext context) {
        return this.instance.fromNative(nativeValue, context);
    }

    public Class nativeType() {
        return this.nativeType;
    }

    public Object toNative(Object value, ToNativeContext context) {
        return ((NativeMapped)value).toNative();
    }
}

