/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin;

import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Jar;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.bundleplugin.BundleInfo;
import org.apache.felix.bundleplugin.ManifestPlugin;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTree;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;

public class BundleAllPlugin
extends ManifestPlugin {
    private static final Pattern SNAPSHOT_VERSION_PATTERN = Pattern.compile("[0-9]{8}_[0-9]{6}_[0-9]+");
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private ArtifactFactory factory;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector collector;
    private ArtifactResolver artifactResolver;
    private DependencyTreeBuilder dependencyTreeBuilder;
    private MavenProjectBuilder mavenProjectBuilder;

    public void execute() throws MojoExecutionException {
        BundleInfo bundleInfo = this.bundleAll(this.getProject());
        this.logDuplicatedPackages(bundleInfo);
    }

    private BundleInfo bundleAll(MavenProject project) throws MojoExecutionException {
        return this.bundleAll(project, Integer.MAX_VALUE);
    }

    protected BundleInfo bundleAll(MavenProject project, int depth) throws MojoExecutionException {
        DependencyTree dependencyTree;
        if (this.alreadyBundled(project.getArtifact())) {
            this.getLog().debug("Ignoring project already processed " + project.getArtifact());
            return null;
        }
        try {
            dependencyTree = this.dependencyTreeBuilder.buildDependencyTree(project, this.localRepository, this.factory, this.artifactMetadataSource, this.collector);
        }
        catch (DependencyTreeBuilderException e) {
            throw new MojoExecutionException("Unable to build dependency tree", e);
        }
        this.getLog().debug("Will bundle the following dependency tree\n" + dependencyTree);
        BundleInfo bundleInfo = new BundleInfo();
        Iterator it = dependencyTree.inverseIterator();
        while (it.hasNext()) {
            MavenProject childProject;
            DependencyNode node = (DependencyNode)it.next();
            if (!it.hasNext()) break;
            Artifact artifact = this.resolveArtifact(node.getArtifact());
            node.getArtifact().setFile(artifact.getFile());
            if (node.getDepth() > depth) {
                this.getLog().debug("Ignoring " + node.getArtifact() + ", depth is " + node.getDepth() + ", bigger than " + depth);
                continue;
            }
            try {
                childProject = this.mavenProjectBuilder.buildFromRepository(artifact, this.remoteRepositories, this.localRepository, true);
            }
            catch (ProjectBuildingException e) {
                throw new MojoExecutionException("Unable to build project object for artifact " + artifact, e);
            }
            childProject.setArtifact(artifact);
            this.getLog().debug("Child project artifact location: " + childProject.getArtifact().getFile());
            if (artifact.getScope().equals("compile") || artifact.getScope().equals("runtime")) {
                BundleInfo subBundleInfo = this.bundleAll(childProject, depth - 1);
                if (subBundleInfo == null) continue;
                bundleInfo.merge(subBundleInfo);
                continue;
            }
            this.getLog().debug("Not processing due to scope (" + childProject.getArtifact().getScope() + "): " + childProject.getArtifact());
        }
        if (this.getProject() != project) {
            this.getLog().debug("Project artifact location: " + project.getArtifact().getFile());
            BundleInfo subBundleInfo = this.bundle(project);
            if (subBundleInfo != null) {
                bundleInfo.merge(subBundleInfo);
            }
        }
        return bundleInfo;
    }

    BundleInfo bundle(MavenProject project) throws MojoExecutionException {
        Artifact artifact = project.getArtifact();
        this.getLog().info("Bundling " + artifact);
        try {
            Set exportedPackages;
            HashMap<String, String> instructions = new HashMap<String, String>();
            instructions.put("Export-Package", "*");
            project.getArtifact().setFile(this.getFile(artifact));
            File outputFile = this.getOutputFile(artifact);
            if (project.getArtifact().getFile().equals(outputFile)) {
                return null;
            }
            Analyzer analyzer = this.getAnalyzer(project, this.getClasspath(project));
            Jar osgiJar = new Jar(project.getArtifactId(), project.getArtifact().getFile());
            if (this.isOsgi(osgiJar)) {
                this.getLog().info("Using existing OSGi bundle for " + project.getGroupId() + ":" + project.getArtifactId() + ":" + project.getVersion());
                String exportHeader = osgiJar.getManifest().getMainAttributes().getValue("Export-Package");
                exportedPackages = analyzer.parseHeader(exportHeader).keySet();
            } else {
                exportedPackages = analyzer.getExports().keySet();
                Manifest manifest = analyzer.getJar().getManifest();
                osgiJar.setManifest(manifest);
            }
            outputFile.getAbsoluteFile().getParentFile().mkdirs();
            osgiJar.write(outputFile);
            BundleInfo bundleInfo = this.addExportedPackages(project, exportedPackages);
            return bundleInfo;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error generating OSGi bundle for project " + this.getArtifactKey(project.getArtifact()), e);
        }
    }

    private boolean isOsgi(Jar jar) throws IOException {
        return jar.getManifest().getMainAttributes().getValue("Bundle-Name") != null;
    }

    private BundleInfo addExportedPackages(MavenProject project, Collection packages) {
        BundleInfo bundleInfo = new BundleInfo();
        Iterator it = packages.iterator();
        while (it.hasNext()) {
            String packageName = (String)it.next();
            bundleInfo.addExportedPackage(packageName, project.getArtifact());
        }
        return bundleInfo;
    }

    private String getArtifactKey(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId();
    }

    protected String getBundleName(MavenProject project) {
        return this.getBundleName(project.getArtifact());
    }

    private String getBundleName(Artifact artifact) {
        return this.getMaven2OsgiConverter().getBundleFileName(artifact);
    }

    private boolean alreadyBundled(Artifact artifact) {
        return this.getBuiltFile(artifact) != null;
    }

    protected File getFile(Artifact artifact) {
        File bundle = this.getBuiltFile(artifact);
        if (bundle != null) {
            this.getLog().debug("Using previously built OSGi bundle for " + artifact + " in " + bundle);
            return bundle;
        }
        return super.getFile(artifact);
    }

    private File getBuiltFile(final Artifact artifact) {
        File bundle = null;
        File outputFile = this.getOutputFile(artifact);
        if (outputFile.exists()) {
            bundle = outputFile;
        }
        if (bundle == null && artifact.isSnapshot()) {
            File[] files;
            final File buildDirectory = new File(this.getBuildDirectory());
            if (!buildDirectory.exists()) {
                buildDirectory.mkdirs();
            }
            if ((files = buildDirectory.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return dir.equals(buildDirectory) && BundleAllPlugin.this.snapshotMatch(artifact, name);
                }
            })).length > 1) {
                throw new RuntimeException("More than one previously built bundle matches for artifact " + artifact + " : " + Arrays.asList(files));
            }
            if (files.length == 1) {
                bundle = files[0];
            }
        }
        return bundle;
    }

    boolean snapshotMatch(Artifact artifact, String bundleName) {
        String artifactBundleName = this.getBundleName(artifact);
        int i = artifactBundleName.indexOf("SNAPSHOT");
        if (i < 0) {
            return false;
        }
        if (bundleName.startsWith(artifactBundleName = artifactBundleName.substring(0, i))) {
            String timestamp = bundleName.substring(artifactBundleName.length(), bundleName.lastIndexOf(".jar"));
            Matcher m = SNAPSHOT_VERSION_PATTERN.matcher(timestamp);
            return m.matches();
        }
        return false;
    }

    protected File getOutputFile(Artifact artifact) {
        return new File(this.getOutputDirectory(), this.getBundleName(artifact));
    }

    private Artifact resolveArtifact(Artifact artifact) throws MojoExecutionException {
        Artifact resolvedArtifact = this.factory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope(), artifact.getType());
        try {
            this.artifactResolver.resolve(resolvedArtifact, this.remoteRepositories, this.localRepository);
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Artifact was not found in the repo" + resolvedArtifact, e);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Error resolving artifact " + resolvedArtifact, e);
        }
        return resolvedArtifact;
    }

    protected void logDuplicatedPackages(BundleInfo bundleInfo) {
        Map duplicatedExports = bundleInfo.getDuplicatedExports();
        Iterator it = duplicatedExports.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String packageName = (String)entry.getKey();
            Collection artifacts = (Collection)entry.getValue();
            this.getLog().warn("Package " + packageName + " is exported in more than a bundle: ");
            Iterator it2 = artifacts.iterator();
            while (it2.hasNext()) {
                Artifact artifact = (Artifact)it2.next();
                this.getLog().warn("  " + artifact);
            }
        }
    }
}

