/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin;

import aQute.lib.osgi.Builder;
import aQute.lib.osgi.EmbeddedResource;
import aQute.lib.osgi.FileResource;
import aQute.lib.osgi.Jar;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.osgi.Maven2OsgiConverter;

public class BundlePlugin
extends AbstractMojo {
    private List supportedProjectTypes = Arrays.asList("jar", "bundle");
    private File outputDirectory;
    private File baseDir;
    private String buildDirectory;
    private MavenProject project;
    private Map instructions = new HashMap();
    private Maven2OsgiConverter maven2OsgiConverter;

    protected Maven2OsgiConverter getMaven2OsgiConverter() {
        return this.maven2OsgiConverter;
    }

    void setMaven2OsgiConverter(Maven2OsgiConverter maven2OsgiConverter) {
        this.maven2OsgiConverter = maven2OsgiConverter;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public void execute() throws MojoExecutionException {
        Properties properties = new Properties();
        if (!this.supportedProjectTypes.contains(this.getProject().getArtifact().getType())) {
            this.getLog().debug("Ignoring project " + this.getProject().getArtifact() + " : type " + this.getProject().getArtifact().getType() + " is not supported by bundle plugin, supported types are " + this.supportedProjectTypes);
            return;
        }
        this.execute(this.project, this.instructions, properties);
    }

    protected void execute(MavenProject project, Map instructions, Properties properties) throws MojoExecutionException {
        try {
            this.execute(project, instructions, properties, this.getClasspath(project));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error calculating classpath for project " + project, e);
        }
    }

    protected Map transformDirectives(Map instructions) {
        HashMap<String, String> transformedInstructions = new HashMap<String, String>();
        Iterator i = instructions.entrySet().iterator();
        while (i.hasNext()) {
            String value;
            Map.Entry e = i.next();
            String key = (String)e.getKey();
            if (key.startsWith("_")) {
                key = "-" + key.substring(1);
            }
            if (null == (value = (String)e.getValue())) {
                value = "";
            }
            transformedInstructions.put(key, value);
        }
        return transformedInstructions;
    }

    protected void execute(MavenProject project, Map instructions, Properties properties, Jar[] classpath) throws MojoExecutionException {
        try {
            File jarFile = new File(this.getBuildDirectory(), this.getBundleName(project));
            properties.putAll((Map<?, ?>)this.getDefaultProperties(project));
            String bsn = project.getGroupId() + "." + project.getArtifactId();
            if (!instructions.containsKey("Private-Package")) {
                properties.put("Export-Package", bsn + ".*");
            }
            properties.putAll((Map<?, ?>)this.transformDirectives(instructions));
            String mavenResourcePaths = this.getMavenResourcePaths();
            if (mavenResourcePaths.length() > 0) {
                String includeResource = (String)properties.get("Include-Resource");
                if (includeResource != null) {
                    this.getLog().warn("Include-Resource: overriding " + mavenResourcePaths + " with " + includeResource);
                } else {
                    properties.put("Include-Resource", mavenResourcePaths);
                }
            }
            Builder builder = new Builder();
            builder.setBase(this.baseDir);
            builder.setProperties(properties);
            builder.setClasspath(classpath);
            builder.build();
            Jar jar = builder.getJar();
            this.doMavenMetadata(project, jar);
            builder.setJar(jar);
            List errors = builder.getErrors();
            List warnings = builder.getWarnings();
            if (errors.size() > 0) {
                jarFile.delete();
                Iterator e = errors.iterator();
                while (e.hasNext()) {
                    String msg = (String)e.next();
                    this.getLog().error("Error building bundle " + project.getArtifact() + " : " + msg);
                }
                throw new MojoFailureException("Found errors, see log");
            }
            jarFile.getParentFile().mkdirs();
            builder.getJar().write(jarFile);
            project.getArtifact().setFile(jarFile);
            Iterator w = warnings.iterator();
            while (w.hasNext()) {
                String msg = (String)w.next();
                this.getLog().warn("Warning building bundle " + project.getArtifact() + " : " + msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("Unknown error occurred", e);
        }
    }

    private Map getProperies(Model projectModel, String prefix, Object model) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Method[] methods = Model.class.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            String name = methods[i].getName();
            if (!name.startsWith("get")) continue;
            try {
                Object v = methods[i].invoke((Object)projectModel, null);
                if (v == null) continue;
                name = prefix + Character.toLowerCase(name.charAt(3)) + name.substring(4);
                if (v.getClass().isArray()) {
                    properties.put(name, Arrays.asList((Object[])v).toString());
                    continue;
                }
                properties.put(name, v);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return properties;
    }

    private StringBuffer printLicenses(List licenses) {
        if (licenses == null || licenses.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        String del = "";
        Iterator i = licenses.iterator();
        while (i.hasNext()) {
            License l = (License)i.next();
            String url = l.getUrl();
            sb.append(del);
            sb.append(url);
            del = ", ";
        }
        return sb;
    }

    private void doMavenMetadata(MavenProject project, Jar jar) throws IOException {
        String path = "META-INF/maven/" + project.getGroupId() + "/" + project.getArtifactId();
        File pomFile = new File(this.baseDir, "pom.xml");
        jar.putResource(path + "/pom.xml", new FileResource(pomFile));
        Properties p = new Properties();
        p.put("version", project.getVersion());
        p.put("groupId", project.getGroupId());
        p.put("artifactId", project.getArtifactId());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        p.store(out, "Generated by org.apache.felix.plugin.bundle");
        jar.putResource(path + "/pom.properties", new EmbeddedResource(out.toByteArray(), System.currentTimeMillis()));
    }

    protected Jar[] getClasspath(MavenProject project) throws ZipException, IOException {
        ArrayList<Jar> list = new ArrayList<Jar>();
        if (this.getOutputDirectory() != null && this.getOutputDirectory().exists()) {
            list.add(new Jar(".", this.getOutputDirectory()));
        }
        Set artifacts = project.getDependencyArtifacts();
        Iterator it = artifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            if (!"compile".equals(artifact.getScope()) && !"system".equals(artifact.getScope()) && !"provided".equals(artifact.getScope())) continue;
            File file = this.getFile(artifact);
            if (file == null) {
                throw new RuntimeException("File is not available for artifact " + artifact + " in project " + project.getArtifact());
            }
            Jar jar = new Jar(artifact.getArtifactId(), file);
            list.add(jar);
        }
        Jar[] cp = new Jar[list.size()];
        list.toArray(cp);
        return cp;
    }

    protected File getFile(Artifact artifact) {
        return artifact.getFile();
    }

    private void header(Properties properties, String key, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Collection && ((Collection)value).isEmpty()) {
            return;
        }
        properties.put(key, value.toString());
    }

    protected String convertVersionToOsgi(String version) {
        return this.getMaven2OsgiConverter().getVersion(version);
    }

    protected String getBundleName(MavenProject project) {
        return project.getBuild().getFinalName() + ".jar";
    }

    public String getBuildDirectory() {
        return this.buildDirectory;
    }

    void setBuildDirectory(String buildirectory) {
        this.buildDirectory = buildirectory;
    }

    public List getPackages(Jar jar) {
        ArrayList<String> packages = new ArrayList<String>();
        Iterator p = jar.getDirectories().entrySet().iterator();
        while (p.hasNext()) {
            Map.Entry directory = p.next();
            String path = (String)directory.getKey();
            String pack = path.replace('/', '.');
            packages.add(pack);
        }
        return packages;
    }

    protected Properties getDefaultProperties(MavenProject project) {
        Properties properties = new Properties();
        String bsn = project.getGroupId() + "." + project.getArtifactId();
        properties.put("Bundle-SymbolicName", bsn);
        properties.put("Import-Package", "*");
        String version = this.getMaven2OsgiConverter().getVersion(project.getVersion());
        properties.put("Bundle-Version", version);
        this.header(properties, "Bundle-Description", project.getDescription());
        this.header(properties, "Bundle-License", this.printLicenses(project.getLicenses()));
        this.header(properties, "Bundle-Name", project.getName());
        if (project.getOrganization() != null) {
            this.header(properties, "Bundle-Vendor", project.getOrganization().getName());
            if (project.getOrganization().getUrl() != null) {
                this.header(properties, "Bundle-DocURL", project.getOrganization().getUrl());
            }
        }
        properties.putAll((Map<?, ?>)project.getProperties());
        properties.putAll((Map<?, ?>)project.getModel().getProperties());
        properties.putAll((Map<?, ?>)this.getProperies(project.getModel(), "project.build.", project.getBuild()));
        properties.putAll((Map<?, ?>)this.getProperies(project.getModel(), "pom.", project.getModel()));
        properties.putAll((Map<?, ?>)this.getProperies(project.getModel(), "project.", project));
        properties.put("project.baseDir", this.baseDir);
        properties.put("project.build.directory", this.getBuildDirectory());
        properties.put("project.build.outputdirectory", this.getOutputDirectory());
        return properties;
    }

    void setBasedir(File basedir) {
        this.baseDir = basedir;
    }

    File getOutputDirectory() {
        return this.outputDirectory;
    }

    void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    String getMavenResourcePaths() {
        String basePath = this.baseDir.getAbsolutePath();
        StringBuffer resourcePaths = new StringBuffer();
        Iterator i = this.project.getResources().iterator();
        while (i.hasNext()) {
            Resource resource = (Resource)i.next();
            String sourcePath = resource.getDirectory();
            String targetPath = resource.getTargetPath();
            if (!new File(sourcePath).exists() || targetPath != null && targetPath.indexOf("..") >= 0) continue;
            String path = sourcePath;
            if (path.startsWith(basePath)) {
                path = path.substring(basePath.length() + 1);
            }
            if (targetPath != null) {
                path = targetPath + '=' + path;
            }
            if (resourcePaths.length() > 0) {
                resourcePaths.append(',');
            }
            if (resource.isFiltering()) {
                resourcePaths.append('{');
                resourcePaths.append(path);
                resourcePaths.append('}');
                continue;
            }
            resourcePaths.append(path);
        }
        return resourcePaths.toString();
    }
}

