/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin;

import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Jar;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Manifest;
import org.apache.felix.bundleplugin.BundlePlugin;
import org.apache.felix.bundleplugin.PackageVersionAnalyzer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class ManifestPlugin
extends BundlePlugin {
    private String manifestLocation;

    protected void execute(MavenProject project, Map instructions, Properties properties, Jar[] classpath) throws MojoExecutionException {
        Manifest manifest;
        try {
            manifest = this.getManifest(project, instructions, properties, classpath);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error trying to generate Manifest", e);
        }
        File outputFile = new File(this.manifestLocation + "/MANIFEST.MF");
        try {
            this.writeManifest(manifest, outputFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error trying to write Manifest to file " + outputFile, e);
        }
    }

    public Manifest getManifest(MavenProject project, Jar[] classpath) throws IOException {
        return this.getManifest(project, null, null, classpath);
    }

    public Manifest getManifest(MavenProject project, Map instructions, Properties properties, Jar[] classpath) throws IOException {
        return this.getAnalyzer(project, instructions, properties, classpath).getJar().getManifest();
    }

    protected Analyzer getAnalyzer(MavenProject project, Jar[] classpath) throws IOException {
        return this.getAnalyzer(project, new HashMap(), new Properties(), classpath);
    }

    protected Analyzer getAnalyzer(MavenProject project, Map instructions, Properties properties, Jar[] classpath) throws IOException {
        PackageVersionAnalyzer analyzer = new PackageVersionAnalyzer();
        Properties props = this.getDefaultProperties(project);
        props.putAll((Map<?, ?>)properties);
        if (!instructions.containsKey("Import-Package")) {
            props.put("Import-Package", "*");
        }
        props.putAll((Map<?, ?>)this.transformDirectives(instructions));
        analyzer.setProperties(props);
        File file = project.getArtifact().getFile();
        if (file == null) {
            analyzer.setJar(this.getOutputDirectory());
        } else {
            if (!file.exists()) {
                file.mkdirs();
            }
            analyzer.setJar(project.getArtifact().getFile());
        }
        if (classpath != null) {
            analyzer.setClasspath(classpath);
        }
        if (!instructions.containsKey("Private-Package") && !instructions.containsKey("Export-Package")) {
            String export = analyzer.calculateExportsFromContents(analyzer.getJar());
            analyzer.setProperty("Export-Package", export);
        }
        analyzer.mergeManifest(analyzer.getJar().getManifest());
        analyzer.calcManifest();
        return analyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeManifest(Manifest manifest, File outputFile) throws IOException {
        outputFile.getParentFile().mkdirs();
        FileOutputStream os = new FileOutputStream(outputFile);
        try {
            manifest.write(os);
            Object var5_4 = null;
            if (os == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (os == null) throw throwable;
            try {
                os.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            os.close();
            return;
        }
        catch (IOException e) {}
    }
}

