/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.tree;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.shared.dependency.tree.DependencyTree;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.dependency.tree.DependencyTreeResolutionListener;

public class DefaultDependencyTreeBuilder
implements DependencyTreeBuilder {
    public DependencyTree buildDependencyTree(MavenProject project, ArtifactRepository repository, ArtifactFactory factory, ArtifactMetadataSource metadataSource, ArtifactCollector collector) throws DependencyTreeBuilderException {
        DependencyTreeResolutionListener listener = new DependencyTreeResolutionListener();
        try {
            Map managedVersions = this.getManagedVersionMap(project, factory);
            if (project.getDependencyArtifacts() == null) {
                project.setDependencyArtifacts(project.createArtifacts(factory, null, null));
            }
            collector.collect(project.getDependencyArtifacts(), project.getArtifact(), managedVersions, repository, project.getRemoteArtifactRepositories(), metadataSource, null, Collections.singletonList(listener));
            return new DependencyTree(listener.getRootNode(), listener.getNodes());
        }
        catch (ProjectBuildingException exception) {
            throw new DependencyTreeBuilderException("Cannot build project dependency tree", exception);
        }
        catch (InvalidDependencyVersionException exception) {
            throw new DependencyTreeBuilderException("Cannot build project dependency tree", exception);
        }
        catch (ArtifactResolutionException exception) {
            throw new DependencyTreeBuilderException("Cannot build project dependency tree", exception);
        }
    }

    private Map getManagedVersionMap(MavenProject project, ArtifactFactory factory) throws ProjectBuildingException {
        HashMap<String, Artifact> managedVersionMap;
        DependencyManagement dependencyManagement = project.getDependencyManagement();
        if (dependencyManagement != null && dependencyManagement.getDependencies() != null) {
            String version;
            String managedVersion;
            managedVersionMap = new HashMap<String, Artifact>();
            Iterator iterator = dependencyManagement.getDependencies().iterator();
            while (iterator.hasNext()) {
                Dependency dependency = (Dependency)iterator.next();
                try {
                    VersionRange versionRange = VersionRange.createFromVersionSpec(dependency.getVersion());
                    Artifact artifact = factory.createDependencyArtifact(dependency.getGroupId(), dependency.getArtifactId(), versionRange, dependency.getType(), dependency.getClassifier(), dependency.getScope());
                    managedVersionMap.put(dependency.getManagementKey(), artifact);
                }
                catch (InvalidVersionSpecificationException exception) {
                    throw new ProjectBuildingException(project.getId(), "Unable to parse version '" + dependency.getVersion() + "' for dependency '" + dependency.getManagementKey() + "': " + exception.getMessage(), exception);
                }
            }
            Artifact managedOriginatingArtifact = (Artifact)managedVersionMap.get(project.getArtifact().getDependencyConflictId());
            if (managedOriginatingArtifact != null && !(managedVersion = managedOriginatingArtifact.getVersion()).equals(version = project.getArtifact().getVersion())) {
                managedVersionMap.remove(project.getArtifact().getDependencyConflictId());
            }
        } else {
            managedVersionMap = Collections.EMPTY_MAP;
        }
        return managedVersionMap;
    }
}

