/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.joni.BitSet;
import org.joni.Regex;
import org.joni.WarnCallback;
import org.joni.ast.CClassNode;
import org.joni.constants.OPCode;
import org.joni.encoding.Encoding;
import org.joni.exception.InternalException;

class ByteCodePrinter {
    int[] code;
    int codeLength;
    Object[] operands;
    int operantCount;
    Encoding enc;
    WarnCallback warnings;

    public ByteCodePrinter(Regex regex) {
        this.code = regex.code;
        this.codeLength = regex.codeLength;
        this.operands = regex.operands;
        this.operantCount = regex.operandLength;
        this.enc = regex.enc;
        this.warnings = regex.warnings;
    }

    public String byteCodeListToString() {
        return this.compiledByteCodeListToString();
    }

    private void pString(StringBuilder sb, int len, int s) {
        sb.append(":");
        while (len-- > 0) {
            sb.append(new String(new byte[]{(byte)this.code[s++]}));
        }
    }

    private void pLenString(StringBuilder sb, int len, int mbLen, int s) {
        int x = len * mbLen;
        sb.append(":" + len + ":");
        while (x-- > 0) {
            sb.append(new String(new byte[]{(byte)this.code[s++]}));
        }
    }

    public int compiledByteCodeToString(StringBuilder sb, int bp) {
        sb.append("[" + OPCode.OpCodeNames[this.code[bp]]);
        int n = OPCode.OpCodeArgTypes[this.code[bp]];
        if (n != -1) {
            ++bp;
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    sb.append(":(" + this.code[bp] + ")");
                    ++bp;
                    break;
                }
                case 2: {
                    sb.append(":(" + this.code[bp] + ")");
                    ++bp;
                    break;
                }
                case 3: {
                    sb.append(":" + this.code[bp]);
                    ++bp;
                    break;
                }
                case 4: {
                    sb.append(":" + this.code[bp]);
                    ++bp;
                    break;
                }
                case 5: {
                    sb.append(":" + this.code[bp]);
                    ++bp;
                    break;
                }
                case 6: {
                    sb.append(":" + this.code[bp]);
                    bp += 2;
                }
            }
        } else {
            switch (this.code[bp++]) {
                case 2: 
                case 27: 
                case 28: 
                case 92: 
                case 93: {
                    this.pString(sb, 1, bp++);
                    break;
                }
                case 3: {
                    this.pString(sb, 2, bp);
                    bp += 2;
                    break;
                }
                case 4: {
                    this.pString(sb, 3, bp);
                    bp += 3;
                    break;
                }
                case 5: {
                    this.pString(sb, 4, bp);
                    bp += 4;
                    break;
                }
                case 6: {
                    this.pString(sb, 5, bp);
                    bp += 5;
                    break;
                }
                case 7: {
                    int n2 = this.code[bp];
                    this.pLenString(sb, n2, 1, ++bp);
                    bp += n2;
                    break;
                }
                case 8: {
                    this.pString(sb, 2, bp);
                    bp += 2;
                    break;
                }
                case 9: {
                    this.pString(sb, 4, bp);
                    bp += 4;
                    break;
                }
                case 10: {
                    this.pString(sb, 6, bp);
                    bp += 6;
                    break;
                }
                case 11: {
                    int n3 = this.code[bp];
                    this.pLenString(sb, n3, 2, ++bp);
                    bp += n3 * 2;
                    break;
                }
                case 12: {
                    int n4 = this.code[bp];
                    this.pLenString(sb, n4, 3, ++bp);
                    bp += n4 * 3;
                    break;
                }
                case 13: {
                    int n5 = this.code[bp];
                    int n6 = this.code[++bp];
                    ++bp;
                    sb.append(":" + n5 + ":" + n6 + ":");
                    int n7 = n6 * n5;
                    while (n7-- > 0) {
                        sb.append(new String(new byte[]{(byte)this.code[bp++]}));
                    }
                    break;
                }
                case 14: 
                case 105: {
                    int n8 = this.enc.length((byte)this.code[bp]);
                    this.pString(sb, n8, bp);
                    bp += n8;
                    break;
                }
                case 15: 
                case 106: {
                    int n8 = this.code[bp];
                    this.pLenString(sb, n8, 1, ++bp);
                    bp += n8;
                    break;
                }
                case 16: 
                case 96: {
                    BitSet bitSet = new BitSet();
                    System.arraycopy(this.code, bp, bitSet.bits, 0, 8);
                    int n9 = bitSet.numOn();
                    bp += 8;
                    sb.append(":" + n9);
                    break;
                }
                case 19: 
                case 97: {
                    BitSet bitSet = new BitSet();
                    System.arraycopy(this.code, bp, bitSet.bits, 0, 8);
                    int n10 = bitSet.numOn();
                    bp += 8;
                    sb.append(":" + n10);
                    break;
                }
                case 17: 
                case 20: {
                    int n8 = this.code[bp];
                    int cod = this.code[++bp];
                    bp += n8;
                    sb.append(":" + cod + ":" + n8);
                    break;
                }
                case 18: 
                case 21: {
                    BitSet bitSet = new BitSet();
                    System.arraycopy(this.code, bp, bitSet.bits, 0, 8);
                    int n11 = bitSet.numOn();
                    int n8 = this.code[bp += 8];
                    int cod = this.code[++bp];
                    bp += n8;
                    sb.append(":" + n11 + ":" + cod + ":" + n8);
                    break;
                }
                case 22: {
                    CClassNode bs = (CClassNode)this.operands[this.code[bp]];
                    ++bp;
                    int n12 = bs.bs.numOn();
                    sb.append(":" + bs + ":" + n12);
                    break;
                }
                case 44: {
                    int cc = this.code[bp];
                    ++bp;
                    sb.append(":" + cc);
                    break;
                }
                case 45: 
                case 46: {
                    sb.append(" ");
                    int n8 = this.code[bp];
                    ++bp;
                    for (int argType = 0; argType < n8; ++argType) {
                        int cc = this.code[bp];
                        ++bp;
                        if (argType > 0) {
                            sb.append(", ");
                        }
                        sb.append(cc);
                    }
                    break;
                }
                case 47: {
                    int argType = this.code[bp];
                    sb.append(":" + argType);
                    int mbLen = this.code[++bp];
                    sb.append(":" + mbLen);
                    sb.append(" ");
                    int n8 = this.code[++bp];
                    ++bp;
                    for (int option = 0; option < n8; ++option) {
                        int cc = this.code[bp];
                        ++bp;
                        if (option > 0) {
                            sb.append(", ");
                        }
                        sb.append(cc);
                    }
                    break;
                }
                case 60: 
                case 61: {
                    int cc = this.code[bp];
                    int n13 = this.code[++bp];
                    ++bp;
                    sb.append(":" + cc + ":" + n13);
                    break;
                }
                case 58: 
                case 59: {
                    int n14 = this.code[bp];
                    sb.append(":(" + n14 + ")");
                    this.pString(sb, 1, ++bp);
                    ++bp;
                    break;
                }
                case 76: 
                case 104: {
                    int n8 = this.code[bp];
                    ++bp;
                    sb.append(":" + n8);
                    break;
                }
                case 77: {
                    int n15 = this.code[bp];
                    int n8 = this.code[++bp];
                    ++bp;
                    sb.append(":" + n8 + ":(" + n15 + ")");
                    break;
                }
                case 81: 
                case 82: {
                    int n16 = this.code[bp];
                    int n17 = this.code[++bp];
                    ++bp;
                    sb.append(":" + n16 + ":(" + n17 + ")");
                    break;
                }
                default: {
                    throw new InternalException("undefined code: " + this.code[--bp]);
                }
            }
        }
        sb.append("]");
        return bp;
    }

    private String compiledByteCodeListToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("code length: " + this.codeLength + "\n");
        int ncode = 0;
        int bp = 0;
        int end = this.codeLength;
        while (bp < end) {
            ++ncode;
            if (bp > 0) {
                sb.append(ncode % 5 == 0 ? "\n" : " ");
            }
            bp = this.compiledByteCodeToString(sb, bp);
        }
        sb.append("\n");
        return sb.toString();
    }
}

