/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.joni.ByteCodeMachine;
import org.joni.IntHolder;
import org.joni.Option;
import org.joni.Regex;
import org.joni.Region;
import org.joni.SearchAlgorithm;

public final class Matcher
extends ByteCodeMachine {
    int low;
    int high;

    public Matcher(Regex regex, byte[] bytes) {
        this(regex, bytes, 0, bytes.length);
    }

    public Matcher(Regex regex, byte[] bytes, int p, int end) {
        super(regex, bytes, p, end);
    }

    public final Region getRegion() {
        return this.msaRegion;
    }

    public final Region getEagerRegion() {
        return this.msaRegion != null ? this.msaRegion : new Region(this.msaBegin, this.msaEnd);
    }

    public final int getBegin() {
        return this.msaBegin;
    }

    public final int getEnd() {
        return this.msaEnd;
    }

    public final int match(int at, int range, int option) {
        this.msaInit(option, at);
        int prev = this.enc.prevCharHead(this.bytes, this.str, at);
        return this.matchAt(range, at, prev);
    }

    private boolean forwardSearchRange(byte[] bytes, int str, int end, int s, int range, IntHolder lowPrev) {
        int p;
        int pprev = -1;
        if (this.regex.dMin > 0) {
            if (this.enc.isSingleByte()) {
                p += this.regex.dMin;
            } else {
                int q = p + this.regex.dMin;
                for (p = s; p < q; p += this.enc.length(bytes[p])) {
                }
            }
        }
        block5: while ((p = this.regex.searchAlgorithm.search(this.regex, bytes, p, end, range)) != -1 && p < range) {
            if (p - this.regex.dMin < s) {
                pprev = p;
                p += this.enc.length(bytes[p]);
                continue;
            }
            if (this.regex.subAnchor != 0) {
                switch (this.regex.subAnchor) {
                    case 2: {
                        int prev;
                        if (p == str || this.enc.isNewLine(bytes, prev = this.enc.prevCharHead(bytes, pprev != -1 ? pprev : str, p), end)) break;
                        pprev = p;
                        p += this.enc.length(bytes[p]);
                        continue block5;
                    }
                    case 32: {
                        int prev;
                        if (p != end || (prev = this.enc.prevCharHead(bytes, pprev != -1 ? pprev : str, p)) == -1 || !this.enc.isNewLine(bytes, prev, end)) break;
                        pprev = p;
                        p += this.enc.length(bytes[p]);
                        continue block5;
                    }
                }
            }
            if (this.regex.dMax == 0) {
                this.low = p;
                if (lowPrev != null) {
                    lowPrev.value = this.low > s ? this.enc.prevCharHead(bytes, s, p) : this.enc.prevCharHead(bytes, pprev != -1 ? pprev : str, p);
                }
            } else if (this.regex.dMax != Integer.MAX_VALUE) {
                this.low = p - this.regex.dMax;
                if (this.low > s) {
                    this.low = this.enc.rightAdjustCharHeadWithPrev(bytes, s, this.low, lowPrev);
                    if (lowPrev != null && lowPrev.value == -1) {
                        lowPrev.value = this.enc.prevCharHead(bytes, pprev != -1 ? pprev : s, this.low);
                    }
                } else if (lowPrev != null) {
                    lowPrev.value = this.enc.prevCharHead(bytes, pprev != -1 ? pprev : str, this.low);
                }
            }
            this.high = p - this.regex.dMin;
            return true;
        }
        return false;
    }

    private boolean backwardSearchRange(byte[] bytes, int str, int end, int s, int range, int adjrange) {
        range += this.regex.dMin;
        int p = s;
        block4: while ((p = this.regex.searchAlgorithm.searchBackward(this.regex, bytes, range, adjrange, end, p, s, range)) != -1) {
            if (this.regex.subAnchor != 0) {
                switch (this.regex.subAnchor) {
                    case 2: {
                        int prev;
                        if (p == str || this.enc.isNewLine(bytes, prev = this.enc.prevCharHead(bytes, str, p), end)) break;
                        p = prev;
                        continue block4;
                    }
                    case 32: {
                        int prev;
                        if (p == end) {
                            prev = this.enc.prevCharHead(bytes, adjrange, p);
                            if (prev == -1) {
                                return false;
                            }
                            if (!this.enc.isNewLine(bytes, prev, end)) break;
                            p = prev;
                            continue block4;
                        }
                        if (this.enc.isNewLine(bytes, p, end)) break;
                        if ((p = this.enc.prevCharHead(bytes, adjrange, p)) != -1) continue block4;
                        return false;
                    }
                }
            }
            if (this.regex.dMax != Integer.MAX_VALUE) {
                this.low = p - this.regex.dMax;
                this.high = p - this.regex.dMin;
                this.high = this.enc.rightAdjustCharHead(bytes, adjrange, this.high);
            }
            return true;
        }
        return false;
    }

    private boolean matchCheck(int upperRange, int s, int prev) {
        return this.matchAt(this.end, s, prev) != -1 && !Option.isFindLongest(this.option);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int search(int start, int range, int option) {
        int n;
        int n2;
        void s;
        int origRange;
        int origStart;
        int n3 = start;
        int n4 = range;
        if (start > this.end || start < this.str) {
            return -1;
        }
        if (this.regex.anchor != 0 && this.str < this.end) {
            if ((this.regex.anchor & 4) != 0) {
                range = range > start ? start + 1 : start;
            } else if ((this.regex.anchor & 1) != 0) {
                if (range > start) {
                    if (start != this.str) {
                        return -1;
                    }
                    range = this.str + 1;
                } else {
                    if (range > this.str) return -1;
                    start = this.str;
                    range = this.str;
                }
            } else if ((this.regex.anchor & 8) != 0) {
                origStart = this.end;
                origRange = origStart;
                if (this.endBuf(start, range, origRange, origStart)) {
                    return -1;
                }
            } else if ((this.regex.anchor & 0x10) != 0) {
                int minSemiEnd = this.enc.stepBack(this.bytes, this.str, this.end, 1);
                origStart = this.end;
                if (this.enc.isNewLine(this.bytes, minSemiEnd, this.end) ? (origRange = minSemiEnd) > this.str && start <= origRange && this.endBuf(start, range, origRange, origStart) : this.endBuf(start, range, origRange = this.end, origStart)) {
                    return -1;
                }
            } else if ((this.regex.anchor & 0x8000) != 0) {
                range = range > start ? start + 1 : start;
            }
        } else if (this.str == this.end) {
            if (this.regex.thresholdLength != 0) return -1;
            int maxSemiEnd = start = this.str;
            int n5 = -1;
            this.msaInit(option, start);
            if (!this.matchCheck(this.end, maxSemiEnd, n5)) return this.mismatch();
            return this.match(maxSemiEnd);
        }
        this.msaInit(option, (int)s);
        int maxSemiEnd = start;
        if (range > start) {
            void prev;
            int n6 = maxSemiEnd > this.str ? this.enc.prevCharHead(this.bytes, this.str, maxSemiEnd) : 0;
            if (this.regex.searchAlgorithm != SearchAlgorithm.NONE) {
                origRange = range;
                if (this.regex.dMax != 0) {
                    if (this.regex.dMax == Integer.MAX_VALUE) {
                        origRange = this.end;
                    } else if ((origRange += this.regex.dMax) > this.end) {
                        origRange = this.end;
                    }
                }
                if (this.end - start < this.regex.thresholdLength) {
                    return this.mismatch();
                }
                if (this.regex.dMax != Integer.MAX_VALUE) {
                    do {
                        if (!this.forwardSearchRange(this.bytes, this.str, this.end, maxSemiEnd, origRange, this)) {
                            return this.mismatch();
                        }
                        if (maxSemiEnd < this.low) {
                            maxSemiEnd = this.low;
                            n6 = this.value;
                        }
                        while (maxSemiEnd <= this.high) {
                            if (this.matchCheck((int)prev, maxSemiEnd, n6)) {
                                return this.match(maxSemiEnd);
                            }
                            n6 = maxSemiEnd;
                            maxSemiEnd += this.enc.length(this.bytes[maxSemiEnd]);
                        }
                    } while (maxSemiEnd < range);
                    return this.mismatch();
                }
                if (!this.forwardSearchRange(this.bytes, this.str, this.end, maxSemiEnd, origRange, null)) {
                    return this.mismatch();
                }
                if ((this.regex.anchor & 0x4000) != 0) {
                    do {
                        if (this.matchCheck((int)prev, maxSemiEnd, n6)) {
                            return this.match(maxSemiEnd);
                        }
                        n6 = maxSemiEnd;
                        maxSemiEnd += this.enc.length(this.bytes[maxSemiEnd]);
                        while (!this.enc.isNewLine(this.bytes, n6, this.end) && maxSemiEnd < range) {
                            n6 = maxSemiEnd;
                            maxSemiEnd += this.enc.length(this.bytes[maxSemiEnd]);
                        }
                    } while (maxSemiEnd < range);
                    return this.mismatch();
                }
            }
            do {
                if (this.matchCheck((int)prev, maxSemiEnd, n6)) {
                    return this.match(maxSemiEnd);
                }
                n6 = maxSemiEnd;
            } while ((maxSemiEnd += this.enc.length(this.bytes[maxSemiEnd])) < range);
            if (maxSemiEnd != range || !this.matchCheck((int)prev, maxSemiEnd, n6)) return this.mismatch();
            return this.match(maxSemiEnd);
        }
        if (this.regex.searchAlgorithm != SearchAlgorithm.NONE) {
            int schStart;
            origRange = range < this.end ? this.enc.leftAdjustCharHead(this.bytes, this.str, range) : this.end;
            if (this.regex.dMax != Integer.MAX_VALUE && this.end - range >= this.regex.thresholdLength) {
                do {
                    if ((origStart = maxSemiEnd + this.regex.dMax) > this.end) {
                        origStart = this.end;
                    }
                    if (!this.backwardSearchRange(this.bytes, this.str, this.end, origStart, range, origRange)) {
                        return this.mismatch();
                    }
                    if (schStart > this.high) {
                        schStart = this.high;
                    }
                    while (schStart >= this.low) {
                        int n7 = this.enc.prevCharHead(this.bytes, this.str, schStart);
                        if (this.matchCheck((int)s, schStart, n7)) {
                            return this.match(schStart);
                        }
                        schStart = n7;
                    }
                } while (schStart >= range);
                return this.mismatch();
            }
            if (this.end - range < this.regex.thresholdLength) {
                return this.mismatch();
            }
            origStart = schStart;
            if (this.regex.dMax != 0) {
                origStart = this.regex.dMax == Integer.MAX_VALUE ? this.end : ((origStart += this.regex.dMax) > this.end ? this.end : this.enc.leftAdjustCharHead(this.bytes, start, origStart));
            }
            if (!this.backwardSearchRange(this.bytes, this.str, this.end, origStart, range, origRange)) {
                return this.mismatch();
            }
        }
        do {
            if (!this.matchCheck((int)s, n2, n = this.enc.prevCharHead(this.bytes, this.str, n2))) continue;
            return this.match(n2);
        } while ((n2 = n) >= range);
        return this.mismatch();
    }

    private boolean endBuf(int start, int range, int minSemiEnd, int maxSemiEnd) {
        if (maxSemiEnd - this.str < this.regex.anchorDmin) {
            return true;
        }
        if (range > start) {
            if (minSemiEnd - start > this.regex.anchorDmax) {
                start = minSemiEnd - this.regex.anchorDmax;
                start = start < this.end ? this.enc.rightAdjustCharHead(this.bytes, this.str, start) : this.enc.prevCharHead(this.bytes, this.str, this.end);
            }
            if (maxSemiEnd - (range - 1) < this.regex.anchorDmin) {
                range = maxSemiEnd - this.regex.anchorDmin + 1;
            }
            if (start >= range) {
                return true;
            }
        } else {
            if (minSemiEnd - range > this.regex.anchorDmax) {
                range = minSemiEnd - this.regex.anchorDmax;
            }
            if (maxSemiEnd - start < this.regex.anchorDmin) {
                start = maxSemiEnd - this.regex.anchorDmin;
                start = this.enc.leftAdjustCharHead(this.bytes, this.str, start);
            }
            if (range > start) {
                return true;
            }
        }
        return false;
    }

    private int match(int s) {
        return s - this.str;
    }

    private int mismatch() {
        if (this.msaBestLen >= 0) {
            int s = this.msaBestS;
            return this.match(s);
        }
        return -1;
    }
}

