/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.executable;

import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.ast.executable.RubiniusCMethod;
import org.jruby.ast.executable.RubiniusInstructions;
import org.jruby.internal.runtime.methods.RubiniusMethod;
import org.jruby.internal.runtime.methods.WrapperMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.parser.LocalStaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class RubiniusMachine {
    public static final RubiniusMachine INSTANCE = new RubiniusMachine();

    public static final int getInt(char[] bytecodes, int ix) {
        int val = 0;
        val += bytecodes[ix + 0] << 24;
        val += bytecodes[ix + 1] << 16;
        val += bytecodes[ix + 2] << 8;
        return val += bytecodes[ix + 3];
    }

    public IRubyObject exec(ThreadContext context, IRubyObject self, char[] bytecodes, IRubyObject[] literals, IRubyObject[] args) {
        IRubyObject[] stack = new IRubyObject[20];
        int stackTop = 0;
        stack[stackTop] = context.getRuntime().getNil();
        for (int i = 0; i < args.length; ++i) {
            stack[++stackTop] = args[i];
        }
        int ip = 0;
        int call_flags = -1;
        int cache_index = -1;
        Ruby runtime = context.getRuntime();
        block34: while (ip < bytecodes.length) {
            int n = ip;
            char c = bytecodes[ip++];
            switch (c) {
                case '\u0000': {
                    continue block34;
                }
                case '\u001d': {
                    int ix = RubiniusMachine.getInt(bytecodes, ip);
                    ip += 4;
                    String code = literals[ix].toString();
                    RubyModule val = (RubyModule)stack[stackTop--];
                    RubyArray name = (RubyArray)stack[stackTop--];
                    Visibility clzz = context.getCurrentVisibility();
                    if (code == "initialize" || clzz == Visibility.MODULE_FUNCTION) {
                        clzz = Visibility.PRIVATE;
                    }
                    RubiniusCMethod method = new RubiniusCMethod(name);
                    LocalStaticScope visibility = new LocalStaticScope(context.getCurrentScope().getStaticScope());
                    visibility.setVariables(new String[method.locals]);
                    visibility.determineModule();
                    RubiniusMethod cmethod = new RubiniusMethod(val, method, visibility, clzz);
                    val.addMethod(code, cmethod);
                    if (context.getCurrentVisibility() == Visibility.MODULE_FUNCTION) {
                        val.getSingletonClass().addMethod(code, new WrapperMethod((RubyModule)val.getSingletonClass(), cmethod, Visibility.PUBLIC));
                        val.callMethod(context, "singleton_method_added", literals[ix]);
                    }
                    if (val.isSingleton()) {
                        ((MetaClass)val).getAttached().callMethod(context, "singleton_method_added", literals[ix]);
                    } else {
                        val.callMethod(context, "method_added", literals[ix]);
                    }
                    stack[++stackTop] = name;
                    continue block34;
                }
                case 'F': {
                    stack[++stackTop] = RubyFixnum.minus_one(runtime);
                    continue block34;
                }
                case '7': {
                    int ix = RubiniusMachine.getInt(bytecodes, ip);
                    int code = RubiniusMachine.getInt(bytecodes, ip += 4);
                    ip += 4;
                    if (args.length < ix) {
                        throw runtime.newArgumentError("wrong # of arguments(" + args.length + " for " + ix + ")");
                    }
                    if (code <= 0 || args.length <= code) continue block34;
                    throw runtime.newArgumentError("wrong # of arguments(" + args.length + " for " + code + ")");
                }
                case 'G': {
                    stack[++stackTop] = RubyFixnum.zero(runtime);
                    continue block34;
                }
                case 'H': {
                    stack[++stackTop] = RubyFixnum.one(runtime);
                    continue block34;
                }
                case 'I': {
                    stack[++stackTop] = runtime.newFixnum(2L);
                    continue block34;
                }
                case '\u0011': {
                    int ix = RubiniusMachine.getInt(bytecodes, ip);
                    ip += 4;
                    context.getCurrentScope().setValue(ix, stack[stackTop], 0);
                    continue block34;
                }
                case '\u0012': {
                    int ix = RubiniusMachine.getInt(bytecodes, ip);
                    ip += 4;
                    stack[++stackTop] = context.getCurrentScope().getValue(ix, 0);
                    continue block34;
                }
                case '\u0001': {
                    stack[++stackTop] = runtime.getNil();
                    continue block34;
                }
                case '\u0002': {
                    stack[++stackTop] = runtime.getTrue();
                    continue block34;
                }
                case '\u0003': {
                    stack[++stackTop] = runtime.getFalse();
                    continue block34;
                }
                case '\f': {
                    stack[++stackTop] = self;
                    continue block34;
                }
                case ':': {
                    stack[stackTop] = ((RubyString)stack[stackTop]).strDup();
                    continue block34;
                }
                case '\u000b': {
                    int ix = RubiniusMachine.getInt(bytecodes, ip);
                    ip += 4;
                    stack[++stackTop] = literals[ix];
                    continue block34;
                }
                case 'Q': {
                    IRubyObject ix = stack[stackTop--];
                    IRubyObject code = stack[stackTop--];
                    if (ix instanceof RubyFixnum && ix instanceof RubyFixnum) {
                        stack[++stackTop] = ((RubyFixnum)ix).getLongValue() < ((RubyFixnum)code).getLongValue() ? runtime.getTrue() : runtime.getFalse();
                        continue block34;
                    }
                    stack[++stackTop] = ix.callMethod(context, MethodIndex.OP_LT, "<", code);
                    continue block34;
                }
                case 'R': {
                    IRubyObject ix = stack[stackTop--];
                    IRubyObject code = stack[stackTop--];
                    if (ix instanceof RubyFixnum && ix instanceof RubyFixnum) {
                        stack[++stackTop] = ((RubyFixnum)ix).getLongValue() > ((RubyFixnum)ix).getLongValue() ? runtime.getTrue() : runtime.getFalse();
                        continue block34;
                    }
                    stack[++stackTop] = ix.callMethod(context, MethodIndex.OP_GT, ">", code);
                    continue block34;
                }
                case 'N': {
                    IRubyObject ix = stack[stackTop--];
                    IRubyObject code = stack[stackTop--];
                    if (ix instanceof RubyFixnum && code instanceof RubyFixnum) {
                        stack[++stackTop] = ((RubyFixnum)ix).op_plus(code);
                        continue block34;
                    }
                    stack[++stackTop] = ix.callMethod(context, MethodIndex.OP_PLUS, "+", code);
                    continue block34;
                }
                case 'O': {
                    IRubyObject ix = stack[stackTop--];
                    IRubyObject code = stack[stackTop--];
                    if (ix instanceof RubyFixnum && code instanceof RubyFixnum) {
                        stack[++stackTop] = ((RubyFixnum)ix).op_minus(code);
                        continue block34;
                    }
                    stack[++stackTop] = ix.callMethod(context, MethodIndex.OP_MINUS, "-", code);
                    continue block34;
                }
                case '&': {
                    --stackTop;
                    continue block34;
                }
                case '\\': {
                    int ix = RubiniusMachine.getInt(bytecodes, ip);
                    ip += 4;
                    call_flags = ix;
                    continue block34;
                }
                case 'C': {
                    int ix = RubiniusMachine.getInt(bytecodes, ip);
                    ip += 4;
                    cache_index = ix;
                    continue block34;
                }
                case ')': {
                    int ix = RubiniusMachine.getInt(bytecodes, ip);
                    int code = RubiniusMachine.getInt(bytecodes, ip += 4);
                    ip += 4;
                    String index = literals[ix].toString();
                    int num_args = MethodIndex.getIndex(index);
                    IRubyObject iRubyObject = stack[stackTop--];
                    IRubyObject[] name = new IRubyObject[code];
                    for (int ixi = 0; ixi < code; ++ixi) {
                        name[ixi] = stack[stackTop--];
                    }
                    if ((call_flags & 1) == 1) {
                        stack[++stackTop] = RuntimeHelpers.invoke(context, iRubyObject, num_args, index, name, CallType.FUNCTIONAL, Block.NULL_BLOCK);
                        continue block34;
                    }
                    stack[++stackTop] = RuntimeHelpers.invoke(context, iRubyObject, num_args, index, name, CallType.NORMAL, Block.NULL_BLOCK);
                    continue block34;
                }
                case '\u000e': {
                    int ix = RubiniusMachine.getInt(bytecodes, ip);
                    ip += 4;
                    if (stack[stackTop--].isTrue()) continue block34;
                    ip = ix;
                    continue block34;
                }
                case '\u000f': {
                    int ix = RubiniusMachine.getInt(bytecodes, ip);
                    ip += 4;
                    if (!stack[stackTop--].isTrue()) continue block34;
                    ip = ix;
                    continue block34;
                }
                case '\u0010': {
                    IRubyObject ix = stack[stackTop];
                    stack[stackTop] = stack[stackTop - 1];
                    stack[stackTop - 1] = ix;
                    continue block34;
                }
                case '%': {
                    stack[stackTop + 1] = stack[stackTop];
                    ++stackTop;
                    continue block34;
                }
                case '\r': {
                    int ix = RubiniusMachine.getInt(bytecodes, ip);
                    ip += 4;
                    ip = ix;
                    continue block34;
                }
                case '\'': {
                    return stack[stackTop];
                }
                case '\u0007': {
                    int ix = RubiniusMachine.getInt(bytecodes, ip);
                    ip += 4;
                    stack[++stackTop] = runtime.newFixnum(ix);
                    continue block34;
                }
                case '\u0018': {
                    int ix = RubiniusMachine.getInt(bytecodes, ip);
                    ip += 4;
                    String code = literals[ix].toString();
                    stack[++stackTop] = context.getConstant(code);
                    continue block34;
                }
            }
            System.err.println("--COULDN'T");
            if (RubiniusInstructions.ONE_INT[c]) {
                ip += 4;
                continue;
            }
            if (!RubiniusInstructions.TWO_INT[c]) continue;
            ip += 8;
        }
        return null;
    }
}

