/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.JavaFileStat;
import org.jruby.ext.posix.JavaPasswd;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXHandler;
import org.jruby.ext.posix.Passwd;
import org.jruby.ext.posix.util.Chmod;
import org.jruby.ext.posix.util.ExecIt;

public class JavaLibCHelper {
    public static final int STDIN = 0;
    public static final int STDOUT = 1;
    public static final int STDERR = 2;
    POSIXHandler handler;
    Field field;

    public JavaLibCHelper(POSIXHandler handler) {
        this.handler = handler;
        try {
            this.field = FileDescriptor.class.getDeclaredField("fd");
            this.field.setAccessible(true);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public int chmod(String filename, int mode) {
        return Chmod.chmod(new File(filename), Integer.toOctalString(mode));
    }

    public int chown(String filename, int user, int group) {
        ExecIt launcher = new ExecIt(this.handler);
        int chownResult = -1;
        int chgrpResult = -1;
        try {
            if (user != -1) {
                chownResult = launcher.runAndWait("chown", "" + user, filename);
            }
            if (group != -1) {
                chgrpResult = launcher.runAndWait("chgrp ", "" + user, filename);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return chownResult != -1 && chgrpResult != -1 ? 0 : 1;
    }

    public int getfd(FileDescriptor descriptor) {
        if (descriptor == null) {
            return -1;
        }
        try {
            return this.field.getInt(descriptor);
        }
        catch (SecurityException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return -1;
    }

    public String getlogin() {
        return System.getProperty("user.name");
    }

    public int getpid() {
        return this.handler.getPID();
    }

    public Passwd getpwent() {
        return new JavaPasswd(this.handler);
    }

    public int isatty(int fd) {
        return fd == 1 || fd == 0 || fd == 2 ? 1 : 0;
    }

    public int link(String oldpath, String newpath) {
        try {
            return new ExecIt(this.handler).runAndWait("ln", oldpath, newpath);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int lstat(String path, FileStat stat) {
        JavaFileStat jstat = (JavaFileStat)stat;
        jstat.setup(path);
        return 0;
    }

    public int mkdir(String path, int mode) {
        File dir = new File(path);
        if (!dir.mkdir()) {
            return -1;
        }
        this.chmod(path, mode);
        return 0;
    }

    public int stat(String path, FileStat stat) {
        JavaFileStat jstat = (JavaFileStat)stat;
        try {
            File file = new File(path);
            if (!file.exists()) {
                this.handler.error(POSIX.ERRORS.ENOENT, path);
            }
            jstat.setup(file.getCanonicalPath());
        }
        catch (IOException e) {
            // empty catch block
        }
        return 0;
    }

    public int symlink(String oldpath, String newpath) {
        try {
            return new ExecIt(this.handler).runAndWait("ln", "-s", oldpath, newpath);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int readlink(String oldpath, ByteBuffer buffer, int length) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new ExecIt(this.handler).runAndWait(baos, "readlink", oldpath);
            byte[] bytes = baos.toByteArray();
            if (bytes.length > length) {
                return -1;
            }
            buffer.put(bytes, 0, bytes.length - 1);
            return buffer.position();
        }
        catch (Exception e) {
            return -1;
        }
    }
}

