/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.socket.RubyBasicSocket;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ChannelStream;
import org.jruby.util.io.ModeFlags;

public class RubyUNIXSocket
extends RubyBasicSocket {
    protected static LibCSocket INSTANCE = null;
    private static ObjectAllocator UNIXSOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyUNIXSocket(runtime, klass);
        }
    };
    protected int fd;
    protected String fpath;
    protected static final int F_GETFL = 3;
    protected static final int F_SETFL = 4;
    protected static final int O_NONBLOCK = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tryUnixDomainSocket() {
        if (INSTANCE != null) {
            return true;
        }
        try {
            Class<RubyUNIXSocket> clazz = RubyUNIXSocket.class;
            synchronized (RubyUNIXSocket.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return true;
                }
                INSTANCE = (LibCSocket)Native.loadLibrary("c", LibCSocket.class);
                // ** MonitorExit[var0] (shouldn't be in output)
                return true;
            }
        }
        catch (Throwable e) {
            return false;
        }
    }

    static void createUNIXSocket(Ruby runtime) {
        RubyClass rb_cUNIXSocket = runtime.defineClass("UNIXSocket", runtime.fastGetClass("BasicSocket"), UNIXSOCKET_ALLOCATOR);
        runtime.getObject().fastSetConstant("UNIXsocket", rb_cUNIXSocket);
        CallbackFactory cfact = runtime.callbackFactory(RubyUNIXSocket.class);
        rb_cUNIXSocket.defineFastMethod("initialize", cfact.getFastMethod("initialize", IRubyObject.class));
        rb_cUNIXSocket.defineFastMethod("path", cfact.getFastMethod("path"));
        rb_cUNIXSocket.defineFastMethod("addr", cfact.getFastMethod("addr"));
        rb_cUNIXSocket.defineFastMethod("peeraddr", cfact.getFastMethod("peeraddr"));
        rb_cUNIXSocket.defineFastMethod("recvfrom", cfact.getFastOptMethod("recvfrom"));
        rb_cUNIXSocket.defineFastMethod("send_io", cfact.getFastMethod("send_io", IRubyObject.class));
        rb_cUNIXSocket.defineFastMethod("recv_io", cfact.getFastOptMethod("recv_io"));
        rb_cUNIXSocket.getMetaClass().defineFastMethod("socketpair", cfact.getFastOptSingletonMethod("socketpair"));
        rb_cUNIXSocket.getMetaClass().defineFastMethod("pair", cfact.getFastOptSingletonMethod("socketpair"));
        rb_cUNIXSocket.getMetaClass().defineFastMethod("open", cfact.getFastSingletonMethod("open", IRubyObject.class));
    }

    public RubyUNIXSocket(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    protected void rb_sys_fail(String message) {
        RubyUNIXSocket.rb_sys_fail(this.getRuntime(), message);
    }

    protected static void rb_sys_fail(Ruby runtime, String message) {
        int n = Native.getLastError();
        Native.setLastError(0);
        IRubyObject arg = message != null ? runtime.newString(message) : runtime.getNil();
        RubyClass instance = runtime.getErrno(n);
        if (instance == null) {
            instance = runtime.fastGetClass("SystemCallError");
            throw new RaiseException((RubyException)instance.newInstance(new IRubyObject[]{arg, runtime.newFixnum(n)}, Block.NULL_BLOCK));
        }
        throw new RaiseException((RubyException)instance.newInstance(new IRubyObject[]{arg}, Block.NULL_BLOCK));
    }

    /*
     * WARNING - void declaration
     */
    protected void init_unixsock(IRubyObject _path, boolean server) throws Exception {
        int path;
        this.fd = INSTANCE.socket(1, 1, 0);
        if (this.fd < 0) {
            this.rb_sys_fail("socket(2)");
        }
        LibCSocket.sockaddr_un sockaddr_un2 = new LibCSocket.sockaddr_un();
        sockaddr_un2.sun_family = 1;
        ByteList sockaddr = _path.convertToString().getByteList();
        this.fpath = sockaddr.toString();
        if (sockaddr_un2.sun_path.length <= sockaddr.realSize) {
            throw this.getRuntime().newArgumentError("too long unix socket path (max: " + (sockaddr_un2.sun_path.length - 1) + "bytes)");
        }
        System.arraycopy(sockaddr.bytes, sockaddr.begin, sockaddr_un2.sun_path, 0, sockaddr.realSize);
        if (server) {
            path = INSTANCE.bind(this.fd, sockaddr_un2, 106);
        } else {
            try {
                void status;
                path = INSTANCE.connect(this.fd, (LibCSocket.sockaddr_un)status, 106);
            }
            catch (RuntimeException e) {
                INSTANCE.close(this.fd);
                throw e;
            }
        }
        if (path < 0) {
            INSTANCE.close(this.fd);
            this.rb_sys_fail(this.fpath);
        }
        if (server) {
            INSTANCE.listen(this.fd, 5);
        }
        this.init_sock();
        if (server) {
            this.openFile.setPath(this.fpath);
        }
    }

    public IRubyObject setsockopt(IRubyObject lev, IRubyObject optname, IRubyObject val) {
        int level = RubyNumeric.fix2int(lev);
        int opt = RubyNumeric.fix2int(optname);
        block0 : switch (level) {
            case 65535: {
                switch (opt) {
                    case 8: {
                        byte[] byArray;
                        if (this.asBoolean(val)) {
                            byte[] byArray2 = new byte[4];
                            byArray2[0] = 32;
                            byArray2[1] = 0;
                            byArray2[2] = 0;
                            byArray = byArray2;
                            byArray2[3] = 0;
                        } else {
                            byte[] byArray3 = new byte[4];
                            byArray3[0] = 0;
                            byArray3[1] = 0;
                            byArray3[2] = 0;
                            byArray = byArray3;
                            byArray3[3] = 0;
                        }
                        int res = INSTANCE.setsockopt(this.fd, level, opt, byArray, 4);
                        if (res != -1) break block0;
                        this.rb_sys_fail(this.openFile.getPath());
                        break block0;
                    }
                    default: {
                        throw this.getRuntime().newErrnoENOPROTOOPTError();
                    }
                }
            }
            default: {
                throw this.getRuntime().newErrnoENOPROTOOPTError();
            }
        }
        return this.getRuntime().newFixnum(0L);
    }

    protected void init_sock() throws Exception {
        ModeFlags modes = new ModeFlags(2L);
        this.openFile.setMainStream(new ChannelStream(this.getRuntime(), new ChannelDescriptor(new UnixDomainSocketChannel(this.fd), RubyUNIXSocket.getNewFileno(), modes, new FileDescriptor())));
        this.openFile.setPipeStream(this.openFile.getMainStream());
        this.openFile.setMode(modes.getOpenFileFlags());
        this.openFile.getMainStream().setSync(true);
    }

    public IRubyObject initialize(IRubyObject path) throws Exception {
        this.init_unixsock(path, false);
        return this;
    }

    private String unixpath(LibCSocket.sockaddr_un addr, IntByReference len) throws Exception {
        int firstZero = 0;
        for (int i = 0; i < addr.sun_path.length; ++i) {
            if (addr.sun_path[i] != 0) continue;
            firstZero = i;
            break;
        }
        if (len.getValue() > 0) {
            return new String(addr.sun_path, 0, firstZero, "ISO8859-1");
        }
        return "";
    }

    private IRubyObject unixaddr(LibCSocket.sockaddr_un addr, IntByReference len) throws Exception {
        return this.getRuntime().newArrayNoCopy(new IRubyObject[]{this.getRuntime().newString("AF_UNIX"), this.getRuntime().newString(this.unixpath(addr, len))});
    }

    public IRubyObject path() throws Exception {
        if (this.openFile.getPath() == null) {
            LibCSocket.sockaddr_un addr = new LibCSocket.sockaddr_un();
            IntByReference len = new IntByReference(106);
            if (INSTANCE.getsockname(this.fd, addr, len) < 0) {
                this.rb_sys_fail(null);
            }
            this.openFile.setPath(this.unixpath(addr, len));
        }
        return this.getRuntime().newString(this.openFile.getPath());
    }

    public IRubyObject addr() throws Exception {
        LibCSocket.sockaddr_un addr = new LibCSocket.sockaddr_un();
        IntByReference len = new IntByReference(106);
        if (INSTANCE.getsockname(this.fd, addr, len) < 0) {
            this.rb_sys_fail("getsockname(2)");
        }
        return this.unixaddr(addr, len);
    }

    public IRubyObject peeraddr() throws Exception {
        LibCSocket.sockaddr_un addr = new LibCSocket.sockaddr_un();
        IntByReference len = new IntByReference(106);
        if (INSTANCE.getpeername(this.fd, addr, len) < 0) {
            this.rb_sys_fail("getpeername(2)");
        }
        return this.unixaddr(addr, len);
    }

    /*
     * WARNING - void declaration
     */
    public IRubyObject recvfrom(IRubyObject[] args) throws Exception {
        void len;
        ByteBuffer str = ByteBuffer.allocateDirect(1024);
        LibCSocket.sockaddr_un buf = new LibCSocket.sockaddr_un();
        IntByReference alen = new IntByReference(106);
        IRubyObject iRubyObject = Arity.checkArgumentCount(this.getRuntime(), args, 1, 2) == 2 ? args[1] : this.getRuntime().getNil();
        IRubyObject flg = args[0];
        int flags = len.isNil() ? 0 : RubyNumeric.fix2int((IRubyObject)len);
        int buflen = RubyNumeric.fix2int(flg);
        int slen = INSTANCE.recvfrom(this.fd, str, buflen, flags, buf, alen);
        if (slen < 0) {
            this.rb_sys_fail("recvfrom(2)");
        }
        if (slen < buflen) {
            buflen = slen;
        }
        byte[] outp = new byte[buflen];
        str.get(outp);
        RubyString _str = this.getRuntime().newString(new ByteList(outp, 0, buflen, false));
        return this.getRuntime().newArrayNoCopy(new IRubyObject[]{_str, this.unixaddr(buf, alen)});
    }

    public IRubyObject send_io(IRubyObject path) {
        return this.getRuntime().getNil();
    }

    public IRubyObject recv_io(IRubyObject[] args) {
        return this.getRuntime().getNil();
    }

    public IRubyObject close() {
        super.close();
        INSTANCE.close(this.fd);
        return this.getRuntime().getNil();
    }

    public static IRubyObject open(IRubyObject recv, IRubyObject path) {
        return recv.callMethod(recv.getRuntime().getCurrentContext(), "new", new IRubyObject[]{path}, Block.NULL_BLOCK);
    }

    private static int getSocketType(IRubyObject tp) {
        if (tp instanceof RubyString) {
            String str = tp.toString();
            if ("SOCK_STREAM".equals(str)) {
                return 1;
            }
            if ("SOCK_DGRAM".equals(str)) {
                return 2;
            }
            if ("SOCK_RAW".equals(str)) {
                return 3;
            }
            return -1;
        }
        return RubyNumeric.fix2int(tp);
    }

    public static IRubyObject socketpair(IRubyObject recv, IRubyObject[] args) throws Exception {
        int domain = 1;
        Arity.checkArgumentCount(recv.getRuntime(), args, 0, 2);
        int type = args.length == 0 ? 1 : RubyUNIXSocket.getSocketType(args[0]);
        int protocol = args.length <= 1 ? 0 : RubyNumeric.fix2int(args[1]);
        int[] sp = new int[2];
        int ret = INSTANCE.socketpair(domain, type, protocol, sp);
        if (ret < 0) {
            RubyUNIXSocket.rb_sys_fail(recv.getRuntime(), "socketpair(2");
        }
        RubyUNIXSocket sock = (RubyUNIXSocket)recv.getRuntime().fastGetClass("UNIXSocket").callMethod(recv.getRuntime().getCurrentContext(), "allocate", new IRubyObject[0]);
        sock.fd = sp[0];
        sock.init_sock();
        RubyUNIXSocket sock2 = (RubyUNIXSocket)recv.getRuntime().fastGetClass("UNIXSocket").callMethod(recv.getRuntime().getCurrentContext(), "allocate", new IRubyObject[0]);
        sock2.fd = sp[1];
        sock2.init_sock();
        return recv.getRuntime().newArrayNoCopy(new IRubyObject[]{sock, sock2});
    }

    public static interface LibCSocket
    extends Library {
        public int socketpair(int var1, int var2, int var3, int[] var4);

        public int socket(int var1, int var2, int var3);

        public int connect(int var1, sockaddr_un var2, int var3);

        public int bind(int var1, sockaddr_un var2, int var3);

        public int listen(int var1, int var2);

        public int accept(int var1, sockaddr_un var2, IntByReference var3);

        public int getsockname(int var1, sockaddr_un var2, IntByReference var3);

        public int getpeername(int var1, sockaddr_un var2, IntByReference var3);

        public int getsockopt(int var1, int var2, int var3, byte[] var4, IntByReference var5);

        public int setsockopt(int var1, int var2, int var3, byte[] var4, int var5);

        public int recv(int var1, Buffer var2, int var3, int var4);

        public int recvfrom(int var1, Buffer var2, int var3, int var4, sockaddr_un var5, IntByReference var6);

        public int send(int var1, Buffer var2, int var3, int var4);

        public int fcntl(int var1, int var2, int var3);

        public int unlink(String var1);

        public int close(int var1);

        public void perror(String var1);

        public static class sockaddr_un
        extends Structure {
            public static final int LENGTH = 106;
            public byte sun_len;
            public byte sun_family;
            public byte[] sun_path = new byte[104];
        }
    }

    private static class UnixDomainSocketChannel
    implements ReadableByteChannel,
    WritableByteChannel {
        private final int fd;
        private boolean open = true;

        public UnixDomainSocketChannel(int fd) {
            this.fd = fd;
        }

        public void close() throws IOException {
            this.open = false;
        }

        public boolean isOpen() {
            return this.open;
        }

        public int read(ByteBuffer dst) throws IOException {
            int max = dst.remaining();
            int v = INSTANCE.recv(this.fd, dst, max, 0);
            if (v != -1) {
                dst.position(dst.position() + v);
            }
            return v;
        }

        public int write(ByteBuffer src) throws IOException {
            int max = src.remaining();
            int v = INSTANCE.send(this.fd, src, max, 0);
            if (v != -1) {
                src.position(src.position() + v);
            }
            return v;
        }
    }
}

