/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jruby.RubyThread;
import org.jruby.internal.runtime.RubyRunnable;
import org.jruby.internal.runtime.ThreadLike;

public class FutureThread
implements ThreadLike {
    private Future future;
    private RubyRunnable runnable;
    public RubyThread rubyThread;
    private static ExecutorService executor = Executors.newCachedThreadPool(new DaemonThreadFactory());

    public FutureThread(RubyThread rubyThread, RubyRunnable runnable) {
        this.rubyThread = rubyThread;
        this.runnable = runnable;
    }

    public void start() {
        this.future = executor.submit(this.runnable);
    }

    public void interrupt() {
        if (this.runnable.getJavaThread() != null) {
            this.runnable.getJavaThread().interrupt();
        }
    }

    public boolean isAlive() {
        return this.future != null && !this.future.isDone();
    }

    public void join() throws InterruptedException, ExecutionException {
        try {
            this.future.get();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public void join(long millis) throws InterruptedException, ExecutionException, TimeoutException {
        if (millis == 0L) {
            this.join();
        } else {
            try {
                this.future.get(millis, TimeUnit.MILLISECONDS);
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
        }
    }

    public int getPriority() {
        return 1;
    }

    public void setPriority(int priority) {
    }

    public boolean isCurrent() {
        return this.rubyThread == this.rubyThread.getRuntime().getCurrentContext().getThread();
    }

    public boolean isInterrupted() {
        return this.future.isCancelled();
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    }
}

