/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.test.framework.spi.container.http;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.container.ContainerFactory;
import com.sun.jersey.api.container.httpserver.HttpServerFactory;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.LowLevelAppDescriptor;
import com.sun.jersey.test.framework.spi.container.TestContainer;
import com.sun.jersey.test.framework.spi.container.TestContainerException;
import com.sun.jersey.test.framework.spi.container.TestContainerFactory;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.net.URI;
import java.util.logging.Logger;
import javax.ws.rs.core.UriBuilder;

public class HTTPContainerFactory
implements TestContainerFactory {
    public Class<LowLevelAppDescriptor> supports() {
        return LowLevelAppDescriptor.class;
    }

    public TestContainer create(URI baseUri, AppDescriptor ad) {
        if (!(ad instanceof LowLevelAppDescriptor)) {
            throw new IllegalArgumentException("The application descriptor must be an instance of LowLevelAppDescriptor");
        }
        return new HTTPTestContainer(baseUri, (LowLevelAppDescriptor)ad);
    }

    private static class HTTPTestContainer
    implements TestContainer {
        private static final Logger LOGGER = Logger.getLogger(HTTPTestContainer.class.getName());
        final URI baseUri;
        final ResourceConfig resourceConfig;
        final HttpHandler httpHandler;
        final HttpServer httpServer;

        HTTPTestContainer(URI baseUri, LowLevelAppDescriptor ad) {
            this.baseUri = UriBuilder.fromUri((URI)baseUri).path(ad.getContextPath()).build(new Object[0]);
            LOGGER.info("Creating low level http container configured at the base URI " + this.baseUri);
            this.resourceConfig = ad.getResourceConfig();
            this.httpHandler = (HttpHandler)ContainerFactory.createContainer(HttpHandler.class, (ResourceConfig)this.resourceConfig);
            try {
                this.httpServer = HttpServerFactory.create((URI)this.baseUri, (HttpHandler)this.httpHandler);
            }
            catch (Exception ex) {
                throw new TestContainerException((Throwable)ex);
            }
        }

        public Client getClient() {
            return null;
        }

        public URI getBaseUri() {
            return this.baseUri;
        }

        public void start() {
            LOGGER.info("Starting low level HTTPServer container");
            this.httpServer.start();
        }

        public void stop() {
            LOGGER.info("Stopping low level HTTPServer container");
            this.httpServer.stop(0);
        }
    }
}

