/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.autotable.springboot;

import com.tangzc.autotable.core.AutoTableAnnotationFinder;
import com.tangzc.autotable.core.AutoTableBootstrap;
import com.tangzc.autotable.core.AutoTableGlobalConfig;
import com.tangzc.autotable.core.AutoTableOrmFrameAdapter;
import com.tangzc.autotable.core.callback.CreateTableFinishCallback;
import com.tangzc.autotable.core.callback.ModifyTableFinishCallback;
import com.tangzc.autotable.core.callback.RunStateCallback;
import com.tangzc.autotable.core.callback.ValidateFinishCallback;
import com.tangzc.autotable.core.converter.JavaTypeToDatabaseTypeConverter;
import com.tangzc.autotable.core.dynamicds.IDataSourceHandler;
import com.tangzc.autotable.core.dynamicds.SqlSessionFactoryManager;
import com.tangzc.autotable.core.interceptor.AutoTableAnnotationInterceptor;
import com.tangzc.autotable.core.interceptor.BuildTableMetadataInterceptor;
import com.tangzc.autotable.core.interceptor.CreateTableInterceptor;
import com.tangzc.autotable.core.interceptor.ModifyTableInterceptor;
import com.tangzc.autotable.core.strategy.CompareTableInfo;
import com.tangzc.autotable.core.strategy.IStrategy;
import com.tangzc.autotable.core.strategy.TableMetadata;
import com.tangzc.autotable.springboot.CustomAnnotationFinder;
import com.tangzc.autotable.springboot.properties.AutoTableProperties;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;

@Configuration
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, MybatisAutoConfiguration.class})
public class AutoTableAutoConfig {
    public AutoTableAutoConfig(SqlSessionTemplate sqlSessionTemplate, AutoTableProperties autoTableProperties, ObjectProvider<IStrategy<? extends TableMetadata, ? extends CompareTableInfo, ?>> strategies, ObjectProvider<AutoTableAnnotationFinder> autoTableAnnotationFinder, ObjectProvider<AutoTableOrmFrameAdapter> autoTableOrmFrameAdapter, ObjectProvider<IDataSourceHandler<?>> dynamicDataSourceHandler, ObjectProvider<AutoTableAnnotationInterceptor> autoTableAnnotationInterceptor, ObjectProvider<BuildTableMetadataInterceptor> buildTableMetadataInterceptor, ObjectProvider<CreateTableInterceptor> createTableInterceptor, ObjectProvider<ModifyTableInterceptor> modifyTableInterceptor, ObjectProvider<CreateTableFinishCallback> createTableFinishCallback, ObjectProvider<ModifyTableFinishCallback> modifyTableFinishCallback, ObjectProvider<RunStateCallback> runStateCallback, ObjectProvider<ValidateFinishCallback> validateFinishCallback, ObjectProvider<JavaTypeToDatabaseTypeConverter> javaTypeToDatabaseTypeConverter) {
        SqlSessionFactoryManager.setSqlSessionFactory((SqlSessionFactory)sqlSessionTemplate.getSqlSessionFactory());
        AutoTableGlobalConfig.setAutoTableProperties((AutoTableGlobalConfig.PropertyConfig)autoTableProperties.toConfig());
        AutoTableGlobalConfig.setAutoTableAnnotationFinder((AutoTableAnnotationFinder)((AutoTableAnnotationFinder)autoTableAnnotationFinder.getIfAvailable(CustomAnnotationFinder::new)));
        strategies.stream().forEach(AutoTableGlobalConfig::addStrategy);
        autoTableOrmFrameAdapter.ifAvailable(AutoTableGlobalConfig::setAutoTableOrmFrameAdapter);
        dynamicDataSourceHandler.ifAvailable(AutoTableGlobalConfig::setDatasourceHandler);
        autoTableAnnotationInterceptor.ifAvailable(AutoTableGlobalConfig::setAutoTableAnnotationInterceptor);
        buildTableMetadataInterceptor.ifAvailable(AutoTableGlobalConfig::setBuildTableMetadataInterceptor);
        createTableInterceptor.ifAvailable(AutoTableGlobalConfig::setCreateTableInterceptor);
        modifyTableInterceptor.ifAvailable(AutoTableGlobalConfig::setModifyTableInterceptor);
        createTableFinishCallback.ifAvailable(AutoTableGlobalConfig::setCreateTableFinishCallback);
        modifyTableFinishCallback.ifAvailable(AutoTableGlobalConfig::setModifyTableFinishCallback);
        runStateCallback.ifAvailable(AutoTableGlobalConfig::setRunStateCallback);
        validateFinishCallback.ifAvailable(AutoTableGlobalConfig::setValidateFinishCallback);
        javaTypeToDatabaseTypeConverter.ifAvailable(AutoTableGlobalConfig::setJavaTypeToDatabaseTypeConverter);
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void run() {
        AutoTableBootstrap.start();
    }
}

