/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.autotable.springboot.properties;

import com.tangzc.autotable.core.AutoTableGlobalConfig;
import com.tangzc.autotable.core.RunMode;
import java.util.Arrays;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="auto-table")
public class AutoTableProperties {
    public static final String ENABLE_KEY = "auto-table.enable";
    private Boolean showBanner = true;
    private Boolean enable = true;
    private RunMode mode = RunMode.update;
    private String[] modelPackage;
    private String indexPrefix = "auto_idx_";
    private Boolean autoDropColumn = false;
    private Boolean autoDropIndex = true;
    private SuperInsertPosition superInsertPosition = SuperInsertPosition.after;
    private Mysql mysql = new Mysql();

    public AutoTableGlobalConfig.PropertyConfig toConfig() {
        AutoTableGlobalConfig.PropertyConfig propertyConfig = new AutoTableGlobalConfig.PropertyConfig();
        propertyConfig.setShowBanner(this.showBanner);
        propertyConfig.setEnable(this.enable);
        propertyConfig.setMode(this.mode);
        propertyConfig.setModelPackage(this.modelPackage);
        propertyConfig.setIndexPrefix(this.indexPrefix);
        propertyConfig.setAutoDropColumn(this.autoDropColumn);
        propertyConfig.setAutoDropIndex(this.autoDropIndex);
        AutoTableGlobalConfig.SuperInsertPosition superInsertPosition = AutoTableGlobalConfig.SuperInsertPosition.valueOf((String)this.superInsertPosition.name());
        propertyConfig.setSuperInsertPosition(superInsertPosition);
        AutoTableGlobalConfig.MysqlConfig mysqlConfig = new AutoTableGlobalConfig.MysqlConfig();
        mysqlConfig.setTableDefaultCharset(this.mysql.getTableDefaultCharset());
        mysqlConfig.setTableDefaultCharset(this.mysql.getTableDefaultCharset());
        mysqlConfig.setTableDefaultCharset(this.mysql.getTableDefaultCharset());
        mysqlConfig.setTableDefaultCharset(this.mysql.getTableDefaultCharset());
        propertyConfig.setMysql(mysqlConfig);
        return propertyConfig;
    }

    public Boolean getShowBanner() {
        return this.showBanner;
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public RunMode getMode() {
        return this.mode;
    }

    public String[] getModelPackage() {
        return this.modelPackage;
    }

    public String getIndexPrefix() {
        return this.indexPrefix;
    }

    public Boolean getAutoDropColumn() {
        return this.autoDropColumn;
    }

    public Boolean getAutoDropIndex() {
        return this.autoDropIndex;
    }

    public SuperInsertPosition getSuperInsertPosition() {
        return this.superInsertPosition;
    }

    public Mysql getMysql() {
        return this.mysql;
    }

    public void setShowBanner(Boolean showBanner) {
        this.showBanner = showBanner;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public void setMode(RunMode mode) {
        this.mode = mode;
    }

    public void setModelPackage(String[] modelPackage) {
        this.modelPackage = modelPackage;
    }

    public void setIndexPrefix(String indexPrefix) {
        this.indexPrefix = indexPrefix;
    }

    public void setAutoDropColumn(Boolean autoDropColumn) {
        this.autoDropColumn = autoDropColumn;
    }

    public void setAutoDropIndex(Boolean autoDropIndex) {
        this.autoDropIndex = autoDropIndex;
    }

    public void setSuperInsertPosition(SuperInsertPosition superInsertPosition) {
        this.superInsertPosition = superInsertPosition;
    }

    public void setMysql(Mysql mysql) {
        this.mysql = mysql;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoTableProperties)) {
            return false;
        }
        AutoTableProperties other = (AutoTableProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$showBanner = this.getShowBanner();
        Boolean other$showBanner = other.getShowBanner();
        if (this$showBanner == null ? other$showBanner != null : !((Object)this$showBanner).equals(other$showBanner)) {
            return false;
        }
        Boolean this$enable = this.getEnable();
        Boolean other$enable = other.getEnable();
        if (this$enable == null ? other$enable != null : !((Object)this$enable).equals(other$enable)) {
            return false;
        }
        Boolean this$autoDropColumn = this.getAutoDropColumn();
        Boolean other$autoDropColumn = other.getAutoDropColumn();
        if (this$autoDropColumn == null ? other$autoDropColumn != null : !((Object)this$autoDropColumn).equals(other$autoDropColumn)) {
            return false;
        }
        Boolean this$autoDropIndex = this.getAutoDropIndex();
        Boolean other$autoDropIndex = other.getAutoDropIndex();
        if (this$autoDropIndex == null ? other$autoDropIndex != null : !((Object)this$autoDropIndex).equals(other$autoDropIndex)) {
            return false;
        }
        RunMode this$mode = this.getMode();
        RunMode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getModelPackage(), other.getModelPackage())) {
            return false;
        }
        String this$indexPrefix = this.getIndexPrefix();
        String other$indexPrefix = other.getIndexPrefix();
        if (this$indexPrefix == null ? other$indexPrefix != null : !this$indexPrefix.equals(other$indexPrefix)) {
            return false;
        }
        SuperInsertPosition this$superInsertPosition = this.getSuperInsertPosition();
        SuperInsertPosition other$superInsertPosition = other.getSuperInsertPosition();
        if (this$superInsertPosition == null ? other$superInsertPosition != null : !((Object)((Object)this$superInsertPosition)).equals((Object)other$superInsertPosition)) {
            return false;
        }
        Mysql this$mysql = this.getMysql();
        Mysql other$mysql = other.getMysql();
        return !(this$mysql == null ? other$mysql != null : !((Object)this$mysql).equals(other$mysql));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AutoTableProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $showBanner = this.getShowBanner();
        result = result * 59 + ($showBanner == null ? 43 : ((Object)$showBanner).hashCode());
        Boolean $enable = this.getEnable();
        result = result * 59 + ($enable == null ? 43 : ((Object)$enable).hashCode());
        Boolean $autoDropColumn = this.getAutoDropColumn();
        result = result * 59 + ($autoDropColumn == null ? 43 : ((Object)$autoDropColumn).hashCode());
        Boolean $autoDropIndex = this.getAutoDropIndex();
        result = result * 59 + ($autoDropIndex == null ? 43 : ((Object)$autoDropIndex).hashCode());
        RunMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getModelPackage());
        String $indexPrefix = this.getIndexPrefix();
        result = result * 59 + ($indexPrefix == null ? 43 : $indexPrefix.hashCode());
        SuperInsertPosition $superInsertPosition = this.getSuperInsertPosition();
        result = result * 59 + ($superInsertPosition == null ? 43 : ((Object)((Object)$superInsertPosition)).hashCode());
        Mysql $mysql = this.getMysql();
        result = result * 59 + ($mysql == null ? 43 : ((Object)$mysql).hashCode());
        return result;
    }

    public String toString() {
        return "AutoTableProperties(showBanner=" + this.getShowBanner() + ", enable=" + this.getEnable() + ", mode=" + this.getMode() + ", modelPackage=" + Arrays.deepToString(this.getModelPackage()) + ", indexPrefix=" + this.getIndexPrefix() + ", autoDropColumn=" + this.getAutoDropColumn() + ", autoDropIndex=" + this.getAutoDropIndex() + ", superInsertPosition=" + (Object)((Object)this.getSuperInsertPosition()) + ", mysql=" + this.getMysql() + ")";
    }

    public static class Mysql {
        private String tableDefaultCharset;
        private String tableDefaultCollation;
        private String columnDefaultCharset;
        private String columnDefaultCollation;

        public String getTableDefaultCharset() {
            return this.tableDefaultCharset;
        }

        public String getTableDefaultCollation() {
            return this.tableDefaultCollation;
        }

        public String getColumnDefaultCharset() {
            return this.columnDefaultCharset;
        }

        public String getColumnDefaultCollation() {
            return this.columnDefaultCollation;
        }

        public void setTableDefaultCharset(String tableDefaultCharset) {
            this.tableDefaultCharset = tableDefaultCharset;
        }

        public void setTableDefaultCollation(String tableDefaultCollation) {
            this.tableDefaultCollation = tableDefaultCollation;
        }

        public void setColumnDefaultCharset(String columnDefaultCharset) {
            this.columnDefaultCharset = columnDefaultCharset;
        }

        public void setColumnDefaultCollation(String columnDefaultCollation) {
            this.columnDefaultCollation = columnDefaultCollation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Mysql)) {
                return false;
            }
            Mysql other = (Mysql)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$tableDefaultCharset = this.getTableDefaultCharset();
            String other$tableDefaultCharset = other.getTableDefaultCharset();
            if (this$tableDefaultCharset == null ? other$tableDefaultCharset != null : !this$tableDefaultCharset.equals(other$tableDefaultCharset)) {
                return false;
            }
            String this$tableDefaultCollation = this.getTableDefaultCollation();
            String other$tableDefaultCollation = other.getTableDefaultCollation();
            if (this$tableDefaultCollation == null ? other$tableDefaultCollation != null : !this$tableDefaultCollation.equals(other$tableDefaultCollation)) {
                return false;
            }
            String this$columnDefaultCharset = this.getColumnDefaultCharset();
            String other$columnDefaultCharset = other.getColumnDefaultCharset();
            if (this$columnDefaultCharset == null ? other$columnDefaultCharset != null : !this$columnDefaultCharset.equals(other$columnDefaultCharset)) {
                return false;
            }
            String this$columnDefaultCollation = this.getColumnDefaultCollation();
            String other$columnDefaultCollation = other.getColumnDefaultCollation();
            return !(this$columnDefaultCollation == null ? other$columnDefaultCollation != null : !this$columnDefaultCollation.equals(other$columnDefaultCollation));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Mysql;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $tableDefaultCharset = this.getTableDefaultCharset();
            result = result * 59 + ($tableDefaultCharset == null ? 43 : $tableDefaultCharset.hashCode());
            String $tableDefaultCollation = this.getTableDefaultCollation();
            result = result * 59 + ($tableDefaultCollation == null ? 43 : $tableDefaultCollation.hashCode());
            String $columnDefaultCharset = this.getColumnDefaultCharset();
            result = result * 59 + ($columnDefaultCharset == null ? 43 : $columnDefaultCharset.hashCode());
            String $columnDefaultCollation = this.getColumnDefaultCollation();
            result = result * 59 + ($columnDefaultCollation == null ? 43 : $columnDefaultCollation.hashCode());
            return result;
        }

        public String toString() {
            return "AutoTableProperties.Mysql(tableDefaultCharset=" + this.getTableDefaultCharset() + ", tableDefaultCollation=" + this.getTableDefaultCollation() + ", columnDefaultCharset=" + this.getColumnDefaultCharset() + ", columnDefaultCollation=" + this.getColumnDefaultCollation() + ")";
        }
    }

    public static enum SuperInsertPosition {
        after,
        before;

    }
}

