/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.actable.command;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.extension.handlers.AbstractJsonTypeHandler;
import com.tangzc.mpe.actable.annotation.constants.MySqlTypeConstant;
import com.tangzc.mpe.base.base.BaseEntity;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class JavaToMysqlType {
    private static final Map<String, MySqlTypeConstant> JAVA_TO_MYSQL_TYPE_MAP = new HashMap<String, MySqlTypeConstant>();

    public static MySqlTypeConstant getSqlType(Field field, Class<?> clazz) {
        Class fieldType = field.getType();
        if (BaseEntity.class.isAssignableFrom(clazz)) {
            String typeName;
            switch (typeName = field.getGenericType().getTypeName()) {
                case "ID_TYPE": {
                    fieldType = ReflectionKit.getSuperClassGenericType(clazz, BaseEntity.class, (int)0);
                    break;
                }
                case "TIME_TYPE": {
                    fieldType = ReflectionKit.getSuperClassGenericType(clazz, BaseEntity.class, (int)1);
                    break;
                }
            }
        }
        if (fieldType.isEnum()) {
            return MySqlTypeConstant.VARCHAR;
        }
        TableField tableField = (TableField)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, TableField.class);
        if (tableField != null && AbstractJsonTypeHandler.class.isAssignableFrom(tableField.typeHandler())) {
            return MySqlTypeConstant.VARCHAR;
        }
        return JAVA_TO_MYSQL_TYPE_MAP.get(fieldType.toString());
    }

    static {
        JAVA_TO_MYSQL_TYPE_MAP.put("class java.lang.String", MySqlTypeConstant.VARCHAR);
        JAVA_TO_MYSQL_TYPE_MAP.put("class java.lang.Long", MySqlTypeConstant.BIGINT);
        JAVA_TO_MYSQL_TYPE_MAP.put("class java.lang.Integer", MySqlTypeConstant.INT);
        JAVA_TO_MYSQL_TYPE_MAP.put("class java.lang.Boolean", MySqlTypeConstant.BIT);
        JAVA_TO_MYSQL_TYPE_MAP.put("class java.math.BigInteger", MySqlTypeConstant.BIGINT);
        JAVA_TO_MYSQL_TYPE_MAP.put("class java.lang.Float", MySqlTypeConstant.FLOAT);
        JAVA_TO_MYSQL_TYPE_MAP.put("class java.lang.Double", MySqlTypeConstant.DOUBLE);
        JAVA_TO_MYSQL_TYPE_MAP.put("class java.lang.Short", MySqlTypeConstant.SMALLINT);
        JAVA_TO_MYSQL_TYPE_MAP.put("class java.math.BigDecimal", MySqlTypeConstant.DECIMAL);
        JAVA_TO_MYSQL_TYPE_MAP.put("class java.sql.Date", MySqlTypeConstant.DATE);
        JAVA_TO_MYSQL_TYPE_MAP.put("class java.util.Date", MySqlTypeConstant.DATE);
        JAVA_TO_MYSQL_TYPE_MAP.put("class java.sql.Timestamp", MySqlTypeConstant.DATETIME);
        JAVA_TO_MYSQL_TYPE_MAP.put("class java.sql.Time", MySqlTypeConstant.TIME);
        JAVA_TO_MYSQL_TYPE_MAP.put("class java.time.LocalDateTime", MySqlTypeConstant.DATETIME);
        JAVA_TO_MYSQL_TYPE_MAP.put("class java.time.LocalDate", MySqlTypeConstant.DATE);
        JAVA_TO_MYSQL_TYPE_MAP.put("class java.time.LocalTime", MySqlTypeConstant.TIME);
        JAVA_TO_MYSQL_TYPE_MAP.put("long", MySqlTypeConstant.BIGINT);
        JAVA_TO_MYSQL_TYPE_MAP.put("int", MySqlTypeConstant.INT);
        JAVA_TO_MYSQL_TYPE_MAP.put("boolean", MySqlTypeConstant.BIT);
        JAVA_TO_MYSQL_TYPE_MAP.put("float", MySqlTypeConstant.FLOAT);
        JAVA_TO_MYSQL_TYPE_MAP.put("double", MySqlTypeConstant.DOUBLE);
        JAVA_TO_MYSQL_TYPE_MAP.put("short", MySqlTypeConstant.SMALLINT);
        JAVA_TO_MYSQL_TYPE_MAP.put("char", MySqlTypeConstant.VARCHAR);
    }
}

