/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.actable.manager.handler;

import com.tangzc.mpe.actable.annotation.DsName;
import com.tangzc.mpe.actable.annotation.Table;
import com.tangzc.mpe.actable.annotation.TablePrimary;
import com.tangzc.mpe.actable.manager.handler.TableInitHandler;
import com.tangzc.mpe.actable.utils.ClassScanner;
import com.tangzc.mpe.actable.utils.ClassTools;
import com.tangzc.mpe.actable.utils.ColumnUtils;
import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.StringUtils;

public class StartUpHandler {
    private static final Logger log = LoggerFactory.getLogger(StartUpHandler.class);
    public static final String MYSQL = "mysql";
    @Value(value="${actable.database.type:mysql}")
    private String databaseType;
    @Value(value="${actable.table.auto:update}")
    private String tableAuto;
    @Value(value="${actable.model.pack:}")
    private String pack;
    @Resource
    private TableInitHandler tableInitHandler;

    @PostConstruct
    public void startHandler() {
        if (this.checkRunEnd()) {
            return;
        }
        if (StringUtils.isEmpty((Object)this.pack)) {
            this.pack = ClassTools.getBootPackage();
        }
        String[] packs = this.pack.split(",|;");
        Set<Class<?>> classes = ClassScanner.scan(packs, Table.class);
        Map<String, Set<Class<?>>> needCreateTableMap = this.filterRepeatTable(classes);
        log.info("databaseType=mysql\uff0c\u5f00\u59cb\u6267\u884cmysql\u7684\u5904\u7406\u65b9\u6cd5");
        this.tableInitHandler.initTable(needCreateTableMap);
    }

    private boolean checkRunEnd() {
        if (!MYSQL.equals(this.databaseType)) {
            log.warn("{}\u6570\u636e\u5e93\u6682\u4e0d\u652f\u6301\uff01\u65e0\u6cd5\u81ea\u52a8\u521b\u5efa\u8868", (Object)this.databaseType);
            return true;
        }
        if (!("none".equals(this.tableAuto) || "update".equals(this.tableAuto) || "create".equals(this.tableAuto) || "add".equals(this.tableAuto))) {
            log.warn("\u914d\u7f6emybatis.table.auto\u9519\u8bef\u65e0\u6cd5\u8bc6\u522b\uff0c\u5f53\u524d\u914d\u7f6e\u53ea\u652f\u6301[none/update/create/add]\u4e09\u79cd\u7c7b\u578b!");
            return true;
        }
        if ("none".equals(this.tableAuto)) {
            log.info("\u914d\u7f6emybatis.table.auto=none\uff0c\u4e0d\u9700\u8981\u505a\u4efb\u4f55\u4e8b\u60c5");
            return true;
        }
        return false;
    }

    private Map<String, Set<Class<?>>> filterRepeatTable(Set<Class<?>> classes) {
        Map<String, List<Class>> classMap = classes.stream().collect(Collectors.groupingBy(ColumnUtils::getTableName));
        HashMap needCreateTable = new HashMap();
        classMap.forEach((tableName, sameClasses) -> {
            Class primaryClass;
            if (sameClasses.size() > 1) {
                List primaryClasses = sameClasses.stream().filter(clazz -> ((TablePrimary)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)clazz, TablePrimary.class)).value()).collect(Collectors.toList());
                if (primaryClasses.isEmpty()) {
                    throw new RuntimeException("\u8868\u540d[" + tableName + "]\u51fa\u73b0\u91cd\u590d\uff0c\u5fc5\u987b\u6307\u5b9a\u4e00\u4e2a\u4e3a@TablePrimary\uff01");
                }
                if (primaryClasses.size() > 1) {
                    throw new RuntimeException("\u8868\u540d[" + tableName + "]\u51fa\u73b0\u91cd\u590d\uff0c\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a\u4e3a@TablePrimary\uff01");
                }
                primaryClass = (Class)primaryClasses.get(0);
            } else {
                primaryClass = (Class)sameClasses.get(0);
            }
            DsName mergedAnnotation = (DsName)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)primaryClass, DsName.class);
            String dsName = mergedAnnotation != null ? mergedAnnotation.value() : "";
            needCreateTable.computeIfAbsent(dsName, k -> new HashSet()).add(primaryClass);
        });
        return needCreateTable;
    }
}

