/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.actable.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class ClassTools {
    private static final Logger log = LoggerFactory.getLogger(ClassTools.class);

    public static Set<Class<?>> getClasses(String packs) {
        String[] split;
        LinkedHashSet classes = new LinkedHashSet();
        for (String pack : split = packs.split(",|;")) {
            boolean recursive = true;
            String packageName = pack;
            String packageDirName = packageName.replace('.', '/');
            try {
                Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
                while (dirs.hasMoreElements()) {
                    URL url = dirs.nextElement();
                    String protocol = url.getProtocol();
                    if ("file".equals(protocol)) {
                        log.info("file\u7c7b\u578b\u7684\u626b\u63cf:" + pack);
                        String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                        ClassTools.findAndAddClassesInPackageByFile(packageName, filePath, recursive, classes);
                        continue;
                    }
                    if (!"jar".equals(protocol)) continue;
                    log.info("jar\u7c7b\u578b\u7684\u626b\u63cf");
                    try {
                        JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                        Enumeration<JarEntry> entries = jar.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry entry = entries.nextElement();
                            String name = entry.getName();
                            if (name.charAt(0) == '/') {
                                name = name.substring(1);
                            }
                            if (!name.startsWith(packageDirName)) continue;
                            int idx = name.lastIndexOf(47);
                            if (idx != -1) {
                                packageName = name.substring(0, idx).replace('/', '.');
                            }
                            if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
                            String className = name.substring(packageName.length() + 1, name.length() - 6);
                            try {
                                classes.add(Class.forName(packageName + '.' + className));
                                log.info("\u8bfb\u53d6\u5230class:{}", (Object)(packageName + '.' + className));
                            }
                            catch (ClassNotFoundException e) {
                                log.error("\u6dfb\u52a0\u7528\u6237\u81ea\u5b9a\u4e49\u89c6\u56fe\u7c7b\u9519\u8bef \u627e\u4e0d\u5230\u6b64\u7c7b\u7684.class\u6587\u4ef6", (Throwable)e);
                            }
                        }
                    }
                    catch (IOException e) {
                        log.error("\u5728\u626b\u63cf\u7528\u6237\u5b9a\u4e49\u89c6\u56fe\u65f6\u4ecejar\u5305\u83b7\u53d6\u6587\u4ef6\u51fa\u9519", (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                log.error("\u5728\u626b\u63cfclass\u5305\u5f02\u5e38", (Throwable)e);
            }
        }
        return classes;
    }

    public static void findAndAddClassesInPackageByFile(String packageName, String packagePath, boolean recursive, Set<Class<?>> classes) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            log.warn("\u7528\u6237\u5b9a\u4e49\u5305\u540d " + packageName + " \u4e0b\u6ca1\u6709\u4efb\u4f55\u6587\u4ef6");
            return;
        }
        for (File file2 : dirfiles = dir.listFiles(file -> recursive && file.isDirectory() || file.getName().endsWith(".class"))) {
            if (file2.isDirectory()) {
                ClassTools.findAndAddClassesInPackageByFile(packageName + "." + file2.getName(), file2.getAbsolutePath(), recursive, classes);
                continue;
            }
            String className = file2.getName().substring(0, file2.getName().length() - 6);
            try {
                classes.add(Thread.currentThread().getContextClassLoader().loadClass(packageName + '.' + className));
                log.info("\u8bfb\u53d6\u5230class:{}", (Object)(packageName + '.' + className));
            }
            catch (ClassNotFoundException e) {
                log.error("\u6dfb\u52a0\u7528\u6237\u81ea\u5b9a\u4e49\u89c6\u56fe\u7c7b\u9519\u8bef \u627e\u4e0d\u5230\u6b64\u7c7b\u7684.class\u6587\u4ef6", (Throwable)e);
            }
        }
    }

    public static <T, E> List<E> getPropertyValueList(List<T> objList, String fieldName) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            for (T object : objList) {
                Field field = object.getClass().getDeclaredField(fieldName);
                field.setAccessible(true);
                list.add(field.get(object));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static List<String> toLowerCase(List<String> list) {
        if (null == list || list.isEmpty()) {
            return list;
        }
        ArrayList<String> upperList = new ArrayList<String>();
        for (String str : list) {
            upperList.add(str.toLowerCase());
        }
        return upperList;
    }

    public static String getBootPackage() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement stackTraceElement : stackTrace = new RuntimeException().getStackTrace()) {
            if (!"main".equals(stackTraceElement.getMethodName())) continue;
            return ClassUtils.getPackageName((String)stackTraceElement.getClassName());
        }
        throw new RuntimeException("\u672a\u627e\u5230\u4e3b\u9ed8\u8ba4\u5305");
    }
}

