/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.actable.utils;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.metadata.AnnotatedElementUtilsPlus;
import com.baomidou.mybatisplus.core.metadata.impl.TableFieldImpl;
import com.baomidou.mybatisplus.core.metadata.impl.TableNameImpl;
import com.google.common.base.CaseFormat;
import com.tangzc.mpe.actable.MybatisPlusProperties;
import com.tangzc.mpe.actable.annotation.ColumnComment;
import com.tangzc.mpe.actable.annotation.ColumnDefault;
import com.tangzc.mpe.actable.annotation.ColumnType;
import com.tangzc.mpe.actable.annotation.EnableTimeSuffix;
import com.tangzc.mpe.actable.annotation.IgnoreTable;
import com.tangzc.mpe.actable.annotation.IsAutoIncrement;
import com.tangzc.mpe.actable.annotation.IsKey;
import com.tangzc.mpe.actable.annotation.IsNativeDefValue;
import com.tangzc.mpe.actable.annotation.IsNotNull;
import com.tangzc.mpe.actable.annotation.Table;
import com.tangzc.mpe.actable.annotation.TableCharset;
import com.tangzc.mpe.actable.annotation.TableComment;
import com.tangzc.mpe.actable.annotation.TableEngine;
import com.tangzc.mpe.actable.annotation.constants.MySqlCharsetConstant;
import com.tangzc.mpe.actable.annotation.constants.MySqlEngineConstant;
import com.tangzc.mpe.actable.annotation.constants.MySqlTypeConstant;
import com.tangzc.mpe.actable.command.JavaToMysqlType;
import com.tangzc.mpe.actable.command.MySqlTypeAndLength;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.StringUtils;

public class ColumnUtils {
    public static final String SQL_ESCAPE_CHARACTER = "`";
    public static Map<String, MySqlTypeAndLength> mySqlTypeAndLengthMap = new HashMap<String, MySqlTypeAndLength>();

    public static String getTableName(Class<?> clasz) {
        TableName tableNamePlus = (TableName)AnnotatedElementUtilsPlus.findMergedAnnotation(clasz, TableName.class, TableNameImpl.class);
        EnableTimeSuffix enableTimeSuffix = (EnableTimeSuffix)AnnotatedElementUtils.findMergedAnnotation(clasz, EnableTimeSuffix.class);
        String finalTableName = "";
        if (tableNamePlus != null && !StringUtils.isEmpty((Object)tableNamePlus.value())) {
            finalTableName = tableNamePlus.value();
        }
        if (StringUtils.isEmpty((Object)finalTableName)) {
            finalTableName = MybatisPlusProperties.tableUnderline ? ColumnUtils.getBuildLowerName(clasz.getSimpleName()) : clasz.getSimpleName().toLowerCase();
        }
        if (null != enableTimeSuffix && enableTimeSuffix.value()) {
            finalTableName = ColumnUtils.appendTimeSuffix(finalTableName, enableTimeSuffix.pattern());
        }
        return finalTableName;
    }

    public static String getTableComment(Class<?> clasz) {
        TableComment tableComment = (TableComment)AnnotatedElementUtils.findMergedAnnotation(clasz, TableComment.class);
        if (tableComment != null) {
            return tableComment.value();
        }
        return "";
    }

    public static MySqlCharsetConstant getTableCharset(Class<?> clasz) {
        TableCharset table = (TableCharset)AnnotatedElementUtils.findMergedAnnotation(clasz, TableCharset.class);
        if (table != null && table.value() != MySqlCharsetConstant.DEFAULT) {
            return table.value();
        }
        return null;
    }

    public static MySqlEngineConstant getTableEngine(Class<?> clasz) {
        TableEngine table = (TableEngine)AnnotatedElementUtils.findMergedAnnotation(clasz, TableEngine.class);
        if (table != null && table.value() != MySqlEngineConstant.DEFAULT) {
            return table.value();
        }
        return null;
    }

    public static String getColumnName(Field field) {
        TableField tableField = (TableField)AnnotatedElementUtilsPlus.findMergedAnnotation((AnnotatedElement)field, TableField.class, TableFieldImpl.class);
        if (tableField != null && !StringUtils.isEmpty((Object)tableField.value()) && tableField.exist()) {
            return tableField.value().toLowerCase().replace(SQL_ESCAPE_CHARACTER, "");
        }
        TableId tableId = (TableId)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, TableId.class);
        if (tableId != null && !StringUtils.isEmpty((Object)tableId.value())) {
            return tableId.value().replace(SQL_ESCAPE_CHARACTER, "");
        }
        if (!MybatisPlusProperties.mapUnderscoreToCamelCase) {
            return field.getName();
        }
        return ColumnUtils.getBuildLowerName(field.getName());
    }

    private static String getBuildLowerName(String name) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name).toLowerCase();
    }

    public static boolean isKey(Field field, Class<?> clasz) {
        if (AnnotatedElementUtils.hasAnnotation((AnnotatedElement)field, TableId.class)) {
            return true;
        }
        IsKey column = (IsKey)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, IsKey.class);
        if (column != null && column.value()) {
            return true;
        }
        return "id".equals(field.getName());
    }

    public static boolean isAutoIncrement(Field field, Class<?> clasz) {
        IsAutoIncrement column = (IsAutoIncrement)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, IsAutoIncrement.class);
        if (!ColumnUtils.isIncloudField(field, clasz)) {
            return false;
        }
        return column != null && column.value();
    }

    public static Boolean isNull(Field field, Class<?> clasz) {
        if (ColumnUtils.isKey(field, clasz)) {
            return false;
        }
        IsNotNull column = (IsNotNull)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, IsNotNull.class);
        if (column != null) {
            return !column.value();
        }
        return true;
    }

    public static String getComment(Field field, Class<?> clasz) {
        ColumnComment column = (ColumnComment)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, ColumnComment.class);
        if (column != null) {
            return column.value();
        }
        return "";
    }

    public static String getDefaultValue(Field field, Class<?> clasz) {
        ColumnDefault column = (ColumnDefault)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, ColumnDefault.class);
        if (column != null && !column.value().isEmpty()) {
            return column.value();
        }
        return null;
    }

    public static boolean getDefaultValueNative(Field field, Class<?> clasz) {
        IsNativeDefValue isNativeDefValue = (IsNativeDefValue)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, IsNativeDefValue.class);
        if (isNativeDefValue != null) {
            return isNativeDefValue.value();
        }
        return !field.getGenericType().toString().equals("class java.lang.String") && !field.getGenericType().toString().equals("char") && !field.getGenericType().toString().equals("class java.lang.Boolean") && !field.getGenericType().toString().equals("boolean");
    }

    public static MySqlTypeAndLength getMySqlTypeAndLength(Field field, Class<?> clasz) {
        ColumnType column = (ColumnType)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, ColumnType.class);
        if (column != null && column.value() != MySqlTypeConstant.DEFAULT) {
            return ColumnUtils.buildMySqlTypeAndLength(clasz, field, column.value().toString().toLowerCase(), column.length(), column.decimalLength());
        }
        MySqlTypeConstant mysqlType = JavaToMysqlType.getSqlType(field, clasz);
        if (mysqlType == null) {
            throw new RuntimeException("\u5b57\u6bb5\u540d\uff1a" + clasz.getName() + ":" + field.getName() + "\u4e0d\u652f\u6301" + field.getGenericType() + "\u7c7b\u578b\u8f6c\u6362\u5230mysql\u7c7b\u578b\uff0c\u4ec5\u652f\u6301JavaToMysqlType\u7c7b\u4e2d\u7684\u7c7b\u578b\u9ed8\u8ba4\u8f6c\u6362\uff0c\u5f02\u5e38\u629b\u51fa\uff01");
        }
        String sqlType = mysqlType.toString().toLowerCase();
        if (column != null) {
            return ColumnUtils.buildMySqlTypeAndLength(clasz, field, sqlType, column.length(), column.decimalLength());
        }
        return ColumnUtils.buildMySqlTypeAndLength(clasz, field, sqlType, 255, 0);
    }

    private static MySqlTypeAndLength buildMySqlTypeAndLength(Class<?> clasz, Field field, String type, int length, int decimalLength) {
        MySqlTypeAndLength mySqlTypeAndLength = mySqlTypeAndLengthMap.get(type);
        if (mySqlTypeAndLength == null) {
            throw new RuntimeException("\u5b57\u6bb5\u540d\uff1a" + clasz.getName() + ":" + field.getName() + "\u4f7f\u7528\u7684" + type + "\u7c7b\u578b\uff0c\u6ca1\u6709\u914d\u7f6e\u5bf9\u5e94\u7684MySqlTypeConstant\uff0c\u53ea\u652f\u6301\u521b\u5efaMySqlTypeConstant\u4e2d\u7c7b\u578b\u7684\u5b57\u6bb5\uff0c\u5f02\u5e38\u629b\u51fa\uff01");
        }
        MySqlTypeAndLength targetMySqlTypeAndLength = new MySqlTypeAndLength();
        BeanUtils.copyProperties((Object)mySqlTypeAndLength, (Object)targetMySqlTypeAndLength);
        if (length != 255) {
            targetMySqlTypeAndLength.setLength(length);
        }
        if (decimalLength != 0) {
            targetMySqlTypeAndLength.setDecimalLength(decimalLength);
        }
        return targetMySqlTypeAndLength;
    }

    public static boolean hasIgnoreTableAnnotation(Class<?> clasz) {
        return AnnotatedElementUtils.hasAnnotation(clasz, IgnoreTable.class);
    }

    public static boolean isIncloudField(Field field, Class<?> clasz) {
        TableField tableField = (TableField)AnnotatedElementUtilsPlus.findMergedAnnotation((AnnotatedElement)field, TableField.class, TableFieldImpl.class);
        if (tableField != null && !tableField.exist()) {
            return false;
        }
        String[] excludeFields = new String[]{};
        Table table = (Table)AnnotatedElementUtils.findMergedAnnotation(clasz, Table.class);
        if (table != null) {
            excludeFields = table.excludeFields();
        }
        return !Arrays.asList(excludeFields).contains(field.getName());
    }

    public static String appendTimeSuffix(String tableName, String pattern) {
        String suffix = "";
        try {
            suffix = DateTimeFormatter.ofPattern(pattern).format(LocalDateTime.now());
        }
        catch (Exception e) {
            throw new RuntimeException("\u65e0\u6cd5\u8f6c\u6362\u65f6\u95f4\u683c\u5f0f" + pattern);
        }
        return tableName + "_" + suffix;
    }

    static {
        for (MySqlTypeConstant type : MySqlTypeConstant.values()) {
            mySqlTypeAndLengthMap.put(type.toString().toLowerCase(), new MySqlTypeAndLength(type.getLengthCount(), type.getLengthDefault(), type.getDecimalLengthDefault(), type.toString().toLowerCase()));
        }
    }
}

