/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.metadata;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.KeySequence;
import com.baomidou.mybatisplus.annotation.OrderBy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.incrementer.IKeyGenerator;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.builder.StaticSqlSource;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.SelectKeyGenerator;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.reflection.Reflector;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.session.Configuration;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class TableInfoHelper {
    private static final Log logger = LogFactory.getLog(TableInfoHelper.class);
    private static final Map<Class<?>, TableInfo> TABLE_INFO_CACHE = new ConcurrentHashMap();
    private static final Map<String, TableInfo> TABLE_NAME_INFO_CACHE = new ConcurrentHashMap<String, TableInfo>();
    private static final String DEFAULT_ID_NAME = "id";

    public static TableInfo getTableInfo(Class<?> clazz) {
        if (clazz == null || ReflectionKit.isPrimitiveOrWrapper(clazz) || clazz == String.class || clazz.isInterface()) {
            return null;
        }
        Class targetClass = ClassUtils.getUserClass(clazz);
        TableInfo tableInfo = TABLE_INFO_CACHE.get(targetClass);
        if (null != tableInfo) {
            return tableInfo;
        }
        for (Class<?> currentClass = clazz; null == tableInfo && Object.class != currentClass; currentClass = currentClass.getSuperclass()) {
            tableInfo = TABLE_INFO_CACHE.get(ClassUtils.getUserClass(currentClass));
        }
        if (tableInfo != null) {
            TABLE_INFO_CACHE.put(targetClass, tableInfo);
        }
        return tableInfo;
    }

    public static TableInfo getTableInfo(String tableName) {
        if (StringUtils.isBlank((CharSequence)tableName)) {
            return null;
        }
        return TABLE_NAME_INFO_CACHE.get(tableName);
    }

    public static List<TableInfo> getTableInfos() {
        return Collections.unmodifiableList(new ArrayList<TableInfo>(TABLE_INFO_CACHE.values()));
    }

    public static synchronized TableInfo initTableInfo(MapperBuilderAssistant builderAssistant, Class<?> clazz) {
        TableInfo targetTableInfo = TABLE_INFO_CACHE.get(clazz);
        Configuration configuration = builderAssistant.getConfiguration();
        if (targetTableInfo != null) {
            Configuration oldConfiguration = targetTableInfo.getConfiguration();
            if (!oldConfiguration.equals(configuration)) {
                targetTableInfo = TableInfoHelper.initTableInfo(configuration, builderAssistant.getCurrentNamespace(), clazz);
            }
            return targetTableInfo;
        }
        return TableInfoHelper.initTableInfo(configuration, builderAssistant.getCurrentNamespace(), clazz);
    }

    private static synchronized TableInfo initTableInfo(Configuration configuration, String currentNamespace, Class<?> clazz) {
        TableInfo tableInfo = new TableInfo(clazz);
        tableInfo.setCurrentNamespace(currentNamespace);
        tableInfo.setConfiguration(configuration);
        GlobalConfig globalConfig = GlobalConfigUtils.getGlobalConfig((Configuration)configuration);
        String[] excludeProperty = TableInfoHelper.initTableName(clazz, globalConfig, tableInfo);
        List<String> excludePropertyList = excludeProperty != null && excludeProperty.length > 0 ? Arrays.asList(excludeProperty) : Collections.emptyList();
        TableInfoHelper.initTableFields(clazz, globalConfig, tableInfo, excludePropertyList);
        tableInfo.initResultMapIfNeed();
        TABLE_INFO_CACHE.put(clazz, tableInfo);
        TABLE_NAME_INFO_CACHE.put(tableInfo.getTableName(), tableInfo);
        LambdaUtils.installCache((TableInfo)tableInfo);
        return tableInfo;
    }

    private static String[] initTableName(Class<?> clazz, GlobalConfig globalConfig, TableInfo tableInfo) {
        GlobalConfig.DbConfig dbConfig = globalConfig.getDbConfig();
        TableName table = (TableName)AnnotatedElementUtils.findMergedAnnotation(clazz, TableName.class);
        String tableName = clazz.getSimpleName();
        String tablePrefix = dbConfig.getTablePrefix();
        String schema = dbConfig.getSchema();
        boolean tablePrefixEffect = true;
        String[] excludeProperty = null;
        if (table != null) {
            if (StringUtils.isNotBlank((CharSequence)table.value())) {
                tableName = table.value();
                if (StringUtils.isNotBlank((CharSequence)tablePrefix) && !table.keepGlobalPrefix()) {
                    tablePrefixEffect = false;
                }
            } else {
                tableName = TableInfoHelper.initTableNameWithDbConfig(tableName, dbConfig);
            }
            if (StringUtils.isNotBlank((CharSequence)table.schema())) {
                schema = table.schema();
            }
            if (StringUtils.isNotBlank((CharSequence)table.resultMap())) {
                tableInfo.setResultMap(table.resultMap());
            }
            tableInfo.setAutoInitResultMap(table.autoResultMap());
            excludeProperty = table.excludeProperty();
        } else {
            tableName = TableInfoHelper.initTableNameWithDbConfig(tableName, dbConfig);
        }
        String targetTableName = tableName;
        if (StringUtils.isNotBlank((CharSequence)tablePrefix) && tablePrefixEffect) {
            targetTableName = tablePrefix + targetTableName;
        }
        if (StringUtils.isNotBlank((CharSequence)schema)) {
            targetTableName = schema + "." + targetTableName;
        }
        tableInfo.setTableName(targetTableName);
        if (CollectionUtils.isNotEmpty((Collection)dbConfig.getKeyGenerators())) {
            tableInfo.setKeySequence((KeySequence)AnnotatedElementUtils.findMergedAnnotation(clazz, KeySequence.class));
        }
        return excludeProperty;
    }

    private static String initTableNameWithDbConfig(String className, GlobalConfig.DbConfig dbConfig) {
        String tableName = className;
        if (dbConfig.isTableUnderline()) {
            tableName = StringUtils.camelToUnderline((String)tableName);
        }
        tableName = dbConfig.isCapitalMode() ? tableName.toUpperCase() : StringUtils.firstToLowerCase((String)tableName);
        return tableName;
    }

    private static void initTableFields(Class<?> clazz, GlobalConfig globalConfig, TableInfo tableInfo, List<String> excludeProperty) {
        GlobalConfig.DbConfig dbConfig = globalConfig.getDbConfig();
        ReflectorFactory reflectorFactory = tableInfo.getConfiguration().getReflectorFactory();
        Reflector reflector = reflectorFactory.findForClass(clazz);
        List<Field> list = TableInfoHelper.getAllFields(clazz);
        boolean isReadPK = false;
        boolean existTableId = TableInfoHelper.isExistTableId(list);
        boolean existTableLogic = TableInfoHelper.isExistTableLogic(list);
        boolean existOrderBy = TableInfoHelper.isExistOrderBy(list);
        ArrayList<TableFieldInfo> fieldList = new ArrayList<TableFieldInfo>(list.size());
        for (Field field : list) {
            TableField tableField;
            if (excludeProperty.contains(field.getName())) continue;
            if (existTableId) {
                TableId tableId = (TableId)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, TableId.class);
                if (tableId != null) {
                    if (isReadPK) {
                        throw ExceptionUtils.mpe((String)"@TableId can't more than one in Class: \"%s\".", (Object[])new Object[]{clazz.getName()});
                    }
                    TableInfoHelper.initTableIdWithAnnotation(dbConfig, tableInfo, field, tableId, reflector);
                    isReadPK = true;
                    continue;
                }
            } else if (!isReadPK && (isReadPK = TableInfoHelper.initTableIdWithoutAnnotation(dbConfig, tableInfo, field, reflector))) continue;
            if ((tableField = (TableField)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, TableField.class)) != null) {
                fieldList.add(new TableFieldInfo(dbConfig, tableInfo, field, tableField, reflector, existTableLogic, existOrderBy));
                continue;
            }
            fieldList.add(new TableFieldInfo(dbConfig, tableInfo, field, reflector, existTableLogic, existOrderBy));
        }
        tableInfo.setFieldList(fieldList);
        if (!isReadPK) {
            logger.warn(String.format("Can not find table primary key in Class: \"%s\".", clazz.getName()));
        }
    }

    public static boolean isExistTableId(List<Field> list) {
        return list.stream().anyMatch(field -> AnnotatedElementUtils.hasAnnotation((AnnotatedElement)field, TableId.class));
    }

    public static boolean isExistTableLogic(List<Field> list) {
        return list.stream().anyMatch(field -> AnnotatedElementUtils.hasAnnotation((AnnotatedElement)field, TableLogic.class));
    }

    public static boolean isExistOrderBy(List<Field> list) {
        return list.stream().anyMatch(field -> AnnotatedElementUtils.hasAnnotation((AnnotatedElement)field, OrderBy.class));
    }

    private static void initTableIdWithAnnotation(GlobalConfig.DbConfig dbConfig, TableInfo tableInfo, Field field, TableId tableId, Reflector reflector) {
        boolean underCamel = tableInfo.isUnderCamel();
        String property = field.getName();
        if (AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, TableField.class) != null) {
            logger.warn(String.format("This \"%s\" is the table primary key by @TableId annotation in Class: \"%s\",So @TableField annotation will not work!", property, tableInfo.getEntityType().getName()));
        }
        if (IdType.NONE == tableId.type()) {
            tableInfo.setIdType(dbConfig.getIdType());
        } else {
            tableInfo.setIdType(tableId.type());
        }
        String column = property;
        if (StringUtils.isNotBlank((CharSequence)tableId.value())) {
            column = tableId.value();
        } else {
            if (underCamel) {
                column = StringUtils.camelToUnderline((String)column);
            }
            if (dbConfig.isCapitalMode()) {
                column = column.toUpperCase();
            }
        }
        Class keyType = reflector.getGetterType(property);
        if (keyType.isPrimitive()) {
            logger.warn(String.format("This primary key of \"%s\" is primitive !\u4e0d\u5efa\u8bae\u5982\u6b64\u8bf7\u4f7f\u7528\u5305\u88c5\u7c7b in Class: \"%s\"", property, tableInfo.getEntityType().getName()));
        }
        tableInfo.setKeyRelated(TableInfoHelper.checkRelated(underCamel, property, column)).setKeyColumn(column).setKeyProperty(property).setKeyType(keyType);
    }

    private static boolean initTableIdWithoutAnnotation(GlobalConfig.DbConfig dbConfig, TableInfo tableInfo, Field field, Reflector reflector) {
        String property = field.getName();
        if (DEFAULT_ID_NAME.equalsIgnoreCase(property)) {
            Class keyType;
            if (AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, TableField.class) != null) {
                logger.warn(String.format("This \"%s\" is the table primary key by default name for `id` in Class: \"%s\",So @TableField will not work!", property, tableInfo.getEntityType().getName()));
            }
            String column = property;
            if (dbConfig.isCapitalMode()) {
                column = column.toUpperCase();
            }
            if ((keyType = reflector.getGetterType(property)).isPrimitive()) {
                logger.warn(String.format("This primary key of \"%s\" is primitive !\u4e0d\u5efa\u8bae\u5982\u6b64\u8bf7\u4f7f\u7528\u5305\u88c5\u7c7b in Class: \"%s\"", property, tableInfo.getEntityType().getName()));
            }
            tableInfo.setKeyRelated(TableInfoHelper.checkRelated(tableInfo.isUnderCamel(), property, column)).setIdType(dbConfig.getIdType()).setKeyColumn(column).setKeyProperty(property).setKeyType(keyType);
            return true;
        }
        return false;
    }

    public static boolean checkRelated(boolean underCamel, String property, String column) {
        column = StringUtils.getTargetColumn((String)column);
        String propertyUpper = property.toUpperCase(Locale.ENGLISH);
        String columnUpper = column.toUpperCase(Locale.ENGLISH);
        if (underCamel) {
            return !propertyUpper.equals(columnUpper) && !propertyUpper.equals(columnUpper.replace("_", ""));
        }
        return !propertyUpper.equals(columnUpper);
    }

    public static List<Field> getAllFields(Class<?> clazz) {
        List fieldList = ReflectionKit.getFieldList((Class)ClassUtils.getUserClass(clazz));
        return fieldList.stream().filter(field -> {
            TableField tableField = (TableField)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, TableField.class);
            return tableField == null || tableField.exist();
        }).collect(Collectors.toList());
    }

    public static KeyGenerator genKeyGenerator(String baseStatementId, TableInfo tableInfo, MapperBuilderAssistant builderAssistant) {
        KeySequence keySequence;
        List keyGenerators = GlobalConfigUtils.getKeyGenerators((Configuration)builderAssistant.getConfiguration());
        if (CollectionUtils.isEmpty((Collection)keyGenerators)) {
            throw new IllegalArgumentException("not configure IKeyGenerator implementation class.");
        }
        IKeyGenerator keyGenerator = null;
        if (keyGenerators.size() > 1 && null != (keySequence = tableInfo.getKeySequence()) && DbType.OTHER != keySequence.dbType()) {
            keyGenerator = keyGenerators.stream().filter(k -> k.dbType() == keySequence.dbType()).findFirst().get();
        }
        if (null == keyGenerator) {
            keyGenerator = (IKeyGenerator)keyGenerators.get(0);
        }
        Configuration configuration = builderAssistant.getConfiguration();
        String id = builderAssistant.getCurrentNamespace() + "." + baseStatementId + "!selectKey";
        ResultMap resultMap = new ResultMap.Builder(builderAssistant.getConfiguration(), id, tableInfo.getKeyType(), new ArrayList()).build();
        MappedStatement mappedStatement = new MappedStatement.Builder(builderAssistant.getConfiguration(), id, (SqlSource)new StaticSqlSource(configuration, keyGenerator.executeSql(tableInfo.getKeySequence().value())), SqlCommandType.SELECT).keyProperty(tableInfo.getKeyProperty()).resultMaps(Collections.singletonList(resultMap)).build();
        configuration.addMappedStatement(mappedStatement);
        return new SelectKeyGenerator(mappedStatement, true);
    }
}

