/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.base;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.tangzc.mpe.base.event.InitScanEntityEvent;
import com.tangzc.mpe.base.event.InitScanMapperEvent;
import com.tangzc.mpe.base.util.ReflectionUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class MapperScanner
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(MapperScanner.class);
    private static final Map<Class<?>, BaseMapper<?>> ENTITY_MAPPER_CACHE_MAP = new ConcurrentHashMap();
    @Resource
    private ApplicationEventPublisher applicationEventPublisher;
    @Autowired(required=false)
    private List<BaseMapper<?>> proxyMapperList;

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        if (this.proxyMapperList == null) {
            return;
        }
        for (BaseMapper<?> proxyMapper : this.proxyMapperList) {
            Class<?> entityClass = ReflectionUtil.getEntityClass(proxyMapper);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new InitScanMapperEvent(proxyMapper));
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new InitScanEntityEvent(entityClass));
            ENTITY_MAPPER_CACHE_MAP.put(entityClass, proxyMapper);
        }
    }

    public static <ENTITY> BaseMapper<ENTITY> getMapper(Class<ENTITY> entityClass) {
        BaseMapper<?> baseMapper = ENTITY_MAPPER_CACHE_MAP.get(entityClass);
        if (baseMapper == null) {
            throw new RuntimeException("\u672a\u53d1\u73b0" + entityClass.getName() + "\u7684BaseMapper\u5b9e\u73b0");
        }
        return baseMapper;
    }
}

