/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.base;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.tangzc.mpe.base.event.InitScanEntityEvent;
import com.tangzc.mpe.base.event.InitScanMapperEvent;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;

public class MapperScanner {
    private static final Logger log = LoggerFactory.getLogger(MapperScanner.class);
    private static final Map<String, BaseMapper<?>> ENTITY_MAPPER_CACHE_MAP = new ConcurrentHashMap();
    @Resource
    private ApplicationEventPublisher applicationEventPublisher;
    @Autowired(required=false)
    private List<? extends BaseMapper<?>> proxyMapperList;

    @EventListener
    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        if (this.proxyMapperList == null) {
            return;
        }
        for (BaseMapper<?> proxyMapper : this.proxyMapperList) {
            Class entityClass = ReflectionKit.getSuperClassGenericType(proxyMapper.getClass(), BaseMapper.class, (int)0);
            if (entityClass == null) continue;
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new InitScanMapperEvent(proxyMapper));
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new InitScanEntityEvent(entityClass));
            ENTITY_MAPPER_CACHE_MAP.put(entityClass.getName(), proxyMapper);
        }
    }

    public static <ENTITY> BaseMapper<ENTITY> getMapper(Class<ENTITY> entityClass) {
        String entityClassName = entityClass.getName();
        BaseMapper<?> baseMapper = ENTITY_MAPPER_CACHE_MAP.get(entityClassName);
        if (baseMapper == null) {
            throw new RuntimeException("\u672a\u53d1\u73b0" + entityClassName + "\u7684BaseMapper\u5b9e\u73b0");
        }
        return baseMapper;
    }
}

