/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.base;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.tangzc.mpe.base.event.InitScanEntityEvent;
import com.tangzc.mpe.magic.util.SpringContextUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;

public class MapperScanner {
    private static final Logger log = LoggerFactory.getLogger(MapperScanner.class);
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @EventListener
    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        List tableInfos = TableInfoHelper.getTableInfos();
        if (tableInfos.isEmpty()) {
            return;
        }
        for (TableInfo tableInfo : tableInfos) {
            Class entityClass = tableInfo.getEntityType();
            if (entityClass == null) continue;
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new InitScanEntityEvent(entityClass));
        }
    }

    public static <ENTITY, R> R getMapperExecute(Class<ENTITY> entityClass, SFunction<BaseMapper<ENTITY>, R> sFunction) {
        try {
            TableInfo tableInfo = TableInfoHelper.getTableInfo(entityClass);
            Class mapperClass = ClassUtils.toClassConfident((String)tableInfo.getCurrentNamespace());
            BaseMapper springMapper = (BaseMapper)SpringContextUtil.getBeanOfType((Class)mapperClass);
            return (R)sFunction.apply((Object)springMapper);
        }
        catch (Exception ignore) {
            return (R)SqlHelper.execute(entityClass, sFunction);
        }
    }
}

