/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.metadata;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class AnnotatedElementUtilsPlus
extends AnnotatedElementUtils {
    private static final Logger log = LoggerFactory.getLogger(AnnotatedElementUtilsPlus.class);

    public static <ANNO extends Annotation, IMPL extends ANNO> IMPL findMergedAnnotation(AnnotatedElement element, Class<ANNO> annoClass, Class<IMPL> implClass) {
        Set allMergedAnnotations = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)element, annoClass);
        return AnnotatedElementUtilsPlus.merge(annoClass, implClass, allMergedAnnotations);
    }

    public static <ANNO extends Annotation, IMPL extends ANNO> IMPL merge(Class<ANNO> annoClass, Class<IMPL> implClass, Collection<ANNO> tableFields) {
        if (tableFields == null || tableFields.isEmpty()) {
            return null;
        }
        try {
            Field[] fields;
            Annotation defaultImpl = (Annotation)implClass.newInstance();
            for (Field field : fields = implClass.getDeclaredFields()) {
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor(field.getName(), implClass);
                Object defaultVal = propertyDescriptor.getReadMethod().invoke((Object)defaultImpl, new Object[0]);
                tableFields.stream().map(tf -> {
                    try {
                        return annoClass.getMethod(field.getName(), new Class[0]).invoke(tf, new Object[0]);
                    }
                    catch (Exception e) {
                        log.warn("\u5408\u5e76TableField\u8fc7\u7a0b\u4e2d\uff0c\u83b7\u53d6\u6ce8\u89e3\u503c\u51fa\u9519", (Throwable)e);
                        return null;
                    }
                }).filter(Objects::nonNull).filter(val -> {
                    if (defaultVal.getClass().isArray()) {
                        return ((Object[])val).length != ((Object[])defaultVal).length;
                    }
                    return !Objects.equals(val, defaultVal);
                }).findFirst().ifPresent(val -> {
                    try {
                        propertyDescriptor.getWriteMethod().invoke((Object)defaultImpl, val);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.warn("\u5408\u5e76TableField\u8fc7\u7a0b\u4e2d\uff0c\u8bbe\u7f6e\u9ed8\u8ba4\u503c\u51fa\u9519", (Throwable)e);
                    }
                });
            }
            return (IMPL)defaultImpl;
        }
        catch (Exception e) {
            log.warn("\u5408\u5e76TableField\u8fc7\u7a0b\u4e2d\uff0c\u83b7\u53d6\u9ed8\u8ba4\u503c\u51fa\u9519", (Throwable)e);
            return null;
        }
    }
}

