/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.magic;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;

public class AnnotatedElementUtilsPlus
extends AnnotatedElementUtils {
    private static final Logger log = LoggerFactory.getLogger(AnnotatedElementUtilsPlus.class);

    public static <ANNO extends Annotation> ANNO findDeepMergedAnnotation(AnnotatedElement element, Class<ANNO> annoClass) {
        Set allMergedAnnotations = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)element, annoClass);
        return AnnotatedElementUtilsPlus.merge(annoClass, allMergedAnnotations);
    }

    public static <ANNO extends Annotation> ANNO merge(Class<ANNO> annoClass, Set<ANNO> allAnnotations) {
        if (allAnnotations == null || allAnnotations.isEmpty()) {
            return null;
        }
        try {
            Method[] annoMethods;
            Annotation defaultAnno = AnnotationUtils.synthesizeAnnotation(annoClass);
            for (Method annoMethod : annoMethods = annoClass.getDeclaredMethods()) {
                String annoFieldName = annoMethod.getName();
                Object defaultVal = null;
                try {
                    defaultVal = AnnotationUtils.getAnnotationAttributes((Annotation)defaultAnno).get(annoFieldName);
                }
                catch (Exception ignore) {
                    log.debug("{}\u7684{}\u65e0\u9ed8\u8ba4\u503c", annoClass, (Object)annoFieldName);
                }
                Object newVal = null;
                for (Annotation annotation : allAnnotations) {
                    try {
                        Object annoVal = annoClass.getMethod(annoFieldName, new Class[0]).invoke((Object)annotation, new Object[0]);
                        if (!AnnotatedElementUtilsPlus.compareValIsDiff(annoVal, defaultVal)) continue;
                        newVal = annoVal;
                        break;
                    }
                    catch (Exception e) {
                        log.warn("\u5408\u5e76TableField\u8fc7\u7a0b\u4e2d\uff0c\u83b7\u53d6\u6ce8\u89e3\u503c\u51fa\u9519", (Throwable)e);
                    }
                }
                if (newVal == null) continue;
                AnnotatedElementUtilsPlus.setAnnoVal(defaultAnno, annoFieldName, newVal);
            }
            return (ANNO)defaultAnno;
        }
        catch (Exception e) {
            log.warn("\u5408\u5e76TableField\u8fc7\u7a0b\u4e2d\uff0c\u83b7\u53d6\u9ed8\u8ba4\u503c\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    private static boolean compareValIsDiff(Object val, Object defVal) {
        if (val == null) {
            return false;
        }
        if (defVal == null) {
            return true;
        }
        if (defVal.getClass().isArray()) {
            if (((Object[])val).length == ((Object[])defVal).length && ((Object[])val).length != 0) {
                return new HashSet<Object>(Arrays.asList((Object[])val)).containsAll(Arrays.asList((Object[])defVal));
            }
            return false;
        }
        return !Objects.equals(val, defVal);
    }

    private static void setAnnoVal(Annotation annotation, String fieldName, Object newVal) {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(annotation);
        try {
            Field valuesField = invocationHandler.getClass().getDeclaredField("valueCache");
            valuesField.setAccessible(true);
            Map memberValues = (Map)valuesField.get(invocationHandler);
            memberValues.put(fieldName, newVal);
        }
        catch (Exception e) {
            log.error("\u6ce8\u89e3\u53cd\u5c04\u51fa\u9519", (Throwable)e);
        }
    }
}

