/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.magic;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.tangzc.mpe.magic.AnnotatedElementUtilsPlus;
import com.tangzc.mpe.magic.BeanClassUtil;
import com.tangzc.mpe.magic.MybatisPlusProperties;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class TableColumnNameUtil {
    public static String filterSpecialChar(String name) {
        return name.replaceAll("`", "");
    }

    public static String getTableName(Class<?> clazz) {
        Object finalTableName = "";
        TableName mybatisPlusTableName = AnnotatedElementUtilsPlus.findDeepMergedAnnotation(clazz, TableName.class);
        if (mybatisPlusTableName != null && org.springframework.util.StringUtils.hasText((String)mybatisPlusTableName.value())) {
            finalTableName = mybatisPlusTableName.value();
        }
        if (!org.springframework.util.StringUtils.hasText((String)finalTableName)) {
            finalTableName = TableColumnNameUtil.smartConvert(MybatisPlusProperties.tableUnderline, clazz.getSimpleName());
        }
        if (org.springframework.util.StringUtils.hasText((String)MybatisPlusProperties.tablePrefix)) {
            finalTableName = MybatisPlusProperties.tablePrefix + (String)finalTableName;
        }
        return finalTableName;
    }

    public static String getRealColumnName(Field field) {
        TableField tableField = AnnotatedElementUtilsPlus.findDeepMergedAnnotation(field, TableField.class);
        if (tableField != null && org.springframework.util.StringUtils.hasText((String)tableField.value()) && tableField.exist()) {
            return TableColumnNameUtil.filterSpecialChar(tableField.value());
        }
        TableId tableId = (TableId)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, TableId.class);
        if (tableId != null && org.springframework.util.StringUtils.hasText((String)tableId.value())) {
            return TableColumnNameUtil.filterSpecialChar(tableId.value());
        }
        return TableColumnNameUtil.smartConvert(MybatisPlusProperties.mapUnderscoreToCamelCase, field.getName());
    }

    public static String getRealColumnName(Class<?> beanClazz, String fieldName) {
        Field field = BeanClassUtil.getField(beanClazz, fieldName);
        TableField tableField = AnnotatedElementUtilsPlus.findDeepMergedAnnotation(field, TableField.class);
        if (tableField != null && org.springframework.util.StringUtils.hasText((String)tableField.value()) && tableField.exist()) {
            return TableColumnNameUtil.filterSpecialChar(tableField.value());
        }
        TableId tableId = (TableId)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, TableId.class);
        if (tableId != null && org.springframework.util.StringUtils.hasText((String)tableId.value())) {
            return TableColumnNameUtil.filterSpecialChar(tableId.value());
        }
        return TableColumnNameUtil.smartConvert(MybatisPlusProperties.mapUnderscoreToCamelCase, field.getName());
    }

    private static String smartConvert(boolean underCamel, String column) {
        if (underCamel) {
            column = StringUtils.camelToUnderline((String)column);
        }
        if (MybatisPlusProperties.capitalMode) {
            column = column.toUpperCase();
        }
        return column;
    }
}

