/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.magic.util;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.baomidou.mybatisplus.annotation.IEnum;
import com.baomidou.mybatisplus.core.handlers.MybatisEnumTypeHandler;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import java.util.Arrays;

public class EnumUtil {
    public static boolean isMpEnums(Class<?> enumClassType) {
        return MybatisEnumTypeHandler.isMpEnums(enumClassType);
    }

    public static Class<?> getEnumFieldSaveDbType(Class<?> enumClassType) {
        if (enumClassType.isEnum()) {
            if (EnumUtil.isMpEnums(enumClassType)) {
                if (IEnum.class.isAssignableFrom(enumClassType)) {
                    return ReflectionKit.getSuperClassGenericType(enumClassType, IEnum.class, (int)0);
                }
                return Arrays.stream(enumClassType.getDeclaredFields()).filter(field -> field.isAnnotationPresent(EnumValue.class)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Could not find @EnumValue in Class: %s.", enumClassType.getName()))).getType();
            }
            return String.class;
        }
        throw new IllegalArgumentException(String.format("Class: %s \u975e\u679a\u4e3e\u7c7b\u578b", enumClassType.getName()));
    }
}

