/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.magic.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.util.ClassUtils;

public class SpringContextUtil {
    private static ApplicationContext applicationContext;

    public SpringContextUtil(ApplicationContext applicationContext) {
        SpringContextUtil.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static String getProperty(String key) {
        return null == applicationContext ? null : applicationContext.getEnvironment().getProperty(key);
    }

    public static String getApplicationName() {
        return SpringContextUtil.getProperty("spring.application.name");
    }

    public static String[] getActiveProfiles() {
        return null == applicationContext ? null : applicationContext.getEnvironment().getActiveProfiles();
    }

    public static String getActiveProfile() {
        String[] activeProfiles = SpringContextUtil.getActiveProfiles();
        if (activeProfiles != null && activeProfiles.length > 0) {
            return activeProfiles[0];
        }
        return null;
    }

    public static void publishEvent(ApplicationEvent event) {
        ApplicationContext context = SpringContextUtil.getApplicationContext();
        if (null != context) {
            context.publishEvent(event);
        }
    }

    public static <T> List<T> getBeansOfTypeList(Class<T> clazz) {
        Map beansOfTypeMap = SpringContextUtil.getApplicationContext().getBeansOfType(clazz);
        if (beansOfTypeMap.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList(beansOfTypeMap.values());
    }

    public static <T> T getBeanOfType(Class<T> clazz) {
        return (T)SpringContextUtil.getApplicationContext().getBean(clazz);
    }

    public static String getBootPackage() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement stackTraceElement : stackTrace = new RuntimeException().getStackTrace()) {
            if (!"main".equals(stackTraceElement.getMethodName())) continue;
            return ClassUtils.getPackageName((String)stackTraceElement.getClassName());
        }
        throw new RuntimeException("\u672a\u627e\u5230\u4e3b\u9ed8\u8ba4\u5305");
    }

    public static Class<?> getApplicationClass() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement stackTraceElement : stackTrace = new RuntimeException().getStackTrace()) {
            if (!"main".equals(stackTraceElement.getMethodName())) continue;
            try {
                return Class.forName(stackTraceElement.getClassName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("\u672a\u627e\u5230\u4e3b\u9ed8\u8ba4\u5305");
    }
}

