/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.processer;

import com.google.auto.service.AutoService;
import com.tangzc.mpe.magic.util.AnnotationDefaultValueHelper;
import com.tangzc.mpe.processer.annotation.AutoDefine;
import com.tangzc.mpe.processer.annotation.AutoMapper;
import com.tangzc.mpe.processer.annotation.AutoRepository;
import com.tangzc.mpe.processer.builder.DefineBuilder;
import com.tangzc.mpe.processer.builder.MapperBuilder;
import com.tangzc.mpe.processer.builder.RepositoryBuilder;
import com.tangzc.mpe.processer.config.ConfigurationKey;
import com.tangzc.mpe.processer.config.MybatisPlusExtProcessConfig;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@AutoService(value={Processor.class})
public class AutoBuildProcessor
extends AbstractProcessor {
    private DefineBuilder defineBuilder;
    private MapperBuilder mapperBuilder;
    private RepositoryBuilder repositoryBuilder;
    private MybatisPlusExtProcessConfig mybatisPlusExtProcessConfig;
    private Class<? extends Annotation> globalAnnotationClass;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        Types typeUtils = processingEnv.getTypeUtils();
        Elements elementUtils = processingEnv.getElementUtils();
        Filer filer = processingEnv.getFiler();
        Messager messager = processingEnv.getMessager();
        this.mybatisPlusExtProcessConfig = MybatisPlusExtProcessConfig.getInstance(filer);
        this.defineBuilder = new DefineBuilder(filer, messager, typeUtils, elementUtils, this.mybatisPlusExtProcessConfig);
        this.mapperBuilder = new MapperBuilder(filer, messager, typeUtils, elementUtils, this.mybatisPlusExtProcessConfig);
        this.repositoryBuilder = new RepositoryBuilder(filer, messager, typeUtils, elementUtils, this.mybatisPlusExtProcessConfig, this.mapperBuilder);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annoations, RoundEnvironment env) {
        if (annoations.isEmpty()) {
            return true;
        }
        Set<? extends Element> rootElements = env.getRootElements();
        for (Element element : rootElements) {
            AutoRepository autoRepository;
            AutoDefine autoDefine;
            if (element.getKind() != ElementKind.CLASS) continue;
            boolean withGlobalAnnotation = false;
            if (this.globalAnnotationClass != null) {
                boolean bl = withGlobalAnnotation = element.getAnnotation(this.globalAnnotationClass) != null;
            }
            if ((autoDefine = this.findAnnotation(element, AutoDefine.class, withGlobalAnnotation)) != null) {
                this.defineBuilder.buildDefine((TypeElement)element, autoDefine);
            }
            String fullMapperName = null;
            AutoMapper autoMapper = this.findAnnotation(element, AutoMapper.class, withGlobalAnnotation);
            if (autoMapper != null) {
                fullMapperName = this.mapperBuilder.buildMapper((TypeElement)element, autoMapper);
            }
            if ((autoRepository = this.findAnnotation(element, AutoRepository.class, withGlobalAnnotation)) == null) continue;
            if (fullMapperName == null) {
                autoMapper = (AutoMapper)AnnotationDefaultValueHelper.getAnnotationWithDefaultValues(AutoMapper.class, null);
                fullMapperName = this.mapperBuilder.buildMapper((TypeElement)element, autoMapper);
            }
            this.repositoryBuilder.buildRepository((TypeElement)element, autoRepository, fullMapperName);
        }
        return true;
    }

    private <ANNO extends Annotation> ANNO findAnnotation(Element typeElement, Class<ANNO> annotationClass, boolean isFindDefault) {
        Object annotation = typeElement.getAnnotation(annotationClass);
        if (annotation == null && isFindDefault) {
            annotation = AnnotationDefaultValueHelper.getAnnotationWithDefaultValues(annotationClass, null);
        }
        return annotation;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        boolean isGlobalMode;
        HashSet<String> supportedAnnotations = new HashSet<String>();
        supportedAnnotations.add(AutoDefine.class.getCanonicalName());
        supportedAnnotations.add(AutoMapper.class.getCanonicalName());
        supportedAnnotations.add(AutoRepository.class.getCanonicalName());
        String globalEnable = this.mybatisPlusExtProcessConfig.get(ConfigurationKey.GLOBAL_ENABLE);
        boolean bl = isGlobalMode = "true".equalsIgnoreCase(globalEnable) || "on".equalsIgnoreCase(globalEnable);
        if (isGlobalMode) {
            String globalAnnotationName = this.mybatisPlusExtProcessConfig.get(ConfigurationKey.GLOBAL_ENABLE_ANNOTATION);
            if (!globalAnnotationName.matches("^([a-zA-Z$][a-zA-Z\\d_$]*\\.)*([a-zA-Z$][a-zA-Z\\d_$]*)$")) {
                throw new RuntimeException("\u3010\u4ee3\u7801\u751f\u6210\u3011\u914d\u7f6e\u7684\u5168\u5c40\u6ce8\u89e3\u7c7b\u540d\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a\"" + globalAnnotationName + "\"");
            }
            supportedAnnotations.add(globalAnnotationName);
            try {
                this.globalAnnotationClass = Class.forName(globalAnnotationName);
            }
            catch (Exception e) {
                throw new RuntimeException("\u3010\u4ee3\u7801\u751f\u6210\u3011\u672a\u627e\u5230\u5168\u5c40\u6ce8\u89e3", e);
            }
        }
        return supportedAnnotations;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

