/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.processer.builder;

import com.tangzc.mpe.processer.config.ConfigurationKey;
import com.tangzc.mpe.processer.config.MybatisPlusExtProcessConfig;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Objects;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public abstract class BaseBuilder {
    protected final Filer filer;
    protected final Messager messager;
    protected final Elements elementUtils;
    protected final MybatisPlusExtProcessConfig mybatisPlusExtProcessConfig;

    protected BaseBuilder(Filer filer, Messager messager, Elements elementUtils, MybatisPlusExtProcessConfig mybatisPlusExtProcessConfig) {
        this.filer = filer;
        this.messager = messager;
        this.elementUtils = elementUtils;
        this.mybatisPlusExtProcessConfig = mybatisPlusExtProcessConfig;
    }

    protected String getTargetPackageName(TypeElement classElement, String customPackagePath) {
        String entityPackagePath = this.elementUtils.getPackageOf(classElement).getQualifiedName().toString();
        Object packageName = entityPackagePath;
        if (!"".equals(customPackagePath)) {
            if (((String)customPackagePath).startsWith(".")) {
                customPackagePath = ((String)customPackagePath).substring(1);
                String basePackageName = entityPackagePath;
                while (((String)customPackagePath).startsWith(".")) {
                    customPackagePath = ((String)customPackagePath).substring(1);
                    int lastIndexOfPoint = basePackageName.lastIndexOf(".");
                    if (lastIndexOfPoint != -1) {
                        basePackageName = basePackageName.substring(0, lastIndexOfPoint);
                        continue;
                    }
                    basePackageName = "";
                }
                if (!((String)customPackagePath).isEmpty() && !basePackageName.isEmpty()) {
                    customPackagePath = "." + (String)customPackagePath;
                }
                packageName = basePackageName + (String)customPackagePath;
            } else {
                packageName = customPackagePath;
            }
        }
        return packageName;
    }

    protected String getTargetName(String customName, String entityName, String suffix) {
        Object name = !"".equals(customName) ? customName : entityName + suffix;
        return name;
    }

    protected void writeToFile(String path, List<String> lines) {
        try {
            JavaFileObject file = this.filer.createSourceFile(path, new Element[0]);
            try (PrintWriter writer = new PrintWriter(file.openWriter());){
                lines.stream().filter(Objects::nonNull).forEach(writer::println);
            }
        }
        catch (FilerException e) {
            if (e.getMessage().startsWith("Attempt to recreate a file for type ")) {
                return;
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean isExist(String packageName, String fileName) {
        if (!((String)fileName).endsWith(".java")) {
            fileName = (String)fileName + ".java";
        }
        FileObject fileObject = null;
        try {
            fileObject = this.filer.getResource(StandardLocation.SOURCE_PATH, packageName, (CharSequence)fileName);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (fileObject != null) {
            this.log("\u5b58\u5728\u8df3\u8fc7:" + packageName + "." + (String)fileName);
            return true;
        }
        this.log("\u81ea\u52a8\u521b\u5efa:" + packageName + "." + (String)fileName);
        return false;
    }

    protected void log(String msg) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, msg);
    }

    protected void warn(String msg) {
        this.messager.printMessage(Diagnostic.Kind.WARNING, msg);
    }

    protected String getValueOrDefault(String value, ConfigurationKey entityDefineSuffix) {
        if (value.isEmpty()) {
            value = this.mybatisPlusExtProcessConfig.get(entityDefineSuffix);
        }
        return value;
    }
}

