/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.processer.builder;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.squareup.javapoet.ClassName;
import com.tangzc.mpe.autotable.annotation.Table;
import com.tangzc.mpe.processer.annotation.AutoMapper;
import com.tangzc.mpe.processer.builder.BaseBuilder;
import com.tangzc.mpe.processer.config.ConfigurationKey;
import com.tangzc.mpe.processer.config.MybatisPlusExtProcessConfig;
import java.util.Arrays;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class MapperBuilder
extends BaseBuilder {
    private final Elements elementUtils;

    public MapperBuilder(Filer filer, Messager messager, Types typeUtils, Elements elementUtils, MybatisPlusExtProcessConfig mybatisPlusExtProcessConfig) {
        super(filer, messager, elementUtils, mybatisPlusExtProcessConfig);
        this.elementUtils = elementUtils;
    }

    public String buildMapper(TypeElement element, AutoMapper autoMapper) {
        String entityPackageName = this.elementUtils.getPackageOf(element).getQualifiedName().toString();
        String entityName = element.getSimpleName().toString();
        String suffix = this.getMapperSuffix(autoMapper);
        String mapperName = this.getTargetName(autoMapper.value(), entityName, suffix);
        String packageName = this.getValueOrDefault(autoMapper.packageName(), ConfigurationKey.MAPPER_PACKAGE_NAME);
        String mapperPackageName = this.getTargetPackageName(element, packageName);
        String filePath = mapperPackageName + "." + mapperName;
        if (this.isExist(mapperPackageName, mapperName)) {
            return filePath;
        }
        ClassName mapperSuperclassName = this.getMapperSuperclassName(autoMapper);
        String dsAnnoImport = null;
        String dsAnno = null;
        if (autoMapper.withDSAnnotation()) {
            Table table = element.getAnnotation(Table.class);
            if (table != null && !table.dsName().isEmpty()) {
                dsAnnoImport = "import com.baomidou.dynamic.datasource.annotation.DS;";
                dsAnno = "@DS(\"" + table.dsName() + "\")";
            } else {
                this.warn(entityPackageName + "." + entityName + "\u7f3a\u5c11@Table\u7684dsName\u914d\u7f6e\uff0c\u65e0\u6cd5\u4e3a" + mapperPackageName + "." + mapperName + "\u6dfb\u52a0@DS ");
            }
        }
        List<String> lines = Arrays.asList("package " + mapperPackageName + ";", "", "import " + mapperSuperclassName.canonicalName() + ";", dsAnnoImport, "import " + entityPackageName + "." + entityName + ";", "import org.apache.ibatis.annotations.Mapper;", "", dsAnno, "@Mapper", "public interface " + mapperName + " extends " + mapperSuperclassName.simpleName() + "<" + entityName + "> {", "}");
        this.writeToFile(filePath, lines);
        return filePath;
    }

    private ClassName getMapperSuperclassName(AutoMapper autoMapper) {
        ClassName mapperSuperclassName = ClassName.get(BaseMapper.class);
        String baseMapperClassName = autoMapper.superclassName();
        if (baseMapperClassName.isEmpty()) {
            baseMapperClassName = this.mybatisPlusExtProcessConfig.get(ConfigurationKey.MAPPER_SUPERCLASS_NAME);
        }
        if (!baseMapperClassName.isEmpty()) {
            int lastIndexOf = baseMapperClassName.lastIndexOf(".");
            String baseMapperPackageName = baseMapperClassName.substring(0, lastIndexOf);
            String baseMapperName = baseMapperClassName.substring(lastIndexOf + 1);
            mapperSuperclassName = ClassName.get((String)baseMapperPackageName, (String)baseMapperName, (String[])new String[0]);
        }
        return mapperSuperclassName;
    }

    private String getMapperSuffix(AutoMapper autoMapper) {
        String suffix = autoMapper.suffix();
        if ("".equals(suffix)) {
            suffix = this.mybatisPlusExtProcessConfig.get(ConfigurationKey.MAPPER_SUFFIX);
        }
        return suffix;
    }
}

